/*******************************************************************************************************/
CREATE OR REPLACE FORCE VIEW w83b.comprobardatosusuario (dni_001,
                                                         nombre_001,
                                                         apel1_001,
                                                         apel2_001,
                                                         c_territ_051,
                                                         calle_051,
                                                         num_051,
                                                         piso_051,
                                                         letra_051,
                                                         cp_051,
                                                         localidad_051,
                                                         ds_o,
                                                         telefono1_051,
                                                         telefono2_o51,
                                                         fax_051,
                                                         reg_manual_051,
                                                         nummod_051,
                                                         nummodsal_051
                                                        )
AS
   SELECT usu.dni_001, nombre_001, apel1_001, apel2_001, deleg.c_territ_051,
          deleg.calle_051, deleg.num_051, deleg.piso_051, deleg.letra_051,
          deleg.cp_051, deleg.localidad_051, municipio.ds_o,
          deleg.telefono1_051, deleg.telefono2_o51, deleg.fax_051,
          deleg.reg_manual_051, deleg.nummod_051, deleg.nummodsal_051
     FROM w83b01s00 usu LEFT OUTER JOIN w83b51s00 deleg
          ON usu.c_territ_001 = deleg.c_territ_051
          LEFT OUTER JOIN t17i.t17_municipio municipio
          ON deleg.localidad_051 = municipio.ID
        AND deleg.c_territ_051 = municipio.provincia_id
    WHERE (   usu.f_baja_001 IS NULL
           OR (    usu.f_baja_001 IS NOT NULL
               AND TO_DATE (SYSDATE, 'dd/MM/yyyy') <
                                        TO_DATE (usu.f_baja_001, 'dd/MM/yyyy')
              )
          );
/*******************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."IMPUGNUMCOMP" ("N_ACTA", "AGNO_ACTA", "C_TERRIT", "VER", "FECHAENTRADA", "OBSERVACIONES", "CODCENTRO", "CODIGOCENTRO", "RAZONSOCIAL", "DOMICILIOCENTRO", "N_IMPUG", "AGNO_IMPUG", "F_IMPUG", "FECHABAJA", "RESULTADOLAUDOS", "FDESES", "FENVARB", "NUMIMPCOMP", "DNIARB", "NOMARB", "FLAUDOLAUDOS", "ANYOLAUDOLAUDOS", "NUMLAUDOLAUDOS", "DESCEUSRESULTADOLAUDO", "DESCRESULTADOLAUDO", "NUMLAUDOCOMP", "ORDERBY")
                                AS
  SELECT actas.n_acta_016       AS n_acta,
    actas.ano_acta_016          AS agno_acta,
    actas.c_territ_016          AS c_territ,
    actas.version_016           AS ver,
    actas.f_entra_016           AS fechaentrada,
    actas.observ_016            AS observaciones,
    actas.id_centro_016         AS codcentro,
    centros.ccen_001            AS codigocentro,
    centros.rsoc_001            AS razonsocial,
    centros.domic_001           AS domiciliocentro,
    impugnaciones.n_impug_033   AS n_impug,
    impugnaciones.ano_impug_033 AS agno_impug,
    impugnaciones.f_impug_033   AS f_impug,
    actas.f_baja_016            AS fechabaja,
    laudos.rdo_laudo_068        AS resultadolaudos,
    impugnaciones.fdeses_033    AS fdeses,
    impugnaciones.fenvarb_033   AS fenvarb,
    TO_NUMBER ( impugnaciones.ano_impug_033
    || DECODE (LENGTH (TO_CHAR (impugnaciones.n_impug_033)), 1, '00000'
    || TO_CHAR (impugnaciones.n_impug_033), 2, '0000'
    || TO_CHAR (impugnaciones.n_impug_033), 3, '000'
    || TO_CHAR (impugnaciones.n_impug_033), 4, '00'
    || TO_CHAR (impugnaciones.n_impug_033), 5, '0'
    || TO_CHAR (impugnaciones.n_impug_033), TO_CHAR (impugnaciones.n_impug_033) ) ) AS numimpcomp,
    arbitros.dni_036                                                                AS dniarb,
    arbitros.nombre_036                                                             AS nomarb,
    laudos.flaudo_068                                                               AS flaudolaudos,
    laudos.ano_laudo_068                                                            AS anyolaudolaudos,
    laudos.n_laudo_068                                                              AS numlaudolaudos,
    tres.desc_rdo_eus_075                                                           AS desceusresultadolaudo,
    tres.desc_rdo_cas_075                                                           AS descresultadolaudo,
    TO_NUMBER ( laudos.ano_laudo_068
    || DECODE (LENGTH (TO_CHAR (laudos.n_laudo_068)), 1, '00'
    || TO_CHAR (laudos.n_laudo_068), 2, '0'
    || TO_CHAR (laudos.n_laudo_068), TO_CHAR (laudos.n_laudo_068) ) ) AS numlaudocomp,
    1                                                                 AS orderby
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b33s00 impugnaciones,
    w83b68s00 laudos,
    w83b75s00 tres,
    w83b36s00 arbitros
  WHERE actas.id_centro_016       = centros.ccen_001
  AND actas.n_acta_016            = impugnaciones.n_acta_033
  AND actas.ano_acta_016          = impugnaciones.ano_acta_033
  AND actas.c_territ_016          = impugnaciones.c_territ_033
  AND actas.version_016           = impugnaciones.version_033
  AND impugnaciones.n_impug_033   = laudos.n_impug_068(+)
  AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
  AND impugnaciones.c_territ_033  = laudos.c_territ_068(+)
  AND laudos.rdo_laudo_068        = tres.id_rdo_075(+)
  AND impugnaciones.dni_033       = arbitros.dni_036
  AND impugnaciones.c_territ_033  = arbitros.c_territ_036
  --AND tprov.ID = impugnaciones.c_territ_033
  UNION ALL
  SELECT preavisos.n_preaviso_037 AS n_acta,
    preavisos.ano_preaviso_037    AS agno_acta,
    preavisos.c_territ_037        AS c_territ,
    0                             AS ver,
    preavisos.f_entra_037         AS fechaentrada,
    preavisos.observ_037          AS observaciones,
    preavisos.id_centro_037       AS codcentro,
    centros.ccen_001              AS codigocentro,
    centros.rsoc_001              AS razonsocial,
    centros.domic_001             AS domiciliocentro,
    impugnaciones.n_impug_033     AS n_impug_033,
    impugnaciones.ano_impug_033   AS agno_impug,
    impugnaciones.f_impug_033     AS f_impug,
    NULL                          AS fechabaja,
    laudos.rdo_laudo_068          AS resultadolaudos,
    impugnaciones.fdeses_033,
    impugnaciones.fenvarb_033,
    TO_NUMBER ( impugnaciones.ano_impug_033
    || DECODE (LENGTH (TO_CHAR (impugnaciones.n_impug_033)), 1, '00000'
    || TO_CHAR (impugnaciones.n_impug_033), 2, '0000'
    || TO_CHAR (impugnaciones.n_impug_033), 3, '000'
    || TO_CHAR (impugnaciones.n_impug_033), 4, '00'
    || TO_CHAR (impugnaciones.n_impug_033), 5, '0'
    || TO_CHAR (impugnaciones.n_impug_033), TO_CHAR (impugnaciones.n_impug_033) ) ) AS numimpcomp,
    arbitros.dni_036,
    arbitros.nombre_036,
    laudos.flaudo_068     AS flaudolaudos,
    laudos.ano_laudo_068  AS anyolaudolaudos,
    laudos.n_laudo_068    AS numlaudolaudos,
    tres.desc_rdo_eus_075 AS desceusresultadolaudo,
    tres.desc_rdo_cas_075 AS descresultadolaudo,
    TO_NUMBER ( laudos.ano_laudo_068
    || DECODE (LENGTH (TO_CHAR (laudos.n_laudo_068)), 1, '00'
    || TO_CHAR (laudos.n_laudo_068), 2, '0'
    || TO_CHAR (laudos.n_laudo_068), TO_CHAR (laudos.n_laudo_068) ) ) AS numlaudocomp,
    2                                                                 AS orderby
  FROM w83b37s00 preavisos,
    j7301s01 centros,
    w83b33s00 impugnaciones,
    w83b68s00 laudos,
    w83b75s00 tres,
    w83b36s00 arbitros
  WHERE preavisos.id_centro_037   = centros.ccen_001
  AND preavisos.n_preaviso_037    = impugnaciones.n_preaviso_033
  AND preavisos.ano_preaviso_037  = impugnaciones.ano_preaviso_033
  AND preavisos.c_territ_037      = impugnaciones.c_territ_033
  AND impugnaciones.n_impug_033   = laudos.n_impug_068(+)
  AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
  AND impugnaciones.c_territ_033  = laudos.c_territ_068(+)
  AND laudos.rdo_laudo_068        = tres.id_rdo_075(+)
  AND impugnaciones.dni_033       = arbitros.dni_036
  AND impugnaciones.c_territ_033  = arbitros.c_territ_036
    --AND tprov.ID = impugnaciones.c_territ_033
  ORDER BY c_territ,
    dniarb,
    agno_impug,
    n_impug,
    orderby;
/*******************************************************************************************************************************************************/ 
 CREATE OR REPLACE FORCE VIEW "W83B"."NUMDELEGMESCERRAR" ("NACTA", "TERRIT", "ANOACTA", "VER", "ANOREGDEF", "NREGDEF", "FELEC", "TOTALELECTORES", "NUMDELEGADOS", "SINDDESC", "SIGLAS", "CODSINDICATO", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO")
AS
  SELECT consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver,
    consulta.anoregdef,
    consulta.nregdef,
    TO_CHAR (consulta.felec, 'dd/MM/yyyy'),
    consulta.totalelectores,
    consulta.numdelegados,
    consulta.sinddesc,
    consulta.siglas,
    consulta.codsindicato,
    consulta.actatotal,
    consulta.fechabaja,
    consulta.fecharegistro
  FROM
    (SELECT actas.n_acta_016    AS nacta,
      actas.c_territ_016        AS territ,
      actas.ano_acta_016        AS anoacta,
      actas.version_016         AS ver,
      actas.ano_regdef_016      AS anoregdef,
      actas.n_reg_016           AS nregdef,
      actas.f_elecc_016         AS felec,
      actas.totelec_016         AS totalelectores,
      COUNT (delegados.dni_025) AS numdelegados,
      sindicatos.desc_019       AS sinddesc,
      sindicatos.siglas_019     AS siglas,
      sindicatos.c_sindi_019    AS codsindicato,
      actas.n_acttot_016        AS actatotal,
      actas.f_baja_016          AS fechabaja,
      actas.fregdef_016         AS fecharegistro
    FROM w83b16s00 actas,
      w83b25s00 delegados,
      w83b19s00 sindicatos
    WHERE actas.n_acta_016    = delegados.n_acta_025
    AND actas.ano_acta_016    = delegados.ano_acta_025
    AND actas.c_territ_016    = delegados.c_territ_025
    AND actas.version_016     = delegados.version_025
    AND actas.validada_016    = 1
    AND delegados.c_sindi_025 = sindicatos.c_sindi_019(+)
    GROUP BY actas.n_acta_016,
      actas.c_territ_016,
      actas.ano_acta_016,
      actas.version_016,
      actas.ano_regdef_016,
      actas.n_reg_016,
      actas.f_elecc_016,
      actas.totelec_016,
      sindicatos.desc_019,
      sindicatos.siglas_019,
      sindicatos.c_sindi_019,
      actas.n_acttot_016,
      actas.f_baja_016,
      actas.fregdef_016
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND act.validada_016 = 1
    )
  ORDER BY consulta.nacta ASC,
    consulta.anoacta ASC,
    consulta.territ ASC;
	
/**********************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."T17VAUTONOMIA" ("ID", "DS_O", "AUTONOMIA_ID")
AS
  SELECT ID, ds_o, autonomia_id FROM t17i.t17_provincia;
  
/****************************************************************************************************/
  
  CREATE OR REPLACE FORCE VIEW "W83B"."VIEW_ACTAS" ("C_TERRIT_011", "ANO_ELEC_011", "N_ACTA_011", "F_ELECC_011", "F_BAJA_011", "C_CENTRO_011", "N_ACTTOT_011", "N_REGDEF_011", "FREGDEF_011", "TOTTRAB_011", "VERSION_011")
AS
  SELECT TO_NUMBER(C_TERRIT_016),
    ANO_ACTA_016,
    N_ACTA_016,
    F_ELECC_016,
    F_BAJA_016,
    ID_CENTRO_016,
    N_ACTTOT_016,
    N_REGDEF_016,
    FREGDEF_016,
    TOTELEC_016,
    VERSION_016
  FROM W83B16T00
  WHERE ( C_TERRIT_016,ANO_ACTA_016,N_ACTA_016,VERSION_016) IN
    (SELECT C_TERRIT_016,
      ANO_ACTA_016,
      N_ACTA_016,
      MAX(VERSION_016)AS VERSION_016
    FROM W83B16T00
    WHERE validada_016 = 1
    GROUP BY C_TERRIT_016,
      ANO_ACTA_016,
      N_ACTA_016
    );

/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."VIEW_DELEGADOS" ("C_TERRIT_014", "ANO_ELEC_014", "N_ACTA_014", "DNI_014", "C_SINDI_014", "NOMBRE_014", "APEL1_014", "APEL2_014", "F_ALTA_014", "SEXO_014", "F_BAJA_014", "VERSION_014")
AS
  SELECT consulta.c_territ_025,
    consulta.ano_acta_025,
    consulta.n_acta_025,
    consulta.dni_025,
    consulta.c_sindi_025,
    consulta.nombre_025,
    consulta.apel1_025,
    consulta.apel2_025,
    consulta.f_alta_025,
    consulta.sexo_025,
    consulta.f_baja_025,
    consulta.version_025
  FROM
    (SELECT TO_NUMBER(c_territ_025) AS c_territ_025,
      ano_acta_025,
      n_acta_025,
      dni_025,
      c_sindi_025,
      nombre_025,
      apel1_025,
      apel2_025,
      f_alta_025,
      sexo_025,
      f_baja_025,
      version_025
    FROM w83b25t00
    ) consulta
  WHERE consulta.version_025 =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.n_acta_025 = act.n_acta_016
    AND consulta.ano_acta_025 = act.ano_acta_016
    AND consulta.c_territ_025 = act.c_territ_016
    AND act.validada_016      = 1
    );
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."VIEW_SINDICATOS" ("CSINDI_003", "DESC_003", "SIGLAS_003")
AS
  SELECT C_SINDI_019,DESC_019,SIGLAS_019 FROM W83B19T00;
  
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83ACOMBOCAPVYTERRITORIO" ("DS_O", "ID")
AS
  SELECT 'CAPV', '0' FROM t17i.t17_provincia WHERE 1 = 1 AND ROWNUM = 1
  UNION ALL
  SELECT ds_o, ID FROM t17i.t17_provincia WHERE autonomia_id = 16;
  
/****************************************************************************************************************************************************************/
CREATE OR REPLACE VIEW w83b01v00 (numpreaviso_completo,
                                  cod_territorio,
                                  anyo_eleccion,
                                  numpreaviso,
                                  numpreavisosencilloentero,
                                  fecha_entrada,
                                  fecha_inicio,
                                  fecha_eleccion,
                                  num_registro,
                                  fecha_registro,
                                  razon_social,
                                  id_centrotrabajo,
                                  cod_territorio_centro,
                                  cif,
                                  num_centro,
                                  territorio_cas,
                                  territorio_eus,
                                  cod_municipio,
                                  municipio_cas,
                                  municipio_eus,
                                  localidad,
                                  domicilio,
                                  cod_postal,
                                  num_trabajadores,
                                  eleccion_parcial,
                                  preaviso_global,
                                  cod_convenio,
                                  desc_convenio,
                                  dese_convenio,
                                  admon_empresa,
                                  numcentros_afectados,
                                  observaciones,
                                  anyo_acta,
                                  num_acta,
                                  diralternativa,
                                  codpostalalternativa,
                                  idprovincia_alt,
                                  codmunicipio_alt,
                                  cod_tramite,
                                  f_actu_tramite,
                                  f_modif_tramite,
                                  cods_promotores,
                                  desc_promotores,
                                  dese_promotores,
                                  npreavisosint,
                                  npreavisointcompleto,
								  tipoPreaviso
                                 )
AS
   SELECT DISTINCT (   t37.c_territ_037
                    || '/'
                    || t37.ano_preaviso_037
                    || '/'
                    || t37.n_preaviso_037
                   ),
                   t37.c_territ_037, t37.ano_preaviso_037, t37.n_preaviso_037,
                   TO_CHAR (DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)),
                                    1, '00000' || TO_CHAR (t37.n_preaviso_037),
                                    2, '0000' || TO_CHAR (t37.n_preaviso_037),
                                    3, '000' || TO_CHAR (t37.n_preaviso_037),
                                    4, '00' || TO_CHAR (t37.n_preaviso_037),
                                    5, '0' || TO_CHAR (t37.n_preaviso_037),
                                    TO_CHAR (t37.n_preaviso_037)
                                   )
                           ),
                   t37.f_entra_037, t37.f_inicio_037, t37.f_elecc_037,
                   t37.n_regis_037, t37.f_regis_037, centros.razonsocial,
                   centros.codcentro,
                   DECODE (LENGTH (TO_CHAR (centros.codterritorio)),
                           1, '0' || TO_CHAR (centros.codterritorio),
                           TO_CHAR (centros.codterritorio)
                          ),
                   centros.cifnif, centros.ncentrotrabajo, centros.territorio,
                   centros.territorio_eusk,
                   DECODE (LENGTH (TO_CHAR (centros.codmunicipio)),
                           1, '00' || TO_CHAR (centros.codmunicipio),
                           2, '0' || TO_CHAR (centros.codmunicipio),
                           TO_CHAR (centros.codmunicipio)
                          ),
                   centros.municipio, centros.municipio, centros.localidad,
                   centros.domicilio, centros.codpostal,
                   centros.num_trabajadores, t37.s_parcial_037,
                   t37.global_037, t37.c_conv_037, t13.desc_013, t13.dese_013,
                   t37.admonemp_037, NVL (t37.n_cenafec_037, ''),
                   t37.observ_037, t37.ano_acta_037,
                   DECODE (LENGTH (TO_CHAR (t37.n_acta_037)),
                           1, '00000' || TO_CHAR (t37.n_acta_037),
                           2, '0000' || TO_CHAR (t37.n_acta_037),
                           3, '000' || TO_CHAR (t37.n_acta_037),
                           4, '00' || TO_CHAR (t37.n_acta_037),
                           5, '0' || TO_CHAR (t37.n_acta_037),
                           TO_CHAR (t37.n_acta_037)
                          ),
                   t37.dir_alt_037, t37.codpos_alt_037, t37.prov_alt_037,
                   t37.mun_alt_037, t56.c_tram_056, t56.f_actu_056,
                   t56.f_modif_056,
                                   /*COUNT (t33.c_impug_033),*/
                                   stragg (t19.c_sindi_019),
                   stragg_int (t19.desc_019 || '@' || t19.c_sindi_019),
                   stragg_int (t19.dese_019 || '@' || t19.c_sindi_019),
                   TO_NUMBER
                      (   t37.ano_preaviso_037
                       || DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)),
                                  1, '00000' || TO_CHAR (t37.n_preaviso_037),
                                  2, '0000' || TO_CHAR (t37.n_preaviso_037),
                                  3, '000' || TO_CHAR (t37.n_preaviso_037),
                                  4, '00' || TO_CHAR (t37.n_preaviso_037),
                                  5, '0' || TO_CHAR (t37.n_preaviso_037),
                                  TO_CHAR (t37.n_preaviso_037)
                                 )
                      ) AS npreavisoint,
                   TO_NUMBER
                      (   t37.c_territ_037
                       || t37.ano_preaviso_037
                       || DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)),
                                  1, '00000' || TO_CHAR (t37.n_preaviso_037),
                                  2, '0000' || TO_CHAR (t37.n_preaviso_037),
                                  3, '000' || TO_CHAR (t37.n_preaviso_037),
                                  4, '00' || TO_CHAR (t37.n_preaviso_037),
                                  5, '0' || TO_CHAR (t37.n_preaviso_037),
                                  TO_CHAR (t37.n_preaviso_037)
                                 )
                      ) AS npreavisointcompleto
					  ,					  t37.TIPO_PREAV_037
              FROM W83B27T00 t27,
                   W83B19T00 t19,
                   /*w83b33t00 t33,*/
                   w83bcentrotrabajo centros,
                   W83B37T00 t37,
                   W83B13T00 t13,
                   W83B56T00 t56
             WHERE     /*t37.ano_preaviso_037 = t33.ano_preaviso_033(+)
                   AND t37.c_territ_037 = t33.c_territ_033(+)
                   AND t37.n_preaviso_037 = t33.n_preaviso_033(+)
                   AND */ centros.codcentro = t37.id_centro_037
               AND t37.c_territ_037 = t27.c_territ_027(+)
               AND t37.ano_preaviso_037 = t27.ano_preaviso_027(+)
               AND t37.n_preaviso_037 = t27.n_preaviso_027(+)
               AND t27.c_sindi_027 = t19.c_sindi_019(+)
               AND t37.c_conv_037 = t13.c_conv_013(+)
               AND t37.ano_preaviso_037 = t56.ano_preaviso_056(+)
               AND t37.c_territ_037 = t56.c_territ_056(+)
               AND t37.n_preaviso_037 = t56.n_preaviso_056(+)
          GROUP BY    t37.c_territ_037
                   || '/'
                   || t37.ano_preaviso_037
                   || '/'
                   || t37.n_preaviso_037,
                   t37.c_territ_037,
                   t37.ano_preaviso_037,
                   t37.n_preaviso_037,
                   t37.f_entra_037,
                   t37.f_inicio_037,
                   t37.f_elecc_037,
                   t37.n_regis_037,
                   t37.f_regis_037,
                   centros.razonsocial,
                   centros.codcentro,
                   centros.codterritorio,
                   centros.cifnif,
                   centros.ncentrotrabajo,
                   centros.territorio,
                   centros.territorio_eusk,
                   centros.codmunicipio,
                   centros.municipio,
                   centros.municipio,
                   centros.localidad,
                   centros.domicilio,
                   centros.codpostal,
                   centros.num_trabajadores,
                   t37.s_parcial_037,
                   t37.global_037,
                   t37.c_conv_037,
                   t13.desc_013,
                   t13.dese_013,
                   t37.admonemp_037,
                   NVL (t37.n_cenafec_037, ''),
                   t37.observ_037,
                   t37.ano_acta_037,
                   DECODE (LENGTH (TO_CHAR (t37.n_acta_037)),
                           1, '00000' || TO_CHAR (t37.n_acta_037),
                           2, '0000' || TO_CHAR (t37.n_acta_037),
                           3, '000' || TO_CHAR (t37.n_acta_037),
                           4, '00' || TO_CHAR (t37.n_acta_037),
                           5, '0' || TO_CHAR (t37.n_acta_037),
                           TO_CHAR (t37.n_acta_037)
                          ),
                   t37.dir_alt_037,
                   t37.codpos_alt_037,
                   t37.prov_alt_037,
                   t37.mun_alt_037,
                   t56.c_tram_056,
                   t56.f_actu_056,
                   t56.f_modif_056,
				    t37.TIPO_PREAV_037;



	
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83B01V00SINCENTRO" ("NUMPREAVISO_COMPLETO", "COD_TERRITORIO", "ANYO_ELECCION", "NUMPREAVISO", "FECHA_ENTRADA", "FECHA_INICIO", "FECHA_ELECCION", "NUM_REGISTRO", "FECHA_REGISTRO", "ID_CENTROTRABAJO", "ELECCION_PARCIAL", "PREAVISO_GLOBAL", "COD_CONVENIO", "DESC_CONVENIO", "DESE_CONVENIO", "ADMON_EMPRESA", "NUMCENTROS_AFECTADOS", "OBSERVACIONES", "ANYO_ACTA", "NUM_ACTA", "DIRALTERNATIVA", "IDPROVINCIA_ALT", "CODMUNICIPIO_ALT", "COD_TRAMITE", "F_ACTU_TRAMITE", "F_MODIF_TRAMITE", "NUMEROIMPUGNACIONES", "CODS_PROMOTORES", "DESC_PROMOTORES", "DESE_PROMOTORES", "NPREAVISOSINT", "NPREAVISOINTCOMPLETO")
AS
  SELECT t37.c_territ_037
    || '/'
    || t37.ano_preaviso_037
    || '/'
    || DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)), 1, '00000'
    || TO_CHAR (t37.n_preaviso_037), 2, '0000'
    || TO_CHAR (t37.n_preaviso_037), 3, '000'
    || TO_CHAR (t37.n_preaviso_037), 4, '00'
    || TO_CHAR (t37.n_preaviso_037), 5, '0'
    || TO_CHAR (t37.n_preaviso_037), TO_CHAR (t37.n_preaviso_037) ),
    t37.c_territ_037,
    t37.ano_preaviso_037,
    t37.n_preaviso_037,
    t37.f_entra_037,
    t37.f_inicio_037,
    t37.f_elecc_037,
    t37.n_regis_037,
    t37.f_regis_037,
    t37.id_centro_037,
    /* centros.razonsocial,
    centros.codcentro,
    DECODE (LENGTH (TO_CHAR (centros.codterritorio)),
    1, '0' || TO_CHAR (centros.codterritorio),
    TO_CHAR (centros.codterritorio)
    ),
    centros.cifnif, centros.ncentrotrabajo, centros.territorio,
    centros.territorio_eusk,
    DECODE (LENGTH (TO_CHAR (centros.codmunicipio)),
    1, '00' || TO_CHAR (centros.codmunicipio),
    2, '0' || TO_CHAR (centros.codmunicipio),
    TO_CHAR (centros.codmunicipio)
    ),
    centros.municipio, centros.municipio, centros.domicilio,
    centros.codpostal, centros.num_trabajadores,*/
    t37.s_parcial_037,
    t37.global_037,
    t37.c_conv_037,
    t13.desc_013,
    t13.dese_013,
    t37.admonemp_037,
    NVL (t37.n_cenafec_037, 0),
    t37.observ_037,
    t37.ano_acta_037,
    t37.n_acta_037,
    t37.dir_alt_037,
    t37.prov_alt_037,
    t37.mun_alt_037,
    t56.c_tram_056,
    t56.f_actu_056,
    t56.f_modif_056,
    COUNT (t33.c_impug_033),
    stragg (t19.c_sindi_019),
    stragg (t19.desc_019
    || '@'
    || t19.c_sindi_019),
    stragg (t19.dese_019
    || '@'
    || t19.c_sindi_019),
    TO_NUMBER ( t37.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)), 1, '00000'
    || TO_CHAR (t37.n_preaviso_037), 2, '0000'
    || TO_CHAR (t37.n_preaviso_037), 3, '000'
    || TO_CHAR (t37.n_preaviso_037), 4, '00'
    || TO_CHAR (t37.n_preaviso_037), 5, '0'
    || TO_CHAR (t37.n_preaviso_037), TO_CHAR (t37.n_preaviso_037) ) ) AS npreavisoint,
    TO_NUMBER ( t37.c_territ_037
    || t37.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (t37.n_preaviso_037)), 1, '00000'
    || TO_CHAR (t37.n_preaviso_037), 2, '0000'
    || TO_CHAR (t37.n_preaviso_037), 3, '000'
    || TO_CHAR (t37.n_preaviso_037), 4, '00'
    || TO_CHAR (t37.n_preaviso_037), 5, '0'
    || TO_CHAR (t37.n_preaviso_037), TO_CHAR (t37.n_preaviso_037) ) ) AS npreavisointcompleto
  FROM w83b37t00 t37,
    w83b33t00 t33,
    w83b19t00 t19,
    w83b27t00 t27,
    /*w83bcentrotrabajo centros,*/
    w83b13t00 t13,
    w83b56t00 t56
  WHERE t37.ano_preaviso_037 = t33.ano_preaviso_033(+)
  AND t37.c_territ_037       = t33.c_territ_033(+)
  AND t37.n_preaviso_037     = t33.n_preaviso_033(+)
    /*AND centros.codcentro = t37.id_centro_037*/
  AND t37.c_territ_037     = t27.c_territ_027
  AND t37.ano_preaviso_037 = t27.ano_preaviso_027
  AND t37.n_preaviso_037   = t27.n_preaviso_027
  AND t27.c_sindi_027      = t19.c_sindi_019
  AND t37.c_conv_037       = t13.c_conv_013(+)
  AND t37.ano_preaviso_037 = t56.ano_preaviso_056
  AND t37.c_territ_037     = t56.c_territ_056
  AND t37.n_preaviso_037   = t56.n_preaviso_056
  GROUP BY t37.c_territ_037
    || '/'
    || t37.ano_preaviso_037
    || '/'
    || t37.n_preaviso_037,
    t37.c_territ_037,
    t37.ano_preaviso_037,
    t37.n_preaviso_037,
    t37.f_entra_037,
    t37.f_inicio_037,
    t37.f_elecc_037,
    t37.n_regis_037,
    t37.f_regis_037,
    t37.id_centro_037,
    /*
    centros.razonsocial,
    centros.codcentro,
    centros.codterritorio,
    centros.cifnif,
    centros.ncentrotrabajo,
    centros.territorio,
    centros.territorio_eusk,
    centros.codmunicipio,
    centros.municipio,
    centros.municipio,
    centros.domicilio,
    centros.codpostal,
    centros.num_trabajadores,*/
    t37.s_parcial_037,
    t37.global_037,
    t37.c_conv_037,
    t13.desc_013,
    t13.dese_013,
    t37.admonemp_037,
    NVL (t37.n_cenafec_037, 0),
    t37.observ_037,
    t37.ano_acta_037,
    t37.n_acta_037,
    t37.dir_alt_037,
    t37.prov_alt_037,
    t37.mun_alt_037,
    t56.c_tram_056,
    t56.f_actu_056,
    t56.f_modif_056;
	
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83B02V00" ("NUMPREAVISO_COMPLETO", "COD_TERRITORIO", "ANYO_ELECCION", "NUMPREAVISO", "FECHA_INICIO", "FECHA_ELECCION", "RAZON_SOCIAL", "CIF", "NUM_CENTRO", "ELECCION_PARCIAL", "PREAVISO_GLOBAL", "COD_CONVENIO", "DESC_CONVENIO", "DESE_CONVENIO", "ADMON_EMPRESA", "NUMCENTROS_AFECTADOS", "OBSERVACIONES", "DIRALTERNATIVA", "CODPOSTALALTERNATIVA", "IDPROVINCIA_ALT", "CODMUNICIPIO_ALT", "CODS_PROMOTORES", "DESC_PROMOTORES", "DESE_PROMOTORES")
AS
  SELECT t53.c_territ_053
    || '/'
    || t53.ano_preaviso_053
    || '/'
    || t53.n_preaviso_053,
    t53.c_territ_053,
    t53.ano_preaviso_053,
    t53.n_preaviso_053,
    t53.f_inicio_053,
    t53.f_elecc_053,
    t53.raz_social_053,
    t53.nif_centro_053,
    t53.num_centro_053,
    t53.s_parcial_053,
    t53.global_053,
    t53.c_conv_053,
    t13.desc_013,
    t13.dese_013,
    t53.admonemp_053,
    NVL (t53.n_cenafec_053, ''),
    t53.observ_053,
    t53.dir_alt_053,
    t53.codpos_alt_053,
    t53.prov_alt_053,
    t53.mun_alt_053,
    stragg (t19.c_sindi_019),
    stragg (t19.desc_019
    || '@'
    || t19.c_sindi_019),
    stragg (t19.dese_019
    || '@'
    || t19.c_sindi_019)
  FROM w83b54t00 t54,
    w83b19t00 t19,
    w83b13t00 t13,
    w83b37t00 t37,
    w83b53t00 t53
  WHERE t37.c_conv_037     = t13.c_conv_013(+)
  AND t37.c_territ_037     = t54.c_territ_054(+)
  AND t37.ano_preaviso_037 = t54.ano_preaviso_054(+)
  AND t37.n_preaviso_037   = t54.n_preaviso_054(+)
  AND t54.c_sindi_054      = t19.c_sindi_019(+)
  AND t37.n_preaviso_037   = t53.n_preaviso_053
  AND t37.ano_preaviso_037 = t53.ano_preaviso_053
  AND t37.c_territ_037     = t53.c_territ_053
  GROUP BY t53.c_territ_053
    || '/'
    || t53.ano_preaviso_053
    || '/'
    || t53.n_preaviso_053,
    t53.c_territ_053,
    t53.ano_preaviso_053,
    t53.n_preaviso_053,
    t53.f_inicio_053,
    t53.f_elecc_053,
    t53.raz_social_053,
    t53.nif_centro_053,
    t53.num_centro_053,
    t53.s_parcial_053,
    t53.global_053,
    t53.c_conv_053,
    t13.desc_013,
    t13.dese_013,
    t53.admonemp_053,
    NVL (t53.n_cenafec_053, ''),
    t53.observ_053,
    t53.dir_alt_053,
    t53.codpos_alt_053,
    t53.prov_alt_053,
    t53.mun_alt_053;
	
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BAGRUPACIONDESCCOD" ("C_AGRU_014", "F_BAJA_014", "DESC_014", "DESE_014")
AS
  SELECT c_agru_014,
    f_baja_014,
    c_agru_014
    || '-'
    || desc_014 AS desc_014,
    c_agru_014
    || '-'
    || dese_014 AS dese_014
  FROM w83b14s00;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BBUSQBANDEJAENTRADA" ("PREAVISO_008", "F_ENTRADA_007", "F_REGIS_008", "F_INICIO_008", "RAZ_SOCIAL_008", "CIF_008", "PROV_008", "MUNIC_008", "ESTADO_008", "DESCPROVINCIA", "DESCMUNICIPIO", "C_TERRIT_008")
AS
  SELECT preaviso_008,
    f_entrada_007,
    f_regis_008,
    f_inicio_008,
    raz_social_008,
    cif_008,
    prov_008,
    munic_008,
    estado_008,
    provincias.ds_o AS descprovincia,
    municipios.ds_o AS descmunicipio,
    c_territ_008
  FROM w83b08s00 preavisos
  INNER JOIN w83b07s00 lotes
  ON preavisos.lote_008 = lotes.lote_007
  LEFT OUTER JOIN t17i.t17_provincia provincias
  ON preavisos.prov_008 = provincias.ID
  LEFT OUTER JOIN t17i.t17_municipio municipios
  ON municipios.provincia_id = provincias.ID
  AND municipios.ID          = preavisos.munic_008
  WHERE estado_008          <> 1
  AND tipo_008               = 'I';
  
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCENTROSDELEGADOS" ("CODTERRITORIO", "TERRITORIO", "CODMUNICIPIO", "MUNICIPIO", "CODCENTRO", "RAZONSOCIAL", "TELEFONO", "CIFNIF", "DOMICILIO", "FAX")
AS
  SELECT DECODE (LENGTH (TO_CHAR (tcentrocomp.codterritorio)), 1, '0'
    || TO_CHAR (tcentrocomp.codterritorio), TO_CHAR (tcentrocomp.codterritorio) ) AS codterritorio,
    tprovincia.ds_o,
    DECODE (LENGTH (TO_CHAR (tcentrocomp.codmunicipio)), 1, '00'
    || TO_CHAR (tcentrocomp.codmunicipio), 2, '0'
    || TO_CHAR (tcentrocomp.codmunicipio), TO_CHAR (tcentrocomp.codmunicipio) ) AS codmunicipio,
    tmunicipio.ds_o,
    tcentrocomp.codcentro,
    tcentrocomp.razonsocial,
    tcentrocomp.telefono,
    tcentrocomp.cifnif,
    tcentrocomp.domicilio,
    tcentrocomp.fax
  FROM w83bcentrotrabajocompleto tcentrocomp,
    t17i.t17_municipio tmunicipio,
    t17i.t17_provincia tprovincia
  WHERE tmunicipio.provincia_id = tcentrocomp.codterritorio
  AND tmunicipio.ID             = tcentrocomp.codmunicipio
  AND tprovincia.ID             = tcentrocomp.codterritorio
  ORDER BY codterritorio,
    codmunicipio,
    tcentrocomp.codcentro;
	
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW w83b.w83bcentrotrabajo (codcentro,
                                                     cifnif,
                                                     tipcifnif,
                                                     ncentrotrabajo,
                                                     razonsocial,
                                                     razonsocialscaracteres,
                                                     domicilio,
                                                     municipio,
                                                     territorio,
                                                     territorio_eusk,
                                                     localidad,
                                                     codterritorio,
                                                     codmunicipio,
                                                     codpostal,
                                                     cnae,
                                                     num_trabajadores,
                                                     bajacentro,
                                                     telefono,
                                                     fax,
                                                     email
                                                    )
AS
   SELECT t73_01.ccen_001, t73_01.ccif_001, t73_01.tcif_001, t73_01.ncen_001,
          t73_01.rsoc_001, t73_01.rsos_001, t73_01.domic_001, fca02.ds_o,
          fca01.ds_o, fca01.ds_o, t73_01.local_001, t73_01.provc_001,
          t73_01.munic_001, t73_01.cposc_001, t73_01.cnae_001,
          t73_01.ntra_001, t73_01.baja_001, t73_01.tlf_001, t73_01.fax_001,
          t73_01.email_001
     FROM w83b.j7301s01 t73_01,
          t17i.t17_municipio fca02,
          t17i.t17_provincia fca01
    WHERE t73_01.provc_001 = fca02.provincia_id
      AND t73_01.munic_001 = fca02.ID
      AND fca02.provincia_id = fca01.ID
      AND t73_01.provc_001 = fca01.ID;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCENTROTRABAJOCOMPLETO" ("CIFNIF", "TIPOCIF", "NCENTROTRABAJO", "CODCENTRO", "RAZONSOCIAL", "RAZONSOCIALSCARACTERES", "DOMICILIO", "CODPOSTAL", "CODTERRITORIO", "CODMUNICIPIO", "LOCALIDAD", "CODCOMARCA", "COMARCA", "TELEFONO", "FAX", "NOMBRECOMERCIAL", "DOMICILIOFISCAL", "CODTERRITORIOFISCAL", "CODMUNICIPIOFISCAL", "CODIGOPOSTALFISCAL", "CODCNAE", "CNAE", "CODSECTOR", "CODREGJUR", "NUMTRABAJADORES", "CODBAJA", "FECBAJA", "FECULTACTUALIZACION", "OBSERVACIONES")
AS
  SELECT t73_01.ccif_001,
    t73_01.tcif_001,
    t73_01.ncen_001,
    t73_01.ccen_001,
    t73_01.rsoc_001,
    t73_01.rsos_001,
    t73_01.domic_001,
    t73_01.cposc_001,
    t73_01.provc_001,
    t73_01.munic_001,
    t73_01.local_001,
    comarca.ID,
    comarca.ds_o,
    t73_01.tlf_001,
    t73_01.fax_001,
    t73_01.comer_001,
    t73_01.domif_001,
    t73_01.provf_001,
    t73_01.munif_001,
    t73_01.cposf_001,
    t73_01.cnae_001,
    cnae.desc_003,
    t73_01.secc_001,
    t73_01.regi_001,
    t73_01.ntra_001,
    t73_01.baja_001,
    t73_01.fbaja_001,
    t73_01.factu_001,
    t73_01.obser_001
  FROM w83b.j7301s01 t73_01,
    t17i.t17_municipio municipio,
    t17i.t17_comarca comarca,
    j7303s00 cnae
  WHERE municipio.ID         = t73_01.munic_001
  AND municipio.provincia_id = t73_01.provc_001
  AND comarca.ID             = municipio.comarca_id
  AND comarca.provincia_id   = t73_01.provc_001
  AND cnae.secc_003          = t73_01.secc_001
  AND cnae.grup_003          = t73_01.grup_001
  AND cnae.divi_003          = t73_01.divi_001
  AND cnae.clas_003          = t73_01.clas_001;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCENTROTRABAJODOCUMENTACION" ("CIFNIF", "CODCENTRO", "TIPCIFNIF", "NCENTROTRABAJO", "RAZONSOCIAL", "DOMICILIO", "CODTERRITORIO", "CODMUNICIPIO", "MUNICIPIO", "TERRITORIO", "TERRITORIO_EUSK", "CODPOSTAL", "CNAE", "RAZONSOCIALSCARACTERES")
                                   AS
  SELECT DISTINCT (UPPER (cifnif)) AS cifnif,
    codcentro,
    tipcifnif,
    ncentrotrabajo,
    UPPER (razonsocial) AS razonsocial,
    UPPER (domicilio)   AS domicilio,
    codterritorio,
    codmunicipio,
    UPPER (municipio)       AS municipio,
    UPPER (territorio)      AS territorio,
    UPPER (territorio_eusk) AS territorio_eusk,
    codpostal,
    cnae,
    razonsocialscaracteres
  FROM w83b.w83bcentrotrabajo
  WHERE codcentro IN
    (SELECT acta.id_centro_016 FROM w83b16t00 acta
    )
  UNION
  SELECT DISTINCT (UPPER (cifnif)) AS cifnif,
    codcentro,
    tipcifnif,
    ncentrotrabajo,
    UPPER (razonsocial) AS razonsocial,
    UPPER (domicilio)   AS domicilio,
    codterritorio,
    codmunicipio,
    UPPER (municipio)       AS municipio,
    UPPER (territorio)      AS territorio,
    UPPER (territorio_eusk) AS territorio_eusk,
    codpostal,
    cnae,
    razonsocialscaracteres
  FROM w83b.w83bcentrotrabajo
  WHERE codcentro IN
    (SELECT preaviso.id_centro_037 FROM w83b37t00 preaviso
    );
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTCENTRALTERRITORIO" ("NACTA", "ANOACTA", "TERRIT", "VERS", "NUMDELEGADOS", "FECHABAJA", "FELEC", "FACTU", "FREGDEF", "CODSINDI", "CODCONVENIO", "DESCCONVENIO", "DESECONVENIO")
AS
  SELECT numacta,
    ano_acta,
    codterritorioacta,
    versionacta,
    numdelegados,
    fbaja,
    felec,
    factu,
    fregdef,
    codsindicato,
    codconvenio,
    descconvenio,
    deseconvenio
  FROM
    (SELECT acta.n_acta_016                                             AS numacta,
      acta.ano_acta_016                                                 AS ano_acta,
      acta.c_territ_016                                                 AS codterritorioacta,
      acta.version_016                                                  AS versionacta,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024), '0' ) AS numdelegados,
      acta.f_baja_016                                                   AS fbaja,
      acta.f_elecc_016                                                  AS felec,
      acta.factu_016                                                    AS factu,
      acta.fregdef_016                                                  AS fregdef,
      escrutinios.c_sindi_024                                           AS codsindicato,
      conv.c_conv_013                                                   AS codconvenio,
      conv.desc_013                                                     AS descconvenio,
      conv.dese_013                                                     AS deseconvenio
    FROM w83b24s00 escrutinios,
      w83b16s00 acta,
      w83b13s00 conv
    WHERE escrutinios.n_acta_024 = acta.n_acta_016
    AND escrutinios.ano_acta_024 = acta.ano_acta_016
    AND escrutinios.version_024  = acta.version_016
    AND escrutinios.c_territ_024 = acta.c_territ_016
    AND acta.c_conv_016          = conv.c_conv_013
    AND acta.n_acttot_016       IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    GROUP BY acta.n_acta_016,
      acta.ano_acta_016,
      acta.c_territ_016,
      acta.version_016,
      acta.f_baja_016,
      acta.f_elecc_016,
      acta.factu_016,
      acta.fregdef_016,
      escrutinios.c_sindi_024,
      conv.c_conv_013,
      conv.desc_013,
      conv.dese_013
    ) consulta;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTDELEGADOSSECTOR" ("CODSECTOR", "CODSINDI", "DESCSINDCAST", "DESCSINDEUSK", "FELEC", "NACTA", "ANOACTA", "TERRIT", "VERS", "FREGDEF", "FECHABAJA", "NUMDELEGADOS")
AS
  SELECT codsector,
    codsindi,
    descsindcast,
    descsindeusk,
    felec,
    nacta,
    anoacta,
    territ,
    vers,
    fregdef,
    fechabaja,
    numdelegados
  FROM
    (SELECT centro.codsector                                            AS codsector,
      escrutinios.c_sindi_024                                           AS codsindi,
      sindicato.desc_019                                                AS descsindcast,
      sindicato.dese_019                                                AS descsindeusk,
      actas.f_elecc_016                                                 AS felec,
      actas.n_acta_016                                                  AS nacta,
      actas.ano_acta_016                                                AS anoacta,
      actas.c_territ_016                                                AS territ,
      actas.version_016                                                 AS vers,
      actas.fregdef_016                                                 AS fregdef,
      actas.f_baja_016                                                  AS fechabaja,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024), '0' ) AS numdelegados
    FROM w83b16s00 actas,
      w83bcentrotrabajocompleto centro,
      w83b24s00 escrutinios,
      w83b19s00 sindicato
    WHERE actas.id_centro_016   = centro.codcentro
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicato.c_sindi_019(+)
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    AND actas.n_regdef_016     IS NOT NULL
    GROUP BY centro.codsector,
      escrutinios.c_sindi_024,
      sindicato.desc_019,
      sindicato.dese_019,
      actas.f_elecc_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.fregdef_016,
      actas.f_baja_016
    UNION ALL
    SELECT centro.codsector                                             AS codsector,
      diferencias.c_sindi_018                                           AS codsindi,
      sindicato.desc_019                                                AS descsindcast,
      sindicato.dese_019                                                AS descsindeusk,
      actas.f_elecc_016                                                 AS felec,
      actas.n_acta_016                                                  AS nacta,
      actas.ano_acta_016                                                AS anoacta,
      actas.c_territ_016                                                AS territ,
      actas.version_016                                                 AS vers,
      actas.fregdef_016                                                 AS fregdef,
      actas.f_baja_016                                                  AS fechabaja,
      NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018), '0' ) AS numdelegados
    FROM w83b16s00 actas,
      w83bcentrotrabajocompleto centro,
      w83b18s00 diferencias,
      w83b19s00 sindicato
    WHERE actas.id_centro_016   = centro.codcentro
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicato.c_sindi_019(+)
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    AND actas.n_regdef_016     IS NOT NULL
    GROUP BY centro.codsector,
      diferencias.c_sindi_018,
      sindicato.desc_019,
      sindicato.dese_019,
      actas.f_elecc_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.fregdef_016,
      actas.f_baja_016
    ) consulta;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTEMPRESA" ("SIGLAS", "RAZON", "DESCSINDCAST", "DESCSINDEUSK", "CODCENTRO", "FECHA_ELECCION", "CODSINDICATO", "FECHA_ALTA", "NUMEROREGISTRO", "FECHA_REGISTRO", "OBSERVACIONES", "ACTATOTAL", "NUM_ACTA", "ANYO_ACTA", "TERRITORIO_ACTA", "ALAVA", "VIZCAYA", "GUIPUZCOA", "CIF", "NUMERO")
AS
  SELECT siglas,
    razon,
    desc_019 AS desccast,
    dese_019 AS desceusk,
    codigocentro,
    fecha_eleccion,
    c_sindi_019 AS codsind,
    fechaalta,
    numeroregistro,
    fecharegistro,
    observaciones,
    acta,
    num_acta,
    anyo_acta,
    territorio_acta,
    NVL (SUM (
    CASE
      WHEN (territorio_acta = 01)
      THEN numdelegados
      ELSE 0
    END), 0 ) AS alava,
    NVL (SUM (
    CASE
      WHEN (territorio_acta = 48)
      THEN numdelegados
      ELSE 0
    END), 0 ) AS vizcaya,
    NVL (SUM (
    CASE
      WHEN (territorio_acta = 20)
      THEN numdelegados
      ELSE 0
    END), 0 ) AS guipuzcoa,
    ccif_001,
    ncen_001
  FROM
    (SELECT acta.n_acta_016                                              AS num_acta,
      acta.ano_acta_016                                                  AS anyo_acta,
      acta.c_territ_016                                                  AS territorio_acta,
      acta.version_016                                                   AS versionacta,
      escrutinios.c_sindi_024                                            AS sindicato,
      sind.siglas_019                                                    AS siglas,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 ), '0' ) AS numdelegados,
      desc_019                                                           AS desc_019,
      dese_019                                                           AS dese_019,
      c_sindi_019,
      rsoc_001    AS razon,
      f_elecc_016 AS fecha_eleccion,
      f_entra_016 AS fechaalta,
      ( c_territ_016
      || '/'
      || ano_regdef_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (n_regdef_016)), 1, '00000'
      || TO_CHAR (n_regdef_016), 2, '0000'
      || TO_CHAR (n_regdef_016), 3, '000'
      || TO_CHAR (n_regdef_016), 4, '00'
      || TO_CHAR (n_regdef_016), 5, '0'
      || TO_CHAR (n_regdef_016), TO_CHAR (n_regdef_016) ) ) numeroregistro,
      ( acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) ) acta,
      fregdef_016 AS fecharegistro,
      observ_016  AS observaciones,
      ccen_001    AS codigocentro,
      ccif_001,
      ncen_001
    FROM w83b24s00 escrutinios,
      w83b16s00 acta,
      w83b19s00 sind,
      j7301s01
    WHERE escrutinios.n_acta_024 = acta.n_acta_016
    AND escrutinios.ano_acta_024 = acta.ano_acta_016
    AND escrutinios.version_024  = acta.version_016
    AND escrutinios.c_territ_024 = acta.c_territ_016
    AND sind.c_sindi_019         = escrutinios.c_sindi_024
    AND acta.id_centro_016       = ccen_001
    AND acta.f_baja_016         IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    AND acta.n_acttot_016       IS NULL
    GROUP BY acta.n_acta_016,
      acta.ano_acta_016,
      acta.c_territ_016,
      acta.version_016,
      escrutinios.c_sindi_024,
      sind.siglas_019,
      desc_019,
      dese_019,
      c_sindi_019,
      rsoc_001,
      f_elecc_016,
      f_entra_016,
      ( c_territ_016
      || '/'
      || ano_regdef_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (n_regdef_016)), 1, '00000'
      || TO_CHAR (n_regdef_016), 2, '0000'
      || TO_CHAR (n_regdef_016), 3, '000'
      || TO_CHAR (n_regdef_016), 4, '00'
      || TO_CHAR (n_regdef_016), 5, '0'
      || TO_CHAR (n_regdef_016), TO_CHAR (n_regdef_016) ) ),
      ( acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) ),
      fregdef_016,
      observ_016,
      ccen_001,
      ccif_001,
      ncen_001
    UNION ALL
    SELECT acta.n_acta_016                                               AS num_acta,
      acta.ano_acta_016                                                  AS anyo_acta,
      acta.c_territ_016                                                  AS territorio_acta,
      acta.version_016                                                   AS versionacta,
      diferencias.c_sindi_018                                            AS sindicato,
      sind.siglas_019                                                    AS siglas,
      NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018 ), '0' ) AS numdelegados,
      desc_019                                                           AS desc_019,
      dese_019                                                           AS dese_019,
      c_sindi_019,
      rsoc_001    AS razon,
      f_elecc_016 AS fecha_eleccion,
      f_entra_016 AS fechaalta,
      ( c_territ_016
      || '/'
      || ano_regdef_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (n_regdef_016)), 1, '00000'
      || TO_CHAR (n_regdef_016), 2, '0000'
      || TO_CHAR (n_regdef_016), 3, '000'
      || TO_CHAR (n_regdef_016), 4, '00'
      || TO_CHAR (n_regdef_016), 5, '0'
      || TO_CHAR (n_regdef_016), TO_CHAR (n_regdef_016) ) ) numeroregistro,
      ( acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) ) acta,
      fregdef_016 AS fecharegistro,
      observ_016  AS observaciones,
      ccen_001    AS codigocentro,
      ccif_001,
      ncen_001
    FROM w83b18s00 diferencias,
      w83b16s00 acta,
      w83b19s00 sind,
      j7301s01
    WHERE diferencias.n_acta_018 = acta.n_acta_016
    AND diferencias.ano_acta_018 = acta.ano_acta_016
    AND diferencias.version_018  = acta.version_016
    AND diferencias.c_territ_018 = acta.c_territ_016
    AND sind.c_sindi_019         = diferencias.c_sindi_018
    AND acta.id_centro_016       = ccen_001
    AND acta.f_baja_016         IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    AND acta.n_acttot_016       IS NULL
    GROUP BY acta.n_acta_016,
      acta.ano_acta_016,
      acta.c_territ_016,
      acta.version_016,
      diferencias.c_sindi_018,
      sind.siglas_019,
      desc_019,
      dese_019,
      c_sindi_019,
      rsoc_001,
      f_elecc_016,
      f_entra_016,
      ( c_territ_016
      || '/'
      || ano_regdef_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (n_regdef_016)), 1, '00000'
      || TO_CHAR (n_regdef_016), 2, '0000'
      || TO_CHAR (n_regdef_016), 3, '000'
      || TO_CHAR (n_regdef_016), 4, '00'
      || TO_CHAR (n_regdef_016), 5, '0'
      || TO_CHAR (n_regdef_016), TO_CHAR (n_regdef_016) ) ),
      ( acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) ),
      fregdef_016,
      observ_016,
      ccen_001,
      ccif_001,
      ncen_001
    ) consulta
  WHERE consulta.versionacta =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.num_acta      = act.n_acta_016
    AND consulta.anyo_acta       = act.ano_acta_016
    AND consulta.territorio_acta = act.c_territ_016
    AND act.validada_016         = 1
    )
  GROUP BY acta,
    num_acta,
    anyo_acta,
    territorio_acta,
    siglas,
    desc_019,
    dese_019,
    razon,
    codigocentro,
    fecha_eleccion,
    c_sindi_019,
    fechaalta,
    numeroregistro,
    fecharegistro,
    observaciones,
    ccif_001,
    ncen_001;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTLISTADELEGADOS" ("NOMBRE", "APELLIDO1", "APELLIDO2", "DNI", "SIGLAS", "FECHA_ALTA", "TERRITORIO_ACTA", "ANYO_ACTA", "NUM_ACTA")
AS
  SELECT DISTINCT nombre,
    apellido1,
    apellido2,
    dni,
    siglas,
    fechaalta,
    territorio_acta,
    ano_acta,
    num_acta
  FROM
    (SELECT acta.n_acta_016 AS num_acta,
      acta.ano_acta_016     AS ano_acta,
      acta.c_territ_016     AS territorio_acta,
      acta.version_016      AS version_acta,
      acta.validada_016     AS validada,
      centros.ccif_001      AS cif,
      del.nombre_025        AS nombre,
      del.apel1_025         AS apellido1,
      del.apel2_025         AS apellido2,
      del.dni_025           AS dni,
      sind.siglas_019       AS siglas,
      desc_019              AS desccentro,
      del.f_alta_025        AS fechaalta
    FROM w83b25t00 del,
      w83b16s00 acta,
      j7301s01 centros,
      w83b19s00 sind
    WHERE del.n_acta_025   = acta.n_acta_016
    AND del.ano_acta_025   = acta.ano_acta_016
    AND del.version_025    = acta.version_016
    AND del.c_territ_025   = acta.c_territ_016
    AND centros.ccen_001   = acta.id_centro_016
    AND sind.c_sindi_019   = del.c_sindi_025
    AND del.f_baja_025    IS NULL
    AND acta.f_baja_016   IS NULL
    AND acta.fregdef_016  IS NOT NULL
    AND acta.n_regdef_016 IS NOT NULL
    ) consulta
  WHERE consulta.version_acta =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.num_acta      = act.n_acta_016
    AND consulta.ano_acta        = act.ano_acta_016
    AND consulta.territorio_acta = act.c_territ_016
    AND act.validada_016         = 1
    )
  AND consulta.validada = 1;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTMASREPRESENTATIVO" ("NACTA", "ANOACTA", "TERRIT", "VERS", "NUMDELEGADOS", "FECHABAJA", "FELEC", "FACTU", "FREGDEF", "CODSINDICATO", "DESCSINDCAST", "DESCSINDEUSK")
AS
  SELECT numacta,
    ano_acta,
    codterritorioacta,
    versionacta,
    numdelegados,
    fbaja,
    felec,
    factu,
    fregdef,
    codsindicato,
    sinddesc,
    sindeusk
  FROM
    (SELECT acta.n_acta_016                                             AS numacta,
      acta.ano_acta_016                                                 AS ano_acta,
      acta.c_territ_016                                                 AS codterritorioacta,
      acta.version_016                                                  AS versionacta,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024), '0' ) AS numdelegados,
      acta.f_baja_016                                                   AS fbaja,
      acta.f_elecc_016                                                  AS felec,
      acta.factu_016                                                    AS factu,
      acta.fregdef_016                                                  AS fregdef,
      escrutinios.c_sindi_024                                           AS codsindicato,
      NVL (sind.desc_019,'')                                            AS sinddesc,
      NVL (sind.dese_019,'')                                            AS sindeusk
    FROM w83b24s00 escrutinios,
      w83b16s00 acta,
      w83b19s00 sind
    WHERE escrutinios.n_acta_024 = acta.n_acta_016
    AND escrutinios.ano_acta_024 = acta.ano_acta_016
    AND escrutinios.version_024  = acta.version_016
    AND escrutinios.c_territ_024 = acta.c_territ_016
    AND escrutinios.c_sindi_024  = sind.c_sindi_019(+)
    AND acta.n_acttot_016       IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    GROUP BY acta.n_acta_016,
      acta.ano_acta_016,
      acta.c_territ_016,
      acta.version_016,
      acta.f_baja_016,
      acta.f_elecc_016,
      acta.factu_016,
      acta.fregdef_016,
      escrutinios.c_sindi_024,
      sind.desc_019,
      sind.dese_019
    ) consulta;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTNEGREPRES" ("NUM_ACTA", "FECHA_ELECCION", "DESCSINDCAST", "DESCSINDEUSK", "CODCENTRO", "CODSINDICATO", "TERRITORIO_ACTA", "FECHAREGISTRO", "FECHABAJA", "FECHAACTU", "ANO_ACTA", "VER", "NACTA", "NUMDELEGADOS")
AS
  SELECT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) num_acta,
    actas.f_elecc_016  AS fecha_eleccion,
    sindicato.desc_019 AS descsindcast,
    sindicato.dese_019 AS descsindeusk,
    actas.id_centro_016 centro,
    sindicato.c_sindi_019                                             AS codsind,
    actas.c_territ_016                                                AS territ,
    actas.fregdef_016                                                 AS fecharegistro,
    actas.f_baja_016                                                  AS fechabaja,
    actas.factu_016                                                   AS factu,
    actas.ano_acta_016                                                AS ano_acta,
    actas.version_016                                                 AS ver,
    actas.n_acta_016                                                  AS nacta,
    NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024), '0' ) AS numdelegados
  FROM w83b16s00 actas,
    w83b24s00 escrutinios,
    w83b19s00 sindicato
  WHERE actas.n_acta_016      = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016      = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016      = escrutinios.c_territ_024(+)
  AND actas.version_016       = escrutinios.version_024(+)
  AND escrutinios.c_sindi_024 = sindicato.c_sindi_019(+)
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.n_regdef_016     IS NOT NULL
  GROUP BY ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    actas.f_elecc_016,
    sindicato.desc_019,
    sindicato.dese_019,
    actas.id_centro_016,
    sindicato.c_sindi_019,
    actas.c_territ_016,
    actas.fregdef_016,
    actas.f_baja_016,
    actas.factu_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.n_acta_016
  UNION ALL
  SELECT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) num_acta,
    actas.f_elecc_016  AS fecha_eleccion,
    sindicato.desc_019 AS descsindcast,
    sindicato.dese_019 AS descsindeusk,
    actas.id_centro_016 centro,
    sindicato.c_sindi_019                                             AS codsind,
    actas.c_territ_016                                                AS territ,
    actas.fregdef_016                                                 AS fecharegistro,
    actas.f_baja_016                                                  AS fechabaja,
    actas.factu_016                                                   AS factu,
    actas.ano_acta_016                                                AS ano_acta,
    actas.version_016                                                 AS ver,
    actas.n_acta_016                                                  AS nacta,
    NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018), '0' ) AS numdelegados
  FROM w83b16s00 actas,
    w83b18s00 diferencias,
    w83b19s00 sindicato
  WHERE actas.n_acta_016      = diferencias.n_acta_018(+)
  AND actas.ano_acta_016      = diferencias.ano_acta_018(+)
  AND actas.c_territ_016      = diferencias.c_territ_018(+)
  AND actas.version_016       = diferencias.version_018(+)
  AND diferencias.c_sindi_018 = sindicato.c_sindi_019(+)
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.n_regdef_016     IS NOT NULL
  GROUP BY ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    actas.f_elecc_016,
    sindicato.desc_019,
    sindicato.dese_019,
    actas.id_centro_016,
    sindicato.c_sindi_019,
    actas.c_territ_016,
    actas.fregdef_016,
    actas.f_baja_016,
    actas.factu_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.n_acta_016;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCERTORGANOREPR" ("ACTATOTAL", "NUM_ACTA", "ANYO_ACTA", "TERRITORIO_ACTA", "FECHA_ELECCION", "RAZON", "CODPROVINCIA", "CODMUNICIPIO", "CIF", "NUMERO")
AS
  SELECT DISTINCT (acta),
    num_acta,
    anyo_acta,
    territorio_acta,
    fecha_eleccion,
    empresa,
    codprovincia,
    codmunicipio,
    cif,
    numero
  FROM
    (SELECT acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) acta,
      acta.n_acta_016   AS num_acta,
      acta.ano_acta_016 AS anyo_acta,
      acta.c_territ_016 AS territorio_acta,
      acta.version_016  AS version_acta,
      acta.f_elecc_016  AS fecha_eleccion,
      centros.rsoc_001  AS empresa,
      centros.provc_001 AS codprovincia,
      centros.munic_001 AS codmunicipio,
      centros.ccif_001  AS cif,
      centros.ncen_001  AS numero
    FROM w83b24s00 escrutinios,
      w83b16s00 acta,
      j7301s01 centros,
      w83b19s00 sind
    WHERE escrutinios.n_acta_024 = acta.n_acta_016
    AND escrutinios.ano_acta_024 = acta.ano_acta_016
    AND escrutinios.version_024  = acta.version_016
    AND escrutinios.c_territ_024 = acta.c_territ_016
    AND centros.ccen_001         = acta.id_centro_016
    AND sind.c_sindi_019         = escrutinios.c_sindi_024
    AND acta.f_baja_016         IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    AND acta.n_acttot_016       IS NULL
    UNION ALL
    SELECT acta.c_territ_016
      || '/'
      || acta.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)), 1, '00000'
      || TO_CHAR (acta.n_acta_016), 2, '0000'
      || TO_CHAR (acta.n_acta_016), 3, '000'
      || TO_CHAR (acta.n_acta_016), 4, '00'
      || TO_CHAR (acta.n_acta_016), 5, '0'
      || TO_CHAR (acta.n_acta_016), TO_CHAR (acta.n_acta_016) ) acta,
      acta.n_acta_016   AS num_acta,
      acta.ano_acta_016 AS anyo_acta,
      acta.c_territ_016 AS territorio_acta,
      acta.version_016  AS version_acta,
      acta.f_elecc_016  AS fecha_eleccion,
      centros.rsoc_001  AS empresa,
      centros.provc_001 AS codprovincia,
      centros.munic_001 AS codmunicipio,
      centros.ccif_001  AS cif,
      centros.ncen_001  AS numero
    FROM w83b18s00 diferencias,
      w83b16s00 acta,
      j7301s01 centros,
      w83b19s00 sind
    WHERE diferencias.n_acta_018 = acta.n_acta_016
    AND diferencias.ano_acta_018 = acta.ano_acta_016
    AND diferencias.version_018  = acta.version_016
    AND diferencias.c_territ_018 = acta.c_territ_016
    AND centros.ccen_001         = acta.id_centro_016
    AND sind.c_sindi_019         = diferencias.c_sindi_018
    AND acta.f_baja_016         IS NULL
    AND acta.n_regdef_016       IS NOT NULL
    AND acta.validada_016        = 1
    AND acta.n_acttot_016       IS NULL
    ) consulta
  WHERE consulta.version_acta =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.num_acta      = act.n_acta_016
    AND consulta.anyo_acta       = act.ano_acta_016
    AND consulta.territorio_acta = act.c_territ_016
    AND act.validada_016         = 1
    );
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCNAE" ("IDCNAE", "IDSECTOR", "DESCCNAE")
AS
  SELECT cnae.divi_003
    || DECODE (cnae.grup_003, ' ', '0', cnae.grup_003)
    || DECODE (cnae.clas_003, ' ', '0', cnae.clas_003),
    cnae.secc_003,
    cnae.desc_003
  FROM j7303s00 cnae
  WHERE cnae.divi_003 <> ' '
  AND cnae.grup_003   <> ' '
  AND cnae.clas_003   <> ' ';
  
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BCOMFALTAPREAVISO" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NPRE", "ANOPREAVISO", "RAZON", "DOMICILIO", "CODIGOPOSTAL", "MUNICIPIO", "PROVINCIA", "FREGDEF", "NUMAACTAINT", "DIRORIG", "CPORIG", "MUNORIG", "PROVORIG")
                           AS
  SELECT actas.version_016 AS ver,
    actas.f_entra_016      AS fechaentrada,
    actas.n_acta_016       AS nacta,
    actas.ano_acta_016     AS anoacta,
    actas.c_territ_016     AS territ,
    actas.n_preaviso_016   AS npre,
    actas.ano_preaviso_016 AS anopreaviso,
    centros.rsoc_001       AS razon,
    centros.domic_001      AS domicilio,
    centros.cposc_001      AS codigopostal,
    centros.munic_001      AS municipio,
    centros.provc_001      AS provincia,
    actas.fregdef_016      AS fregdef,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint,
    preavisos.dir_alt_037                                         AS dirorig,
    preavisos.codpos_alt_037                                      AS cporig,
    preavisos.mun_alt_037                                         AS munorig,
    preavisos.prov_alt_037                                        AS provorig
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b37s00 preavisos
  WHERE centros.ccen_001     = actas.id_centro_016
  AND actas.n_preaviso_016   = preavisos.n_preaviso_037(+)
  AND actas.ano_preaviso_016 = preavisos.ano_preaviso_037(+)
  AND actas.c_territ_016     = preavisos.c_territ_037(+)
  AND actas.n_preaviso_016  IS NULL
  AND actas.fregdef_016     IS NULL
  AND actas.version_016      = 0
  AND actas.validada_016     = 1
  AND actas.f_baja_016      IS NULL
  ORDER BY numaactaint ASC;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCOMINCIDENCIAS" ("NACTA", "ANOACTA", "TERRIT", "VER", "RAZON", "NUMCENTRO", "DOMICILIO", "MUNICIPIO", "PROVINCIA", "NUMAACTAINT", "NUMINCIDENCIAINT", "CODIGOPOSTAL", "DIRORIG", "CPORIG", "MUNORIG", "PROVORIG", "FECHAVALIDACION", "NUMINCIDENCIA", "ANOINCIDENCIA")
                          AS
  SELECT actas.n_acta_016 AS nacta,
    actas.ano_acta_016    AS anoacta,
    actas.c_territ_016    AS territ,
    actas.version_016     AS ver,
    centros.rsoc_001      AS razon,
    centros.ccen_001      AS numcentro,
    centros.domic_001     AS domicilio,
    centros.munic_001     AS municipio,
    centros.provc_001     AS provincia,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint,
    TO_NUMBER ( incidencias.c_territ_061
    || incidencias.ano_incid_061
    || DECODE (LENGTH (TO_CHAR (incidencias.n_incid_061)), 1, '00000'
    || TO_CHAR (incidencias.n_incid_061), 2, '0000'
    || TO_CHAR (incidencias.n_incid_061), 3, '000'
    || TO_CHAR (incidencias.n_incid_061), 4, '00'
    || TO_CHAR (incidencias.n_incid_061), 5, '0'
    || TO_CHAR (incidencias.n_incid_061), TO_CHAR (incidencias.n_incid_061) ) ) AS numincidenciaint,
    centros.cposc_001                                                           AS codigopostal,
    preavisos.dir_alt_037                                                       AS dirorig,
    preavisos.codpos_alt_037                                                    AS cporig,
    preavisos.mun_alt_037                                                       AS munorig,
    preavisos.prov_alt_037                                                      AS provorig,
    incidencias.f_validac_061                                                   AS fechavalidacion,
    incidencias.n_incid_061                                                     AS numincidencia,
    incidencias.ano_incid_061                                                   AS anoincidencia
  FROM w83b16s00 actas,
    w83b61s00 incidencias,
    j7301s01 centros,
    w83b37s00 preavisos
  WHERE actas.n_acta_016             = incidencias.n_acta_061
  AND actas.ano_acta_016             = incidencias.ano_acta_061
  AND actas.c_territ_016             = incidencias.c_territ_061
  AND actas.version_016              = incidencias.version_acta_061
  AND centros.ccen_001               = actas.id_centro_016
  AND actas.n_preaviso_016           = preavisos.n_preaviso_037(+)
  AND actas.ano_preaviso_016         = preavisos.ano_preaviso_037(+)
  AND actas.c_territ_016             = preavisos.c_territ_037(+)
  AND actas.validada_016             = 1
  AND actas.f_baja_016              IS NULL
  AND incidencias.validada_061       = 1
  AND incidencias.tp_incidencia_061 IN (1, 2, 3, 4, 5)
    --AND actas.version_016 = (SELECT MAX(act.VERSION_016) FROM w83b16s00 act WHERE actas.n_acta_016=act.N_ACTA_016 AND actas.ano_acta_016=act.ANO_ACTA_016 AND actas.c_territ_016=act.C_TERRIT_016)
  ORDER BY numaactaint,
    numincidenciaint;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCOMPROBARCENTROPREAVISO" ("ANOPREAVISO", "TERRITORIOPREAVISO", "NPREAVISO", "IDCENTROTRABAJO")
AS
  SELECT t37.ano_preaviso_037,
    t37.c_territ_037,
    t37.n_preaviso_037,
    t37.id_centro_037
  FROM w83b37t00 t37,
    w83b16t00 t16
  WHERE t37.ano_acta_037      = t16.ano_acta_016
  AND t37.c_territ_037        = t16.c_territ_016
  AND t37.n_acta_037          = t16.n_acta_016
  AND ( ( t16.ano_regdef_016 IS NOT NULL
  AND t16.fregdef_016        IS NOT NULL
  AND t16.ano_acttot_016     IS NULL
  AND t16.n_acttot_016       IS NULL )
  AND t16.f_baja_016         IS NULL );
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCOMREQUEMESA" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NUMPREAVISO", "ANOPREAVISO", "CIF", "CODIGOCENTRO", "NUMCENTRO", "RAZON", "DOMICILIO", "MUNICIPIO", "PROVINCIA", "CODIGOPOSTAL", "NUMACTAINT", "DIRORIG", "CPORIG", "MUNORIG", "PROVORIG")
                           AS
  SELECT actas.version_016 AS ver,
    actas.f_entra_016      AS fechaentrada,
    actas.n_acta_016       AS nacta,
    actas.ano_acta_016     AS anoacta,
    actas.c_territ_016     AS territ,
    actas.n_preaviso_016   AS numpreaviso,
    actas.ano_preaviso_016 AS anopreaviso,
    centros.ccif_001       AS cif,
    centros.ccen_001       AS codcentro,
    centros.ncen_001       AS numerocentro,
    centros.rsoc_001       AS razon,
    centros.domic_001      AS domicilio,
    centros.munic_001      AS municipio,
    centros.provc_001      AS provincia,
    centros.cposc_001      AS codigopostal,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint,
    preavisos.dir_alt_037                                         AS dirorig,
    preavisos.codpos_alt_037                                      AS cporig,
    preavisos.mun_alt_037                                         AS munorig,
    preavisos.prov_alt_037                                        AS provorig
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b37s00 preavisos
  WHERE centros.ccen_001     = actas.id_centro_016
  AND actas.n_preaviso_016   = preavisos.n_preaviso_037(+)
  AND actas.ano_preaviso_016 = preavisos.ano_preaviso_037(+)
  AND actas.c_territ_016     = preavisos.c_territ_037(+)
  AND actas.version_016      = 0
  AND actas.validada_016     = 1
  AND actas.f_baja_016      IS NULL
  AND actas.f_reque_016     IS NULL
  ORDER BY numaactaint;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCOMUNICACIONPREAVISOS" ("FECHAENTRADA", "NUMPREAVISO", "NUMPREAVISOINT", "RAZON", "DOMICILIO", "CODIGOPOSTAL", "MUNICIPIO", "PROVINCIA", "ANOPREAVISO", "NPRE", "TERRIT", "DIRORIG", "CPORIG", "MUNORIG", "PROVORIG")
AS
  SELECT preavisos.f_entra_037,
    preavisos.c_territ_037
    || '/'
    || preavisos.ano_preaviso_037
    || '/'
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) AS numpreaviso,
    TO_NUMBER ( preavisos.c_territ_037
    || preavisos.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) ) AS numpreavisoint,
    centros.rsoc_001,
    centros.domic_001,
    centros.cposc_001,
    centros.munic_001,
    centros.provc_001,
    preavisos.ano_preaviso_037,
    preavisos.n_preaviso_037,
    preavisos.c_territ_037,
    preavisos.dir_alt_037,
    preavisos.codpos_alt_037,
    preavisos.mun_alt_037,
    preavisos.prov_alt_037
  FROM j7301s01 centros,
    w83b37s00 preavisos
  WHERE centros.ccen_001 = preavisos.id_centro_037
    --AND preavisos.f_entra_037 <= TO_DATE ('01/01/2008', 'dd/MM/yyyy')
  ORDER BY numpreavisoint;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCONVENIODESCCOD" ("C_CONV_013", "CEMPR_013", "S_DIFE_013", "S_ESP01_013", "S_ESP20_013", "S_ESP48_013", "CMADRID_013", "DESC_013", "DESE_013", "F_BAJA_013")
AS
  SELECT c_conv_013,
    cempr_013,
    s_dife_013,
    s_esp01_013,
    s_esp20_013,
    s_esp48_013,
    cmadrid_013,
    c_conv_013
    || '-'
    || desc_013 AS desc_013,
    c_conv_013
    || '-'
    || dese_013 AS dese_013,
    f_baja_013
  FROM w83b13s00;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCUADRORESUMENHISTORICO" ("SIGLAS", "TERRIT", "MES", "ANYO", "HASTA49", "MAS49", "TOTDEL")
AS
  SELECT siglas_019,
    c_territ_077,
    mes_res_077,
    ano_res_077,
    SUM (n_demh49_077)                AS hasta49,
    SUM (n_demm49_077)                AS mas49,
    SUM (n_demh49_077 + n_demm49_077) AS total
  FROM w83b77s00,
    w83b19s00
  WHERE c_sindi_077 = c_sindi_019
  GROUP BY siglas_019,
    c_territ_077,
    mes_res_077,
    ano_res_077;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BCUADRORESUMENHISTORICOCAV" ("SIGLAS", "MES", "ANYO", "HASTA49", "MAS49", "TOTDEL")
AS
  SELECT SIGLAS_019,
    MES_RES_077,
    ANO_RES_077,
    SUM (N_DEMH49_077)                AS HASTA49,
    SUM (N_DEMM49_077)                AS MAS49,
    SUM (N_DEMH49_077 + N_DEMM49_077) AS TOTAL
  FROM W83B77S00,
    W83B19S00
  WHERE C_SINDI_077 = C_SINDI_019
  GROUP BY SIGLAS_019,
    MES_RES_077,
    ANO_RES_077;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSINCIDENCIAS" ("NACTA", "TERRIT", "ANOACTA", "VER", "NREGDEF", "ANOREGDEF", "FECHABAJA", "FECHAREGISTRO", "FELEC", "FECHAINCIDENCIA", "FECHAVALIDACION")
                              AS
  SELECT actas.n_acta_016     AS nacta,
    actas.c_territ_016        AS territ,
    actas.ano_acta_016        AS anoacta,
    actas.version_016         AS ver,
    actas.n_regdef_016        AS nregdef,
    ano_regdef_016            AS anoregdef,
    actas.f_baja_016          AS fechabaja,
    actas.fregdef_016         AS fecharegistro,
    actas.f_elecc_016         AS felec,
    incidencias.f_entrada_061 AS fechaincidencia,
    incidencias.f_validac_061 AS fechavalidacion
  FROM w83b16s00 actas,
    w83b61s00 incidencias
  WHERE actas.n_acta_016  = incidencias.n_acta_061
  AND actas.ano_acta_016  = incidencias.ano_acta_061
  AND actas.c_territ_016  = incidencias.c_territ_061
  AND actas.version_016   = incidencias.version_acta_061
  AND actas.validada_016  = 1
  AND actas.n_regdef_016 IS NOT NULL
  AND actas.n_acttot_016 IS NULL
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.n_acttot_016,
    actas.f_baja_016,
    actas.fregdef_016,
    actas.f_elecc_016,
    incidencias.f_entrada_061,
    incidencias.f_validac_061,
    actas.n_regdef_016,
    ano_regdef_016
  ORDER BY nacta,
    territ,
    anoacta,
    ver DESC;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOACTAS" ("N_ACTA_016", "CCIF_001", "RSOC_001", "CNAE_001", "MUNIC_001", "C_CONV_016", "CMADRID_013", "TOTELEC_016", "C_TERRIT_016", "N_REGDEF_016", "F_ELECC_016", "CEMPR_013", "ANO_ACTA_016", "FREGDEF_016", "F_BAJA_016", "VERSION_016", "DOMIC_001", "C_SINDI_024")
AS
  SELECT consulta.nacta,
    consulta.ccif,
    consulta.rsoc,
    consulta.cnae,
    consulta.munic,
    consulta.c_conv,
    consulta.cmadrid,
    consulta.totelec,
    consulta.c_territ,
    consulta.n_regdef,
    consulta.f_elecc,
    consulta.cempr,
    consulta.ano_acta,
    consulta.fregdef,
    consulta.f_baja,
    consulta.ver,
    consulta.domic,
    consulta.sindi
  FROM
    (SELECT n_acta_016     AS nacta,
      ccif_001             AS ccif,
      rsoc_001             AS rsoc,
      cnae_001             AS cnae,
      munic_001            AS munic,
      c_conv_016           AS c_conv,
      cmadrid_013          AS cmadrid,
      totelec_016          AS totelec,
      c_territ_016         AS c_territ,
      n_regdef_016         AS n_regdef,
      f_elecc_016          AS f_elecc,
      cempr_013            AS cempr,
      ano_acta_016         AS ano_acta,
      fregdef_016          AS fregdef,
      f_baja_016           AS f_baja,
      version_016          AS ver,
      domic_001            AS domic,
      stragg (c_sindi_024) AS sindi
    FROM w83b16s00,
      j7301s01,
      w83b13s00,
      w83b24s00
    WHERE n_regdef_016 IS NOT NULL
    AND n_acttot_016   IS NULL
    AND id_centro_016   = ccen_001
    AND c_conv_013      = c_conv_016
    AND version_016     = version_024
    AND n_acta_016      = n_acta_024
    AND c_territ_016    = c_territ_024
    AND ano_acta_016    = ano_acta_024
    AND validada_016    = 1
    GROUP BY n_acta_016,
      ccif_001,
      rsoc_001,
      cnae_001,
      munic_001,
      c_conv_016,
      cmadrid_013,
      totelec_016,
      c_territ_016,
      n_regdef_016,
      f_elecc_016,
      cempr_013,
      ano_acta_016,
      fregdef_016,
      f_baja_016,
      version_016,
      domic_001
    ) consulta;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOANUAL" ("N_ACTA_016", "ANO_ACTA_016", "VERSION_016", "C_SINDI_024", "DESC_019", "SIGLAS_019", "C_TERRIT_016", "N_DEL", "N_DELM_024", "C_CONV_016", "CMADRID_019", "FREGDEF_016", "F_ELECC_016", "F_BAJA_016")
AS
  SELECT consulta.n_acta_016,
    consulta.ano_acta_016,
    consulta.version_016,
    consulta.c_sindi_024,
    consulta.desc_019,
    consulta.siglas_019,
    consulta.c_territ_016,
    consulta.n_del,
    consulta.n_delm_024,
    consulta.c_conv_016,
    consulta.cmadrid_019,
    consulta.fregdef_016,
    consulta.f_elecc_016,
    consulta.f_baja_016
  FROM
    (SELECT n_acta_016,
      ano_acta_016,
      version_016,
      c_sindi_024,
      desc_019,
      siglas_019,
      c_territ_016,
      SUM (n_delh_024 + n_delm_024) AS n_del,
      SUM (n_delm_024)              AS n_delm_024,
      (
      CASE
        WHEN ( SUBSTR (c_conv_016, 1, 1) = 9
        AND LENGTH (c_conv_016)          = 3 )
        THEN '1'
        ELSE '0'
      END ) AS c_conv_016,
      cmadrid_019,
      fregdef_016,
      f_elecc_016,
      f_baja_016
    FROM w83b16s00,
      w83b24s00,
      w83b19s00
    WHERE n_acta_016  = n_acta_024
    AND ano_acta_016  = ano_acta_024
    AND c_territ_016  = c_territ_024
    AND version_016   = version_024
    AND c_sindi_024   = c_sindi_019(+)
    AND n_regdef_016 IS NOT NULL
    AND n_acttot_016 IS NULL
    AND validada_016  = 1
    GROUP BY c_sindi_024,
      desc_019,
      siglas_019,
      c_territ_016,
      n_acta_016,
      ano_acta_016,
      version_016,
      (
      CASE
        WHEN ( SUBSTR (c_conv_016, 1, 1) = 9
        AND LENGTH (c_conv_016)          = 3 )
        THEN '1'
        ELSE '0'
      END ),
      cmadrid_019,
      fregdef_016,
      f_elecc_016,
      f_baja_016
    ) consulta;
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOCOLEGIOS" ("VERSION_016", "N_ACTA_016", "C_TERRIT_016", "ANO_ACTA_016", "C_COLEG_044", "ELEC_044", "VOTA_044", "PAP_VAL_044", "PAP_NUL_044", "PAP_BLA_044", "N_DELH_024", "N_DELM_024", "N_VOTOS_024", "FREGDEF_016", "F_ELECC_016", "F_BAJA_016")
AS
  SELECT consulta.version_016,
    consulta.n_acta_016,
    consulta.c_territ_016,
    consulta.ano_acta_016,
    consulta.c_coleg_044,
    consulta.elec_044,
    consulta.vota_044,
    consulta.pap_val_044,
    consulta.pap_nul_044,
    consulta.pap_bla_044,
    consulta.n_delh_024,
    consulta.n_delm_024,
    consulta.n_votos_024,
    consulta.fregdef_016,
    consulta.f_elecc_016,
    consulta.f_baja_016
  FROM
    (SELECT version_016,
      n_acta_016,
      c_territ_016,
      ano_acta_016,
      c_coleg_044,
      elec_044,
      vota_044,
      pap_val_044,
      pap_nul_044,
      pap_bla_044,
      NVL (n_delh_024, 0)  AS n_delh_024,
      NVL (n_delm_024, 0)  AS n_delm_024,
      NVL (n_votos_024, 0) AS n_votos_024,
      fregdef_016,
      f_elecc_016,
      f_baja_016
    FROM w83b16s00 w83b_16s00
    LEFT OUTER JOIN w83b44s00 w83b_44s00
    ON ( n_acta_016  = n_acta_044
    AND ano_acta_016 = ano_acta_044
    AND c_territ_016 = c_territ_044
    AND version_016  = version_044 )
    LEFT OUTER JOIN w83b24s00 w83b_24s00
    ON ( n_acta_016    = n_acta_024
    AND ano_acta_016   = ano_acta_024
    AND c_territ_016   = c_territ_024
    AND version_016    = version_024
    AND c_coleg_024    = c_coleg_044 )
    WHERE validada_016 = 1
    AND n_regdef_016  IS NOT NULL
    AND n_acttot_016  IS NULL
    ) consulta
  ORDER BY ano_acta_016,
    n_acta_016,
    c_territ_016,
    c_coleg_044;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOCOLEGPAP" ("N_ACTA_016", "C_TERRIT_016", "ANO_ACTA_016", "VERSION_016", "C_COLEG_044", "ELEC_044", "VOTA_044", "PAP_VAL_044", "PAP_NUL_044", "PAP_BLA_044", "FREGDEF_016", "F_ELECC_016", "F_BAJA_016")
AS
  SELECT n_acta_016,
    c_territ_016,
    ano_acta_016,
    version_016,
    c_coleg_044,
    elec_044,
    vota_044,
    pap_val_044,
    pap_nul_044,
    pap_bla_044,
    fregdef_016,
    f_elecc_016,
    f_baja_016
  FROM
    (SELECT version_016,
      n_acta_016,
      c_territ_016,
      ano_acta_016,
      c_coleg_044,
      elec_044,
      vota_044,
      pap_val_044,
      pap_nul_044,
      pap_bla_044,
      fregdef_016,
      f_elecc_016,
      f_baja_016
    FROM w83b16s00,
      w83b44s00
    WHERE n_acta_016  = n_acta_044
    AND ano_acta_016  = ano_acta_044
    AND c_territ_016  = c_territ_044
    AND version_016   = version_044
    AND validada_016  = 1
    AND n_regdef_016 IS NOT NULL
    AND n_acttot_016 IS NULL
    ) consulta
  ORDER BY ano_acta_016,
    n_acta_016,
    c_territ_016,
    c_coleg_044;
	

/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOCOLESCR" ("N_ACTA_016", "C_TERRIT_016", "ANO_ACTA_016", "VERSION_016", "C_COLEG_024", "N_DELH_024", "N_DELM_024", "N_VOTOS_024", "FREGDEF_016", "F_ELECC_016", "F_BAJA_016")
AS
  SELECT n_acta_016,
    c_territ_016,
    ano_acta_016,
    version_016,
    c_coleg_024,
    NVL (n_delh_024, 0)  AS n_delh_024,
    NVL (n_delm_024, 0)  AS n_delm_024,
    NVL (n_votos_024, 0) AS n_votos_024,
    fregdef_016,
    f_elecc_016,
    f_baja_016
  FROM
    (SELECT version_016,
      n_acta_016,
      c_territ_016,
      ano_acta_016,
      c_coleg_024,
      NVL (n_delh_024, 0)  AS n_delh_024,
      NVL (n_delm_024, 0)  AS n_delm_024,
      NVL (n_votos_024, 0) AS n_votos_024,
      fregdef_016,
      f_elecc_016,
      f_baja_016
    FROM w83b16s00,
      w83b24s00
    WHERE n_acta_016  = n_acta_024
    AND ano_acta_016  = ano_acta_024
    AND c_territ_016  = c_territ_024
    AND version_016   = version_024
    AND validada_016  = 1
    AND n_regdef_016 IS NOT NULL
    AND n_acttot_016 IS NULL
    ) consulta
  ORDER BY ano_acta_016,
    n_acta_016,
    c_territ_016,
    c_coleg_024;
	
/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDATOSMINISTERIOSIND" ("VERSION_016", "N_ACTA_016", "C_TERRIT_016", "ANO_ACTA_016", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "C_SINDI_024", "FREGDEF_016", "F_ELECC_016", "F_BAJA_016", "CMADRID_019")
AS
  SELECT consulta.version_016,
    consulta.n_acta_016   AS n_acta_016,
    consulta.c_territ_016 AS c_territ_016,
    consulta.ano_acta_016 AS ano_acta_016,
    consulta.c_coleg_024  AS c_coleg_024,
    consulta.n_votos_024  AS n_votos_024,
    consulta.n_delh_024   AS n_delh_024,
    consulta.n_delm_024   AS n_delm_024,
    consulta.c_sindi_024  AS c_sindi_024,
    consulta.fregdef_016  AS fregdef_016,
    consulta.f_elecc_016  AS f_elecc_016,
    consulta.f_baja_016   AS f_baja_016,
    consulta.cmadrid_019  AS cmadrid_019
  FROM
    (SELECT version_016,
      n_acta_016,
      c_territ_016,
      ano_acta_016,
      c_coleg_024,
      NVL (n_votos_024, 0)    AS n_votos_024,
      NVL ((n_delh_024), '0') AS n_delh_024,
      NVL ((n_delm_024), '0') AS n_delm_024,
      c_sindi_024,
      fregdef_016,
      f_elecc_016,
      f_baja_016,
      cmadrid_019
    FROM w83b16s00,
      w83b24s00,
      w83b19s00
    WHERE n_acta_016  = n_acta_024
    AND ano_acta_016  = ano_acta_024
    AND c_territ_016  = c_territ_024
    AND version_016   = version_024
    AND c_sindi_024   = c_sindi_019(+)
    AND validada_016  = 1
    AND n_regdef_016 IS NOT NULL
    AND n_acttot_016 IS NULL
    ) consulta
  ORDER BY ano_acta_016,
    n_acta_016,
    c_territ_016,
    c_coleg_024;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSCNAE" ("NACTA", "ANOACTA", "TERRIT", "VER", "NCENTRO", "TOTALELECTORES", "FELEC", "FECHAREGISTRO", "IDCNAE", "SECTOR", "DESCSECTOR", "DESCCNAE", "C_SINDI_024", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "SIGLAS_019", "FECHABAJA")
AS
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    SUM (papeletas.vota_044),
    NVL (tesc.n_delh_024, 0),
    NVL (tesc.n_delm_024, 0),
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83bcnae tcnae,
    w83b24s00 tesc,
    w83b.j7304s00 tsec,
    w83b19s00 tsind,
    w83b44s00 papeletas
  WHERE tact.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE tact.n_acta_016 = act.n_acta_016
    AND tact.ano_acta_016 = act.ano_acta_016
    AND tact.c_territ_016 = act.c_territ_016
    AND act.validada_016  = 1
    )
    --AND tact.f_baja_016 IS NULL
  AND tact.n_acttot_016 IS NULL
  AND tact.n_regdef_016 IS NOT NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND tcent.cnae_001     = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tesc.n_acta_024(+)
  AND tact.ano_acta_016  = tesc.ano_acta_024(+)
  AND tact.c_territ_016  = tesc.c_territ_024(+)
  AND tact.version_016   = tesc.version_024(+)
  AND tesc.n_acta_024    = papeletas.n_acta_044(+)
  AND tesc.ano_acta_024  = papeletas.ano_acta_044(+)
  AND tesc.c_territ_024  = papeletas.c_territ_044(+)
  AND tesc.version_024   = papeletas.version_044(+)
  AND tesc.c_sindi_024   = tsind.c_sindi_019
  GROUP BY tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    tesc.n_delh_024,
    tesc.n_delm_024,
    tsind.siglas_019,
    tact.f_baja_016
  )
UNION ALL
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tsind.c_sindi_019,
    tdif.c_coleg_018,
    0 AS vota_044,
    NVL (tdif.n_delh_018, 0),
    NVL (tdif.n_delm_018, 0),
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83bcnae tcnae,
    w83b.j7304s00 tsec,
    w83b19s00 tsind,
    w83b18s00 tdif
  WHERE tact.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE tact.n_acta_016 = act.n_acta_016
    AND tact.ano_acta_016 = act.ano_acta_016
    AND tact.c_territ_016 = act.c_territ_016
    AND act.validada_016  = 1
    )
    --AND tact.f_baja_016 IS NULL
  AND tact.n_acttot_016 IS NULL
  AND tact.n_regdef_016 IS NOT NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND tcent.cnae_001     = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tdif.n_acta_018(+)
  AND tact.ano_acta_016  = tdif.ano_acta_018(+)
  AND tact.c_territ_016  = tdif.c_territ_018(+)
  AND tact.version_016   = tdif.version_018(+)
  AND tdif.c_sindi_018   = tsind.c_sindi_019
  )
ORDER BY idsector,
  cnae_001,
  c_territ_016,
  ano_acta_016,
  n_acta_016,
  version_016;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSCNAEHIST" ("NACTA", "ANOACTA", "TERRIT", "VER", "NCENTRO", "TOTALELECTORES", "FELEC", "FECHAREGISTRO", "IDCNAE", "SECTOR", "DESCSECTOR", "DESCCNAE", "FECHAACTU", "C_SINDI_024", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "SIGLAS_019", "FECHABAJA")
AS
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    SUM (papeletas.vota_044),
    tesc.n_delh_024,
    tesc.n_delm_024,
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83b24s00 tesc,
    w83bcnae tcnae,
    w83b.j7304s00 tsec,
    w83b19s00 tsind,
    w83b44s00 papeletas
  WHERE --tact.f_baja_016 IS NULL
    --AND
    tact.n_acttot_016   IS NULL
  AND tact.n_regdef_016 IS NOT NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND tcent.cnae_001     = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tesc.n_acta_024(+)
  AND tact.ano_acta_016  = tesc.ano_acta_024(+)
  AND tact.c_territ_016  = tesc.c_territ_024(+)
  AND tact.version_016   = tesc.version_024(+)
  AND tesc.n_acta_024    = papeletas.n_acta_044(+)
  AND tesc.ano_acta_024  = papeletas.ano_acta_044(+)
  AND tesc.c_territ_024  = papeletas.c_territ_044(+)
  AND tesc.version_024   = papeletas.version_044(+)
  AND tesc.c_sindi_024   = tsind.c_sindi_019(+)
  GROUP BY tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tesc.c_coleg_024,
    tesc.n_delh_024,
    tesc.n_delm_024,
    tsind.siglas_019,
    tact.f_baja_016
  )
UNION ALL
  (SELECT tact.n_acta_016,
    tact.ano_acta_016,
    tact.c_territ_016,
    tact.version_016,
    tact.id_centro_016,
    tact.totelec_016,
    tact.f_elecc_016,
    tact.fregdef_016,
    tcent.cnae_001,
    tcnae.idsector,
    tsec.desc_004,
    NVL (tcnae.desccnae, 'cnae desconocido-'
    || tcent.cnae_001),
    tact.factu_016,
    tsind.c_sindi_019,
    tdif.c_coleg_018,
    0 AS n_votos_024,
    tdif.n_delh_018,
    tdif.n_delm_018,
    tsind.siglas_019,
    tact.f_baja_016
  FROM w83b16t00 tact,
    w83b.j7301s01 tcent,
    w83b18s00 tdif,
    w83bcnae tcnae,
    w83b.j7304s00 tsec,
    w83b19s00 tsind
  WHERE --tact.f_baja_016 IS NULL
    --AND
    tact.n_acttot_016 IS NULL
    --AND tact.fregdef_016 IS NOT NULL
  AND tact.n_regdef_016 IS NOT NULL
  AND tact.id_centro_016 = tcent.ccen_001
  AND tcent.cnae_001     = tcnae.idcnae(+)
  AND tcent.secc_001     = tcnae.idsector(+)
  AND tsec.secc_004      = tcent.secc_001
  AND tact.validada_016  = 1
  AND tact.n_acta_016    = tdif.n_acta_018(+)
  AND tact.ano_acta_016  = tdif.ano_acta_018(+)
  AND tact.c_territ_016  = tdif.c_territ_018(+)
  AND tact.version_016   = tdif.version_018(+)
  AND tdif.c_sindi_018   = tsind.c_sindi_019
  )
ORDER BY idsector,
  cnae_001,
  c_territ_016,
  ano_acta_016,
  n_acta_016,
  version_016;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSESCRTDIF" ("NUMACTA", "TERRITORIO", "ANOACTA", "VER", "TOTALDELEGADOS")
AS
  SELECT consultaf.numacta,
    consultaf.territ,
    consultaf.anoacta,
    consultaf.ver,
    SUM (consultaf.totalescrutinios + consultaf.totaldiferencias)
  FROM
    (SELECT consulta.numacta,
      consulta.territ,
      consulta.anoacta,
      consulta.ver,
      consulta.totalescrutinios,
      NVL (
      (SELECT SUM (n_delh_018 + n_delm_018)
      FROM w83b18s00 diferencias
      WHERE consulta.numacta = diferencias.n_acta_018(+)
      AND consulta.territ    = diferencias.c_territ_018(+)
      AND consulta.anoacta   = diferencias.ano_acta_018(+)
      AND consulta.ver       = diferencias.version_018(+)
      GROUP BY consulta.numacta,
        consulta.territ,
        consulta.anoacta,
        consulta.ver
      ), 0 ) AS totaldiferencias
    FROM
      (SELECT actas.n_acta_016                  AS numacta,
        actas.c_territ_016                      AS territ,
        actas.ano_acta_016                      AS anoacta,
        actas.version_016                       AS ver,
        NVL (SUM (n_delh_024 + n_delm_024), 0 ) AS totalescrutinios
      FROM w83b16s00 actas,
        w83b24s00 escrutinios
      WHERE actas.n_acta_016 = escrutinios.n_acta_024(+)
      AND actas.c_territ_016 = escrutinios.c_territ_024(+)
      AND actas.ano_acta_016 = escrutinios.ano_acta_024(+)
      AND actas.version_016  = escrutinios.version_024(+)
      GROUP BY actas.n_acta_016,
        actas.c_territ_016,
        actas.ano_acta_016,
        actas.version_016
      ) consulta
    GROUP BY consulta.numacta,
      consulta.territ,
      consulta.anoacta,
      consulta.ver,
      consulta.totalescrutinios
    ) consultaf
  GROUP BY consultaf.numacta,
    consultaf.territ,
    consultaf.anoacta,
    consultaf.ver;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSINCOMPLETOS" ("NACTA", "ACTA", "ANOACTA", "NACTACOMPLETO", "NUMREGISTRO", "NUMELECTORES", "RAZON", "TERRIT", "VER", "MAXIMODELEGADOS", "DEL")
AS
  SELECT DISTINCT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) acta,
    actas.n_acta_016,
    actas.ano_acta_016,
    TO_NUMBER ( actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) actacompleto,
    ( actas.c_territ_016
    || '/'
    || actas.ano_regdef_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_regdef_016)), 1, '00000'
    || TO_CHAR (actas.n_regdef_016), 2, '0000'
    || TO_CHAR (actas.n_regdef_016), 3, '000'
    || TO_CHAR (actas.n_regdef_016), 4, '00'
    || TO_CHAR (actas.n_regdef_016), 5, '0'
    || TO_CHAR (actas.n_regdef_016), TO_CHAR (actas.n_regdef_016) ) ) registro,
    actas.totelec_016,
    centros.rsoc_001,
    actas.c_territ_016,
    actas.version_016,
    actas.maxdel_016,
    escr.c_coleg_024
    || '#'
    || escr.c_sindi_024
    || '#'
    || escr.n_delh_024
    || '#'
    || escr.n_delm_024 del
  FROM w83b16s00 actas,
    w83b24s00 escr,
    j7301s01 centros,
    w83b13s00 conv
  WHERE actas.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00
    WHERE actas.n_acta_016 = n_acta_016
    AND actas.c_territ_016 = c_territ_016
    AND actas.ano_acta_016 = ano_acta_016
    AND validada_016       = 1
    )
  AND actas.c_territ_016  = escr.c_territ_024
  AND actas.ano_acta_016  = escr.ano_acta_024
  AND actas.n_acta_016    = escr.n_acta_024
  AND actas.version_016   = escr.version_024
  AND actas.id_centro_016 = centros.ccen_001
  AND actas.c_conv_016    = conv.c_conv_013
  AND actas.n_regdef_016 IS NOT NULL
  AND actas.fregdef_016  IS NOT NULL
  AND actas.f_baja_016   IS NULL
  AND actas.validada_016  = 1
  ORDER BY acta;

/****************************************************************************************************************************************************************/

CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSINCOMPLETOS2" ("NACTA", "ACTA", "ANOACTA", "NACTACOMPLETO", "NUMREGISTRO", "NUMELECTORES", "RAZON", "TERRIT", "VER", "MAXIMODELEGADOS", "DEL", "DELH", "DELM")
AS
  SELECT DISTINCT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) acta,
    actas.n_acta_016,
    actas.ano_acta_016,
    TO_NUMBER ( actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) actacompleto,
    ( actas.c_territ_016
    || '/'
    || actas.ano_regdef_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_regdef_016)), 1, '00000'
    || TO_CHAR (actas.n_regdef_016), 2, '0000'
    || TO_CHAR (actas.n_regdef_016), 3, '000'
    || TO_CHAR (actas.n_regdef_016), 4, '00'
    || TO_CHAR (actas.n_regdef_016), 5, '0'
    || TO_CHAR (actas.n_regdef_016), TO_CHAR (actas.n_regdef_016) ) ) registro,
    actas.totelec_016,
    centros.rsoc_001,
    actas.c_territ_016,
    actas.version_016,
    actas.maxdel_016,
    SUM (escr.n_delh_024 + escr.n_delm_024) AS del,
    SUM (escr.n_delh_024)                   AS delh,
    SUM (escr.n_delm_024)                   AS delm
  FROM w83b16s00 actas,
    w83b24s00 escr,
    j7301s01 centros,
    w83b13s00 conv
  WHERE actas.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00
    WHERE actas.n_acta_016 = n_acta_016
    AND actas.c_territ_016 = c_territ_016
    AND actas.ano_acta_016 = ano_acta_016
    AND validada_016       = 1
    )
  AND actas.c_territ_016  = escr.c_territ_024
  AND actas.ano_acta_016  = escr.ano_acta_024
  AND actas.n_acta_016    = escr.n_acta_024
  AND actas.version_016   = escr.version_024
  AND actas.id_centro_016 = centros.ccen_001
  AND actas.c_conv_016    = conv.c_conv_013
  AND actas.n_regdef_016 IS NOT NULL
  AND actas.fregdef_016  IS NOT NULL
  AND actas.f_baja_016   IS NULL
  AND actas.validada_016  = 1
  GROUP BY ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    actas.n_acta_016,
    actas.ano_acta_016,
    TO_NUMBER ( actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    ( actas.c_territ_016
    || '/'
    || actas.ano_regdef_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_regdef_016)), 1, '00000'
    || TO_CHAR (actas.n_regdef_016), 2, '0000'
    || TO_CHAR (actas.n_regdef_016), 3, '000'
    || TO_CHAR (actas.n_regdef_016), 4, '00'
    || TO_CHAR (actas.n_regdef_016), 5, '0'
    || TO_CHAR (actas.n_regdef_016), TO_CHAR (actas.n_regdef_016) ) ),
    actas.totelec_016,
    centros.rsoc_001,
    actas.c_territ_016,
    actas.version_016,
    actas.maxdel_016
  ORDER BY acta;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSINCOMPLETOS3" ("ACTA", "ANOACTA", "TERRIT", "VER", "HOMBRES", "MUJERES")
AS
  SELECT tabla24.n_acta_024,
    tabla24.ano_acta_024,
    tabla24.c_territ_024,
    tabla24.version_024,
    SUM (tabla24.n_delh_024),
    SUM (tabla24.n_delm_024)
  FROM w83b24t00 tabla24,
    (SELECT COUNT (dni_025) AS hombres,
      n_acta_025,
      ano_acta_025,
      c_territ_025,
      c_coleg_025,
      c_sindi_025,
      version_025
    FROM w83b25t00
    WHERE sexo_025  = 'V'
    AND f_baja_025 IS NULL
    GROUP BY n_acta_025,
      ano_acta_025,
      c_territ_025,
      c_coleg_025,
      c_sindi_025,
      version_025
    ) consultahombres,
    (SELECT COUNT (dni_025) AS mujeres,
      n_acta_025,
      ano_acta_025,
      c_territ_025,
      c_coleg_025,
      c_sindi_025,
      version_025
    FROM w83b25t00
    WHERE sexo_025  = 'M'
    AND f_baja_025 IS NULL
    GROUP BY n_acta_025,
      ano_acta_025,
      c_territ_025,
      c_coleg_025,
      c_sindi_025,
      version_025
    ) consultamujeres
  WHERE tabla24.c_territ_024 = consultahombres.c_territ_025
  AND tabla24.ano_acta_024   = consultahombres.ano_acta_025
  AND tabla24.n_acta_024     = consultahombres.n_acta_025
  AND tabla24.c_sindi_024    = consultahombres.c_sindi_025
  AND tabla24.c_coleg_024    = consultahombres.c_coleg_025
  AND tabla24.c_territ_024   = consultamujeres.c_territ_025
  AND tabla24.ano_acta_024   = consultamujeres.ano_acta_025
  AND tabla24.n_acta_024     = consultamujeres.n_acta_025
  AND tabla24.c_sindi_024    = consultamujeres.c_sindi_025
  AND tabla24.c_coleg_024    = consultamujeres.c_coleg_025
  AND tabla24.version_024    = consultamujeres.version_025
  AND tabla24.version_024    = consultahombres.version_025
  AND ( tabla24.n_delh_024  <> consultahombres.hombres
  OR tabla24.n_delm_024     <> consultamujeres.mujeres )
  GROUP BY n_acta_024,
    ano_acta_024,
    c_territ_024,
    version_024
  ORDER BY n_acta_024,
    ano_acta_024,
    c_territ_024;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSNUMEROACTA" ("NACTA", "ACTA", "ANOACTA", "NACTACOMPLETO", "NUMREGISTRO", "NUMELECTORES", "RAZON", "CIF", "DOMICILIO", "CODIGOCENTRO", "CONVENIO", "CONVENIOEU", "TERRIT", "VER", "DELEGADOSHOMBRES", "DELEGADOSMUJERES", "DESC_026", "DESE_026", "DESC_019", "DESE_019", "DESC_023", "DESE_023", "SIGLAS_019", "C_COLEG_025", "C_SINDI_025", "DNI_025", "NOMBRE_025", "APEL1_025", "APEL2_025", "SEXO_025", "F_BAJA_025", "DNI_SUST_025")
AS
  SELECT DISTINCT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) acta,
    actas.n_acta_016,
    actas.ano_acta_016,
    TO_NUMBER ( actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    ( actas.c_territ_016
    || '/'
    || actas.ano_regdef_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_regdef_016)), 1, '00000'
    || TO_CHAR (actas.n_regdef_016), 2, '0000'
    || TO_CHAR (actas.n_regdef_016), 3, '000'
    || TO_CHAR (actas.n_regdef_016), 4, '00'
    || TO_CHAR (actas.n_regdef_016), 5, '0'
    || TO_CHAR (actas.n_regdef_016), TO_CHAR (actas.n_regdef_016) ) ) registro,
    actas.totelec_016,
    centros.rsoc_001,
    centros.ccif_001,
    centros.domic_001,
    centros.ncen_001,
    conv.desc_013,
    conv.dese_013,
    actas.c_territ_016,
    actas.version_016,
    actas.delh_016 hombres,
    actas.delm_016 mujer,
    desc_026   AS desc26,
    dese_026   AS dese26,
    desc_019   AS desc19,
    dese_019   AS dese19,
    desc_023   AS desc23,
    dese_023   AS dese23,
    siglas_019 AS siglas,
    c_coleg_025,
    c_sindi_025,
    dni_025,
    nombre_025,
    apel1_025,
    apel2_025,
    sexo_025,
    TO_CHAR (f_baja_025, 'dd/MM/yyyy') f_baja_025,
    dni_sust_025
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b13s00 conv,
    w83b25s00 delegados,
    w83b26t00 baja,
    w83b19t00 sind,
    w83b23s00 col
  WHERE actas.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00
    WHERE actas.n_acta_016 = n_acta_016
    AND actas.c_territ_016 = c_territ_016
    AND actas.ano_acta_016 = ano_acta_016
    AND validada_016       = 1
    )
  AND actas.id_centro_016   = centros.ccen_001(+)
  AND actas.c_conv_016      = conv.c_conv_013(+)
  AND actas.ano_acta_016    = delegados.ano_acta_025
  AND actas.n_acta_016      = delegados.n_acta_025
  AND actas.c_territ_016    = delegados.c_territ_025
  AND actas.version_016     = delegados.version_025
  AND delegados.cbaja_025   = baja.cbaja_026(+)
  AND delegados.c_sindi_025 = sind.c_sindi_019
  AND delegados.c_coleg_025 = col.c_coleg_023
  AND actas.validada_016    = 1
  AND ( actas.n_regdef_016 IS NOT NULL
  AND actas.fregdef_016    IS NOT NULL )
  AND actas.f_baja_016     IS NULL
  ORDER BY acta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSPORCONVENIO" ("SECTOR", "DESCSECTOR", "NCENTRO", "CIF", "NACTA", "ANOACTA", "TERRIT", "VER", "TOTALELECTORES", "CODSINDICATO", "SIGLAS", "CODCONVENIO", "CONVDESC", "CONVDESE", "FELEC", "FECHAREGISTRO", "TOTALVOTOS", "NUMDELEGADOS", "FECHABAJA")
AS
  SELECT consulta.sector,
    consulta.descsector,
    consulta.centro,
    consulta.empresa,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.ver,
    consulta.totalelectores,
    consulta.codsindicato,
    consulta.siglas,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    NVL (
    (SELECT SUM (papeletas.vota_044)
    FROM w83b44s00 papeletas
    WHERE consulta.nacta = papeletas.n_acta_044
    AND consulta.anoacta = papeletas.ano_acta_044
    AND consulta.territ  = papeletas.c_territ_044
    AND consulta.ver     = papeletas.version_044
      /*and consulta.colegio = papeletas.C_COLEG_044*/
    ), 0 ) AS numvotos,
    consulta.numdelegados,
    consulta.fechabaja
  FROM
    (SELECT centros.secc_001                                             AS sector,
      sectores.desc_004                                                  AS descsector,
      centros.ccen_001                                                   AS centro,
      centros.ccif_001                                                   AS empresa,
      actas.n_acta_016                                                   AS nacta,
      actas.ano_acta_016                                                 AS anoacta,
      actas.c_territ_016                                                 AS territ,
      actas.version_016                                                  AS ver,
      totelec_016                                                        AS totalelectores,
      sindicatos.c_sindi_019                                             AS codsindicato,
      sindicatos.siglas_019                                              AS siglas,
      convenios.c_conv_013                                               AS codconvenio,
      convenios.desc_013                                                 AS descconvenio,
      convenios.dese_013                                                 AS deseconvenio,
      actas.f_elecc_016                                                  AS fechaeleccion,
      actas.fregdef_016                                                  AS fecharegistro,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 ), '0' ) AS numdelegados,
      actas.f_baja_016                                                   AS fechabaja,
      0                                                                  AS numvotos
      /*,
      escrutinios.C_COLEG_024 as colegio*/
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019
    AND centros.secc_001        = sectores.secc_004
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    AND actas.n_regdef_016     IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016
    /*,
    escrutinios.C_COLEG_024*/
    UNION ALL
    SELECT centros.secc_001                                              AS sector,
      sectores.desc_004                                                  AS descsector,
      centros.ccen_001                                                   AS centro,
      centros.ccif_001                                                   AS empresa,
      actas.n_acta_016                                                   AS nacta,
      actas.ano_acta_016                                                 AS anoacta,
      actas.c_territ_016                                                 AS territ,
      actas.version_016                                                  AS ver,
      totelec_016                                                        AS totalelectores,
      sindicatos.c_sindi_019                                             AS codsindicato,
      sindicatos.siglas_019                                              AS siglas,
      convenios.c_conv_013                                               AS codconvenio,
      convenios.desc_013                                                 AS descconvenio,
      convenios.dese_013                                                 AS deseconvenio,
      actas.f_elecc_016                                                  AS fechaeleccion,
      actas.fregdef_016                                                  AS fecharegistro,
      NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018 ), '0' ) AS numdelegados,
      actas.f_baja_016                                                   AS fechabaja,
      0                                                                  AS numvotos
      /*,
      diferencias.C_COLEG_018 as colegio*/
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019
    AND centros.secc_001        = sectores.secc_004
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.validada_016  = 1
    AND actas.n_regdef_016 IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016
      /*,
      diferencias.C_COLEG_018*/
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND act.validada_016 = 1
    )
  ORDER BY consulta.sector,
    consulta.descconvenio,
    consulta.codsindicato,
    consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSPORCONVENIOHIST" ("SECTOR", "DESCSECTOR", "NCENTRO", "CIF", "NACTA", "ANOACTA", "TERRIT", "VER", "TOTALELECTORES", "CODSINDICATO", "SIGLAS", "CODCONVENIO", "CONVDESC", "CONVDESE", "FELEC", "FECHAREGISTRO", "TOTALVOTOS", "NUMDELEGADOS", "FECHABAJA", "FECHAACTU")
AS
  SELECT consulta.sector,
    consulta.descsector,
    consulta.centro,
    consulta.empresa,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.ver,
    consulta.totalelectores,
    consulta.codsindicato,
    consulta.siglas,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    NVL (
    (SELECT SUM (papeletas.vota_044)
    FROM w83b44s00 papeletas
    WHERE consulta.nacta = papeletas.n_acta_044
    AND consulta.anoacta = papeletas.ano_acta_044
    AND consulta.territ  = papeletas.c_territ_044
    AND consulta.ver     = papeletas.version_044
    ), 0 ) AS numvotos,
    consulta.numdelegados,
    consulta.fechabaja,
    consulta.fechaactu
  FROM
    (SELECT centros.secc_001                                             AS sector,
      sectores.desc_004                                                  AS descsector,
      centros.ccen_001                                                   AS centro,
      centros.ccif_001                                                   AS empresa,
      actas.n_acta_016                                                   AS nacta,
      actas.ano_acta_016                                                 AS anoacta,
      actas.c_territ_016                                                 AS territ,
      actas.version_016                                                  AS ver,
      totelec_016                                                        AS totalelectores,
      sindicatos.c_sindi_019                                             AS codsindicato,
      sindicatos.siglas_019                                              AS siglas,
      convenios.c_conv_013                                               AS codconvenio,
      convenios.desc_013                                                 AS descconvenio,
      convenios.dese_013                                                 AS deseconvenio,
      actas.f_elecc_016                                                  AS fechaeleccion,
      actas.fregdef_016                                                  AS fecharegistro,
      NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 ), '0' ) AS numdelegados,
      actas.f_baja_016                                                   AS fechabaja,
      0                                                                  AS numvotos,
      actas.factu_016                                                    AS fechaactu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    AND actas.n_regdef_016     IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016
    UNION ALL
    SELECT centros.secc_001                                              AS sector,
      sectores.desc_004                                                  AS descsector,
      centros.ccen_001                                                   AS centro,
      centros.ccif_001                                                   AS empresa,
      actas.n_acta_016                                                   AS nacta,
      actas.ano_acta_016                                                 AS anoacta,
      actas.c_territ_016                                                 AS territ,
      actas.version_016                                                  AS ver,
      totelec_016                                                        AS totalelectores,
      sindicatos.c_sindi_019                                             AS codsindicato,
      sindicatos.siglas_019                                              AS siglas,
      convenios.c_conv_013                                               AS codconvenio,
      convenios.desc_013                                                 AS descconvenio,
      convenios.dese_013                                                 AS deseconvenio,
      actas.f_elecc_016                                                  AS fechaeleccion,
      actas.fregdef_016                                                  AS fecharegistro,
      NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018 ), '0' ) AS numdelegados,
      actas.f_baja_016                                                   AS fechabaja,
      0                                                                  AS numvotos,
      actas.factu_016                                                    AS fechaactu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.validada_016  = 1
    AND actas.n_regdef_016 IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016
    ) consulta
  ORDER BY consulta.sector,
    consulta.descconvenio,
    consulta.codsindicato,
    consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSRELACIONBAJAS" ("NACTA", "FECHABAJA", "MOTIVOBAJA", "MOTIVOBAJAEU", "RAZON", "NOMBRE", "SINDICATO", "DNI", "NOMBRESUSTITUTO", "SINDICATOSUSTITUTO", "DNISUSTITUTO", "TERRIT", "MAXIMODELEGADOS")
AS
  SELECT DISTINCT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) acta,
    delegados.f_baja_025,
    motivo.desc_026,
    motivo.dese_026,
    centros.rsoc_001,
    ( delegados.nombre_025
    || ' '
    || delegados.apel1_025
    || ' '
    || delegados.apel2_025 ) nombre,
    sindicato.siglas_019,
    delegados.dni_025,
    ( delegadosus.nombre_025
    || ' '
    || delegadosus.apel1_025
    || ' '
    || delegadosus.apel2_025 ) nombresus,
    sindicatosus.siglas_019,
    delegados.dni_sust_025,
    actas.c_territ_016,
    actas.maxdel_016
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b25s00 delegados,
    w83b25s00 delegadosus,
    w83b26s00 motivo,
    w83b19s00 sindicato,
    w83b19s00 sindicatosus,
    w83b13s00 conv
  WHERE actas.id_centro_016   = centros.ccen_001
  AND actas.c_conv_016        = conv.c_conv_013
  AND delegados.ano_acta_025  = actas.ano_acta_016
  AND delegados.n_acta_025    = actas.n_acta_016
  AND delegados.c_territ_025  = actas.c_territ_016
  AND delegados.version_025   = actas.version_016
  AND delegados.c_sindi_025   = sindicato.c_sindi_019(+)
  AND delegados.ano_acta_025  = delegadosus.ano_acta_025(+)
  AND delegados.n_acta_025    = delegadosus.n_acta_025(+)
  AND delegados.c_territ_025  = delegadosus.c_territ_025(+)
  AND delegados.version_025   = delegadosus.version_025(+)
  AND delegados.c_sindi_025   = sindicato.c_sindi_019(+)
  AND delegados.cbaja_025     = motivo.cbaja_026(+)
  AND delegados.dni_sust_025  = delegadosus.dni_025(+)
  AND delegadosus.c_sindi_025 = sindicatosus.c_sindi_019(+)
  ORDER BY delegados.f_baja_025,
    acta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW w83b.w83bdelegagrupconv (codagrup,
                                                      descagrup,
                                                      deseagrup,
                                                      codconvenio,
                                                      descconvenio,
                                                      deseconvenio,
                                                      codsindicato,
                                                      sinddesc,
                                                      sinddese,
                                                      nacta,
                                                      anoacta,
                                                      territ,
                                                      ver,
                                                      felec,
                                                      fecharegistro,
                                                      fechabaja,
                                                      numdelegados
                                                     )
AS
   SELECT   consulta.codagrup, consulta.descagrup, consulta.deseagrup,
            consulta.codconvenio, consulta.descconvenio,
            consulta.deseconvenio, consulta.codsindicato, consulta.sinddesc,
            consulta.sinddese, consulta.nacta, consulta.anoacta,
            consulta.territ, consulta.ver, consulta.felec,
            consulta.fecharegistro, consulta.fechabaja, consulta.numdelegados
       FROM (SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (escrutinios.n_delm_024
                                + escrutinios.n_delh_024
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b24s00 escrutinios,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016
             UNION ALL
             SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (diferencias.n_delm_018
                                + diferencias.n_delh_018
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b18s00 diferencias,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016) consulta
      WHERE consulta.ver =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.nacta = act.n_acta_016
                   AND consulta.anoacta = act.ano_acta_016
                   AND consulta.territ = c_territ_016
                   AND act.validada_016 = 1)
   ORDER BY consulta.codagrup, consulta.codconvenio, consulta.codsindicato;
/
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGPORCONVDETCEN" ("SECTOR", "DESCSECTOR", "NCENTRO", "CIF", "RAZON", "NACTA", "ANOACTA", "TERRIT", "VER", "TOTALELECTORES", "CODSINDICATO", "SIGLAS", "CODCONVENIO", "CONVDESC", "CONVDESE", "FELEC", "FECHAREGISTRO", "TOTALVOTOS", "NUMDELEGADOS", "NACTACOMPLETA", "FECHABAJA")
AS
  SELECT consulta.sector,
    consulta.descsector,
    consulta.centro,
    consulta.empresa,
    consulta.razon,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.ver,
    consulta.totalelectores,
    consulta.codsindicato,
    consulta.siglas,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    NVL (
    (SELECT SUM (papeletas.vota_044)
    FROM w83b44s00 papeletas
    WHERE consulta.nacta = papeletas.n_acta_044
    AND consulta.anoacta = papeletas.ano_acta_044
    AND consulta.territ  = papeletas.c_territ_044
    AND consulta.ver     = papeletas.version_044
    ), 0 ) AS numvotos,
    consulta.numdelegados,
    consulta.nactacompleta,
    consulta.fechabaja
  FROM
    (SELECT centros.secc_001                                 AS sector,
      sectores.desc_004                                      AS descsector,
      centros.ccen_001                                       AS centro,
      centros.ccif_001                                       AS empresa,
      centros.rsoc_001                                       AS razon,
      actas.n_acta_016                                       AS nacta,
      actas.ano_acta_016                                     AS anoacta,
      actas.c_territ_016                                     AS territ,
      actas.version_016                                      AS ver,
      totelec_016                                            AS totalelectores,
      sindicatos.c_sindi_019                                 AS codsindicato,
      sindicatos.siglas_019                                  AS siglas,
      convenios.c_conv_013                                   AS codconvenio,
      convenios.desc_013                                     AS descconvenio,
      convenios.dese_013                                     AS deseconvenio,
      actas.f_elecc_016                                      AS fechaeleccion,
      actas.fregdef_016                                      AS fecharegistro,
      0                                                      AS numvotos,
      SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 ) AS numdelegados,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.f_baja_016       AS fechabaja
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.validada_016  = 1
    AND actas.n_regdef_016 IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      centros.rsoc_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016
    UNION ALL
    SELECT centros.secc_001                                  AS sector,
      sectores.desc_004                                      AS descsector,
      centros.ccen_001                                       AS centro,
      centros.ccif_001                                       AS empresa,
      centros.rsoc_001                                       AS razon,
      actas.n_acta_016                                       AS nacta,
      actas.ano_acta_016                                     AS anoacta,
      actas.c_territ_016                                     AS territ,
      actas.version_016                                      AS ver,
      totelec_016                                            AS totalelectores,
      sindicatos.c_sindi_019                                 AS codsindicato,
      sindicatos.siglas_019                                  AS siglas,
      convenios.c_conv_013                                   AS codconvenio,
      convenios.desc_013                                     AS descconvenio,
      convenios.dese_013                                     AS deseconvenio,
      actas.f_elecc_016                                      AS fechaeleccion,
      actas.fregdef_016                                      AS fecharegistro,
      0                                                      AS numvotos,
      SUM (diferencias.n_delm_018 + diferencias.n_delh_018 ) AS numdelegados,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.f_baja_016       AS fechabaja
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.validada_016  = 1
    AND actas.n_regdef_016 IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      centros.rsoc_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND act.validada_016 = 1
    )
  ORDER BY consulta.codconvenio,
    consulta.razon,
    consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver,
    consulta.codsindicato;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGPORCONVDETCENHIST" ("SECTOR", "DESCSECTOR", "NCENTRO", "CIF", "RAZON", "NACTA", "ANOACTA", "TERRIT", "VER", "TOTALELECTORES", "CODSINDICATO", "SIGLAS", "CODCONVENIO", "CONVDESC", "CONVDESE", "FELEC", "FECHAREGISTRO", "TOTALVOTOS", "NUMDELEGADOS", "NACTACOMPLETA", "FECHABAJA", "FECHAACTU")
AS
  SELECT consulta.sector,
    consulta.descsector,
    consulta.centro,
    consulta.empresa,
    consulta.razon,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.ver,
    consulta.totalelectores,
    consulta.codsindicato,
    consulta.siglas,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    NVL (
    (SELECT SUM (papeletas.vota_044)
    FROM w83b44s00 papeletas
    WHERE consulta.nacta = papeletas.n_acta_044
    AND consulta.anoacta = papeletas.ano_acta_044
    AND consulta.territ  = papeletas.c_territ_044
    AND consulta.ver     = papeletas.version_044
    ), 0 ) AS numvotos,
    consulta.numdelegados,
    consulta.nactacompleta,
    consulta.fechabaja,
    consulta.factu
  FROM
    (SELECT centros.secc_001                                 AS sector,
      sectores.desc_004                                      AS descsector,
      centros.ccen_001                                       AS centro,
      centros.ccif_001                                       AS empresa,
      centros.rsoc_001                                       AS razon,
      actas.n_acta_016                                       AS nacta,
      actas.ano_acta_016                                     AS anoacta,
      actas.c_territ_016                                     AS territ,
      actas.version_016                                      AS ver,
      totelec_016                                            AS totalelectores,
      sindicatos.c_sindi_019                                 AS codsindicato,
      sindicatos.siglas_019                                  AS siglas,
      convenios.c_conv_013                                   AS codconvenio,
      convenios.desc_013                                     AS descconvenio,
      convenios.dese_013                                     AS deseconvenio,
      actas.f_elecc_016                                      AS fechaeleccion,
      actas.fregdef_016                                      AS fecharegistro,
      0                                                      AS numvotos,
      SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 ) AS numdelegados,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.f_baja_016       AS fechabaja,
      actas.factu_016        AS factu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
    AND actas.validada_016      = 1
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.n_regdef_016 IS NOT NULL
    AND actas.fregdef_016  IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      centros.rsoc_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016
    UNION ALL
    SELECT centros.secc_001                                  AS sector,
      sectores.desc_004                                      AS descsector,
      centros.ccen_001                                       AS centro,
      centros.ccif_001                                       AS empresa,
      centros.rsoc_001                                       AS razon,
      actas.n_acta_016                                       AS nacta,
      actas.ano_acta_016                                     AS anoacta,
      actas.c_territ_016                                     AS territ,
      actas.version_016                                      AS ver,
      totelec_016                                            AS totalelectores,
      sindicatos.c_sindi_019                                 AS codsindicato,
      sindicatos.siglas_019                                  AS siglas,
      convenios.c_conv_013                                   AS codconvenio,
      convenios.desc_013                                     AS descconvenio,
      convenios.dese_013                                     AS deseconvenio,
      actas.f_elecc_016                                      AS fechaeleccion,
      actas.fregdef_016                                      AS fecharegistro,
      0                                                      AS numvotos,
      SUM (diferencias.n_delm_018 + diferencias.n_delh_018 ) AS numdelegados,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.f_baja_016       AS fechabaja,
      actas.factu_016        AS factu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      j7304s00 sectores
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND centros.secc_001        = sectores.secc_004
      --AND actas.f_baja_016 IS NULL
    AND actas.n_acttot_016 IS NULL
    AND actas.validada_016  = 1
    AND actas.n_regdef_016 IS NOT NULL
    GROUP BY centros.secc_001,
      sectores.desc_004,
      centros.ccen_001,
      centros.ccif_001,
      centros.rsoc_001,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      totelec_016,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      convenios.c_conv_013,
      convenios.desc_013,
      convenios.dese_013,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016
    ) consulta
  ORDER BY consulta.codconvenio,
    consulta.razon,
    consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver,
    consulta.codsindicato;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDESCRIPCIONCOMARCA" ("IDCOMARCA", "DESCRCOMARCA", "IDMUNICIPIO", "IDPROVINCIA")
AS
  SELECT comarca.ID,
    comarca.ds_o,
    municipio.ID,
    municipio.provincia_id
  FROM t17i.t17_municipio municipio,
    t17i.t17_comarca comarca
  WHERE municipio.comarca_id = comarca.ID
  AND municipio.provincia_id = comarca.provincia_id;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDESHACERREGISTRO" ("VER", "ANOACTA", "TERRITORIO", "NUMACTA", "FECHAENTRADA", "CIF", "NUMCENTRO", "RAZONSOCIAL", "DIRECCION", "NUMTRABAJADORES", "MUNICIPIO", "PROVINCIA", "NUEVA", "SECCION", "FECHAREGISTRO", "NUMENTRADA", "FACTU", "NUMREPRESENTANTES", "NUMAACTAINT")
AS
  SELECT actas.version_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.n_acta_016,
    actas.f_entra_016,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    centros.domic_001,
    actas.totelec_016,
    centros.munic_001,
    centros.provc_001,
    actas.nueva_016,
    centros.secc_001,
    actas.fregdef_016,
    actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ),
    actas.factu_016,
    COUNT (delegados.dni_025) AS numrepresentantes,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint
  FROM w83b16s00 actas,
    w83b25s00 delegados,
    j7301s01 centros
  WHERE actas.n_acta_016       = delegados.n_acta_025(+)
  AND actas.ano_acta_016       = delegados.ano_acta_025(+)
  AND actas.c_territ_016       = delegados.c_territ_025(+)
  AND actas.version_016        = delegados.version_025(+)
  AND actas.id_centro_016      = centros.ccen_001
  AND delegados.f_baja_025(+) IS NULL
  AND actas.f_baja_016        IS NULL
  GROUP BY actas.version_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.n_acta_016,
    actas.f_entra_016,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    centros.domic_001,
    actas.totelec_016,
    centros.munic_001,
    centros.provc_001,
    nueva_016,
    centros.secc_001,
    actas.fregdef_016,
    actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ),
    actas.factu_016
  ORDER BY actas.nueva_016 DESC,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    actas.n_acta_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.version_016 ;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDETALLECENTROSINDICATO" ("NACTA", "TERRIT", "ANOACTA", "VER", "ANOREGDEF", "NREGDEF", "FELEC", "CIF", "SECTOR", "RAZON", "NCENTRO", "CONVDESC", "TOTALELECTORES", "NUMDELEGADOS", "SINDDESC", "SIGLAS", "CODSINDICATO", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO", "NACTACOMPLETA")
AS
  SELECT consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver,
    consulta.anoregdef,
    consulta.nregdef,
    consulta.felec,
    consulta.cif,
    consulta.sector,
    consulta.razon,
    consulta.ncentro,
    consulta.convdesc,
    consulta.totalelectores,
    consulta.numdelegados,
    consulta.sinddesc,
    consulta.siglas,
    consulta.codsindicato,
    consulta.actatotal,
    consulta.fechabaja,
    consulta.fecharegistro,
    consulta.nactacompleta
  FROM
    (SELECT actas.n_acta_016                                 AS nacta,
      actas.c_territ_016                                     AS territ,
      actas.ano_acta_016                                     AS anoacta,
      actas.version_016                                      AS ver,
      actas.ano_regdef_016                                   AS anoregdef,
      actas.n_regdef_016                                     AS nregdef,
      actas.f_elecc_016                                      AS felec,
      centros.ccif_001                                       AS cif,
      centros.secc_001                                       AS sector,
      centros.rsoc_001                                       AS razon,
      centros.ncen_001                                       AS ncentro,
      convenios.desc_013                                     AS convdesc,
      actas.totelec_016                                      AS totalelectores,
      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numdelegados,
      sindicatos.desc_019                                    AS sinddesc,
      sindicatos.siglas_019                                  AS siglas,
      sindicatos.c_sindi_019                                 AS codsindicato,
      actas.n_acttot_016                                     AS actatotal,
      actas.f_baja_016                                       AS fechabaja,
      actas.fregdef_016                                      AS fecharegistro,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      w83b19s00 sindicatos
    WHERE actas.id_centro_016   = centros.ccen_001
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.n_acta_016,
      actas.c_territ_016,
      actas.ano_acta_016,
      actas.version_016,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.f_elecc_016,
      actas.c_conv_016,
      centros.ccif_001,
      centros.secc_001,
      centros.rsoc_001,
      centros.ncen_001,
      convenios.desc_013,
      actas.totelec_016,
      escrutinios.c_sindi_024,
      sindicatos.desc_019,
      sindicatos.siglas_019,
      sindicatos.c_sindi_019,
      actas.n_acttot_016,
      actas.f_baja_016,
      actas.fregdef_016,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 )
    UNION ALL
    SELECT actas.n_acta_016                                  AS nacta,
      actas.c_territ_016                                     AS territ,
      actas.ano_acta_016                                     AS anoacta,
      actas.version_016                                      AS ver,
      actas.ano_regdef_016                                   AS anoregdef,
      actas.n_regdef_016                                     AS nregdef,
      actas.f_elecc_016                                      AS felec,
      centros.ccif_001                                       AS cif,
      centros.secc_001                                       AS sector,
      centros.rsoc_001                                       AS razon,
      centros.ncen_001                                       AS ncentro,
      convenios.desc_013                                     AS convdesc,
      actas.totelec_016                                      AS totalelectores,
      SUM (diferencias.n_delh_018 + diferencias.n_delm_018 ) AS numdelegados,
      sindicatos.desc_019                                    AS sinddesc,
      sindicatos.siglas_019                                  AS siglas,
      sindicatos.c_sindi_019                                 AS codsindicato,
      actas.n_acttot_016                                     AS actatotal,
      actas.f_baja_016                                       AS fechabaja,
      actas.fregdef_016                                      AS fecharegistro,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      w83b19s00 sindicatos
    WHERE actas.id_centro_016   = centros.ccen_001
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.n_acta_016,
      actas.c_territ_016,
      actas.ano_acta_016,
      actas.version_016,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.f_elecc_016,
      actas.c_conv_016,
      centros.ccif_001,
      centros.secc_001,
      centros.rsoc_001,
      centros.ncen_001,
      convenios.desc_013,
      actas.totelec_016,
      diferencias.c_sindi_018,
      sindicatos.desc_019,
      sindicatos.siglas_019,
      sindicatos.c_sindi_019,
      actas.n_acttot_016,
      actas.f_baja_016,
      actas.fregdef_016,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 )
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta  = act.n_acta_016
    AND consulta.anoacta  = act.ano_acta_016
    AND consulta.territ   = c_territ_016
    AND act.validada_016  = 1
    AND act.n_acttot_016 IS NULL
    )
  ORDER BY consulta.nacta ASC,
    consulta.anoacta ASC,
    consulta.territ ASC,
    consulta.codsindicato ASC;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDETALLECENTROSINDICATOHIST" ("NACTA", "TERRIT", "ANOACTA", "VER", "ANOREGDEF", "NREGDEF", "FELEC", "CIF", "SECTOR", "RAZON", "NCENTRO", "CONVDESC", "TOTALELECTORES", "NUMDELEGADOS", "SINDDESC", "SIGLAS", "CODSINDICATO", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO", "NACTACOMPLETA", "FECHAACTU")
AS
  SELECT consulta.nacta,
    consulta.territ,
    consulta.anoacta,
    consulta.ver,
    consulta.anoregdef,
    consulta.nregdef,
    consulta.felec,
    consulta.cif,
    consulta.sector,
    consulta.razon,
    consulta.ncentro,
    consulta.convdesc,
    consulta.totalelectores,
    consulta.numdelegados,
    consulta.sinddesc,
    consulta.siglas,
    consulta.codsindicato,
    consulta.actatotal,
    consulta.fechabaja,
    consulta.fecharegistro,
    consulta.nactacompleta,
    consulta.fechaactu
  FROM
    (SELECT actas.n_acta_016                                 AS nacta,
      actas.c_territ_016                                     AS territ,
      actas.ano_acta_016                                     AS anoacta,
      actas.version_016                                      AS ver,
      actas.ano_regdef_016                                   AS anoregdef,
      actas.n_regdef_016                                     AS nregdef,
      actas.f_elecc_016                                      AS felec,
      centros.ccif_001                                       AS cif,
      centros.secc_001                                       AS sector,
      centros.rsoc_001                                       AS razon,
      centros.ncen_001                                       AS ncentro,
      convenios.desc_013                                     AS convdesc,
      actas.totelec_016                                      AS totalelectores,
      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numdelegados,
      sindicatos.desc_019                                    AS sinddesc,
      sindicatos.siglas_019                                  AS siglas,
      sindicatos.c_sindi_019                                 AS codsindicato,
      actas.n_acttot_016                                     AS actatotal,
      actas.f_baja_016                                       AS fechabaja,
      actas.fregdef_016                                      AS fecharegistro,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.factu_016        AS fechaactu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b13s00 convenios,
      w83b24s00 escrutinios,
      w83b19s00 sindicatos
    WHERE actas.id_centro_016   = centros.ccen_001
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_acta_016        = escrutinios.n_acta_024
    AND actas.ano_acta_016      = escrutinios.ano_acta_024
    AND actas.c_territ_016      = escrutinios.c_territ_024
    AND actas.version_016       = escrutinios.version_024
    AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.n_acta_016,
      actas.c_territ_016,
      actas.ano_acta_016,
      actas.version_016,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.f_elecc_016,
      actas.c_conv_016,
      centros.ccif_001,
      centros.secc_001,
      centros.rsoc_001,
      centros.ncen_001,
      convenios.desc_013,
      actas.totelec_016,
      escrutinios.c_sindi_024,
      sindicatos.desc_019,
      sindicatos.siglas_019,
      sindicatos.c_sindi_019,
      actas.n_acttot_016,
      actas.f_baja_016,
      actas.fregdef_016,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ),
      actas.factu_016
    UNION ALL
    SELECT actas.n_acta_016                                  AS nacta,
      actas.c_territ_016                                     AS territ,
      actas.ano_acta_016                                     AS anoacta,
      actas.version_016                                      AS ver,
      actas.ano_regdef_016                                   AS anoregdef,
      actas.n_regdef_016                                     AS nregdef,
      actas.f_elecc_016                                      AS felec,
      centros.ccif_001                                       AS cif,
      centros.secc_001                                       AS sector,
      centros.rsoc_001                                       AS razon,
      centros.ncen_001                                       AS ncentro,
      convenios.desc_013                                     AS convdesc,
      actas.totelec_016                                      AS totalelectores,
      SUM (diferencias.n_delh_018 + diferencias.n_delm_018 ) AS numdelegados,
      sindicatos.desc_019                                    AS sinddesc,
      sindicatos.siglas_019                                  AS siglas,
      sindicatos.c_sindi_019                                 AS codsindicato,
      actas.n_acttot_016                                     AS actatotal,
      actas.f_baja_016                                       AS fechabaja,
      actas.fregdef_016                                      AS fecharegistro,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ) AS nactacompleta,
      actas.factu_016        AS fechaactu
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b13s00 convenios,
      w83b18s00 diferencias,
      w83b19s00 sindicatos
    WHERE actas.id_centro_016   = centros.ccen_001
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.n_acta_016,
      actas.c_territ_016,
      actas.ano_acta_016,
      actas.version_016,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.f_elecc_016,
      actas.c_conv_016,
      centros.ccif_001,
      centros.secc_001,
      centros.rsoc_001,
      centros.ncen_001,
      convenios.desc_013,
      actas.totelec_016,
      diferencias.c_sindi_018,
      sindicatos.desc_019,
      sindicatos.siglas_019,
      sindicatos.c_sindi_019,
      actas.n_acttot_016,
      actas.f_baja_016,
      actas.fregdef_016,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
      || actas.version_016 ),
      actas.factu_016
    ) consulta
  ORDER BY consulta.nacta ASC,
    consulta.anoacta ASC,
    consulta.territ ASC,
    consulta.codsindicato ASC;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDETALLECENTROSINDICATOINC" ("NACTA", "TERRIT", "ANOACTA", "VER", "ANOREGDEF", "NREGDEF", "FELEC", "CIF", "SECTOR", "RAZON", "NCENTRO", "CONVDESC", "TOTALELECTORES", "NUMDELEGADOS", "SINDDESC", "SIGLAS", "CODSINDICATO", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO", "NACTACOMPLETA")
                                                           AS
  SELECT actas.n_acta_016                                  AS nacta,
    actas.c_territ_016                                     AS territ,
    actas.ano_acta_016                                     AS anoacta,
    actas.version_016                                      AS ver,
    actas.ano_regdef_016                                   AS anoregdef,
    actas.n_regdef_016                                     AS nregdef,
    actas.f_elecc_016                                      AS felec,
    centros.ccif_001                                       AS cif,
    centros.secc_001                                       AS sector,
    centros.rsoc_001                                       AS razon,
    centros.ncen_001                                       AS ncentro,
    convenios.desc_013                                     AS convdesc,
    actas.totelec_016                                      AS totalelectores,
    SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numdelegados,
    sindicatos.desc_019                                    AS sinddesc,
    sindicatos.siglas_019                                  AS siglas,
    sindicatos.c_sindi_019                                 AS codsindicato,
    actas.n_acttot_016                                     AS actatotal,
    actas.f_baja_016                                       AS fechabaja,
    actas.fregdef_016                                      AS fecharegistro,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 ) AS nactacompleta
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b13s00 convenios,
    w83b24s00 escrutinios,
    w83b19s00 sindicatos
  WHERE actas.id_centro_016   = centros.ccen_001
  AND actas.c_conv_016        = convenios.c_conv_013
  AND actas.n_acta_016        = escrutinios.n_acta_024
  AND actas.ano_acta_016      = escrutinios.ano_acta_024
  AND actas.c_territ_016      = escrutinios.c_territ_024
  AND actas.version_016       = escrutinios.version_024
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019
  AND actas.n_regdef_016     IS NOT NULL
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.version_016       =
    (SELECT MAX (act.version_016)
    FROM w83b16s00 act
    WHERE actas.n_acta_016 = act.n_acta_016
    AND actas.ano_acta_016 = act.ano_acta_016
    AND actas.c_territ_016 = c_territ_016
    AND act.validada_016   = 1
    )
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.ano_regdef_016,
    actas.n_regdef_016,
    actas.f_elecc_016,
    actas.c_conv_016,
    centros.ccif_001,
    centros.secc_001,
    centros.rsoc_001,
    centros.ncen_001,
    convenios.desc_013,
    actas.totelec_016,
    escrutinios.c_sindi_024,
    sindicatos.desc_019,
    sindicatos.siglas_019,
    sindicatos.c_sindi_019,
    actas.n_acttot_016,
    actas.f_baja_016,
    actas.fregdef_016,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 )
  ORDER BY actas.n_acta_016 ASC,
    actas.ano_acta_016 ASC,
    actas.c_territ_016 ASC,
    sindicatos.c_sindi_019 ASC;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDETALLECENTROSINDICATOINCH" ("NACTA", "TERRIT", "ANOACTA", "VER", "ANOREGDEF", "NREGDEF", "FELEC", "CIF", "SECTOR", "RAZON", "NCENTRO", "CONVDESC", "TOTALELECTORES", "NUMDELEGADOS", "SINDDESC", "SIGLAS", "CODSINDICATO", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO", "NACTACOMPLETA", "FECHAACTU")
                                                           AS
  SELECT actas.n_acta_016                                  AS nacta,
    actas.c_territ_016                                     AS territ,
    actas.ano_acta_016                                     AS anoacta,
    actas.version_016                                      AS ver,
    actas.ano_regdef_016                                   AS anoregdef,
    actas.n_regdef_016                                     AS nregdef,
    actas.f_elecc_016                                      AS felec,
    centros.ccif_001                                       AS cif,
    centros.secc_001                                       AS sector,
    centros.rsoc_001                                       AS razon,
    centros.ncen_001                                       AS ncentro,
    convenios.desc_013                                     AS convdesc,
    actas.totelec_016                                      AS totalelectores,
    SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numdelegados,
    sindicatos.desc_019                                    AS sinddesc,
    sindicatos.siglas_019                                  AS siglas,
    sindicatos.c_sindi_019                                 AS codsindicato,
    actas.n_acttot_016                                     AS actatotal,
    actas.f_baja_016                                       AS fechabaja,
    actas.fregdef_016                                      AS fecharegistro,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 ) AS nactacompleta,
    actas.factu_016        AS fechaactu
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b13s00 convenios,
    w83b24s00 escrutinios,
    w83b19s00 sindicatos
  WHERE actas.id_centro_016   = centros.ccen_001
  AND actas.c_conv_016        = convenios.c_conv_013
  AND actas.n_acta_016        = escrutinios.n_acta_024
  AND actas.ano_acta_016      = escrutinios.ano_acta_024
  AND actas.c_territ_016      = escrutinios.c_territ_024
  AND actas.version_016       = escrutinios.version_024
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019
  AND actas.n_regdef_016     IS NOT NULL
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.ano_regdef_016,
    actas.n_regdef_016,
    actas.f_elecc_016,
    actas.c_conv_016,
    centros.ccif_001,
    centros.secc_001,
    centros.rsoc_001,
    centros.ncen_001,
    convenios.desc_013,
    actas.totelec_016,
    escrutinios.c_sindi_024,
    sindicatos.desc_019,
    sindicatos.siglas_019,
    sindicatos.c_sindi_019,
    actas.n_acttot_016,
    actas.f_baja_016,
    actas.fregdef_016,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 ),
    actas.factu_016
  ORDER BY actas.n_acta_016 ASC,
    actas.ano_acta_016 ASC,
    actas.c_territ_016 ASC,
    sindicatos.c_sindi_019 ASC;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW w83b.w83bdetallepreavpendtram (raz_social_008,
                                                            domic_008,
                                                            c_territ_008,
                                                            munic_008,
                                                            codpos_008,
                                                            telefono_008,
                                                            fax_008,
                                                            email_008,
                                                            cnae_008,
                                                            f_inicio_008,
                                                            c_conv_008,
                                                            s_parcial_008,
                                                            global_008,
                                                            admonemp_008,
                                                            n_cenafec_008,
                                                            c_sindi_prom_008,
                                                            ident_008,
                                                            observ_008,
                                                            estado_008,
                                                            preaviso_008,
                                                            f_entrada_007,
                                                            desccnae,
                                                            cif_008,
                                                            lote_008,
                                                            n_regis_008,
                                                            prov_008,
                                                            n_preavisos_007,
                                                            tipo_008,
                                                            n_preaviso_008,
                                                            ano_preaviso_008,
                                                            f_regis_008,
                                                            c_sindi_007,
                                                            correl_007,
                                                            f_creacion_007,
                                                            tipo_iden_008,
                                                            th_ss_008,
                                                            n_ss_008,
                                                            ctrl_ss_008,
                                                            n_trabaj_008,
                                                            ncen_008
                                                           )
AS
   SELECT raz_social_008, domic_008, c_territ_008, munic_008, codpos_008,
          telefono_008, fax_008, email_008, cnae_008, f_inicio_008,
          c_conv_008, s_parcial_008, global_008, admonemp_008, n_cenafec_008,
          c_sindi_prom_008, ident_008, observ_008, estado_008, preaviso_008,
          f_entrada_007, desccnae, cif_008, lote_008, n_regis_008, prov_008,
          n_preavisos_007, tipo_008, n_preaviso_008, ano_preaviso_008,
          f_regis_008, c_sindi_007, correl_007, f_creacion_007, tipo_iden_008,
          th_ss_008, n_ss_008, ctrl_ss_008, n_trabaj_008,ncen_008
     FROM w83b08s00 preavisos INNER JOIN w83b07s00 lotes
          ON preavisos.lote_008 = lotes.lote_007
          LEFT OUTER JOIN w83bcnae cnae ON preavisos.cnae_008 = cnae.idcnae
          ;
/
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDIFERENCIASPORCONVENIO" ("NREGISTRO", "CODPROVINCIA", "CODMUNICIPIO", "CODCNAE", "NACTA", "NACTACOMPLETA", "TERRIT", "TOTALELECTORES", "CODCONVENIO", "DESCCONVENIO", "DESECONVENIO", "ADMINEMP", "CODCOLEGIO", "CODSINDICATO", "SIGLAS", "NUMDELEGADOS", "FELEC", "FECHAREGISTRO", "FECHABAJA")
AS
  SELECT consulta.territ
    || '/'
    || consulta.anoreg
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nreg)), 1, '00000'
    || TO_CHAR (consulta.nreg), 2, '0000'
    || TO_CHAR (consulta.nreg), 3, '000'
    || TO_CHAR (consulta.nreg), 4, '00'
    || TO_CHAR (consulta.nreg), 5, '0'
    || TO_CHAR (consulta.nreg), TO_CHAR (consulta.nreg) ),
    consulta.codprovincia,
    consulta.codmunicipio,
    consulta.codcnae,
    consulta.territ
    || '/'
    || consulta.anoacta
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ),
    TO_NUMBER ( consulta.anoacta
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ) ),
    consulta.territ,
    consulta.numtrabajadores,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.adminemp,
    consulta.codcolegio,
    consulta.codsindicato,
    consulta.siglas,
    consulta.delegadosdiferenciash + consulta.delegadosdiferenciasm,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja
  FROM
    (SELECT actas.totelec_016 AS numtrabajadores,
      DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
      || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ) AS codprovincia,
      DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
      || TO_CHAR (centros.munic_001), 2, '0'
      || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ) AS codmunicipio,
      centros.cnae_001                                              AS codcnae,
      actas.ano_regdef_016                                          AS anoreg,
      actas.n_regdef_016                                            AS nreg,
      actas.n_acta_016                                              AS nacta,
      actas.ano_acta_016                                            AS anoacta,
      actas.c_territ_016                                            AS territ,
      actas.version_016                                             AS ver,
      actas.f_elecc_016                                             AS fechaeleccion,
      actas.fregdef_016                                             AS fecharegistro,
      actas.f_baja_016                                              AS fbaja,
      actas.c_conv_016                                              AS codconvenio,
      convenios.desc_013                                            AS descconvenio,
      convenios.dese_013                                            AS deseconvenio,
      CASE
        WHEN (diferencias.c_coleg_018 = '0')
        THEN 'T'
        WHEN (diferencias.c_coleg_018 = '1')
        THEN 'E'
        ELSE ''
      END                     AS codcolegio,
      diferencias.c_sindi_018 AS codsindicato,
      sindicatos.siglas_019   AS siglas,
      CASE
        WHEN (preavisos.admonemp_037 = 'A')
        THEN 'S'
        WHEN (preavisos.admonemp_037 = 'E')
        THEN 'N'
        ELSE ''
      END                                   AS adminemp,
      COALESCE (diferencias.n_delh_018, 0 ) AS delegadosdiferenciash,
      COALESCE (diferencias.n_delm_018, 0 ) AS delegadosdiferenciasm
    FROM w83b16s00 actas,
      w83b37s00 preavisos,
      j7301s01 centros,
      w83b18s00 diferencias,
      w83b13s00 convenios,
      w83b19s00 sindicatos
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND actas.n_preaviso_016    = preavisos.n_preaviso_037
    AND actas.ano_preaviso_016  = preavisos.ano_preaviso_037
    AND actas.c_territ_016      = preavisos.c_territ_037
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019
    AND actas.c_conv_016        = convenios.c_conv_013
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.fregdef_016      IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.totelec_016,
      centros.provc_001,
      centros.munic_001,
      centros.cnae_001,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.c_conv_016,
      convenios.desc_013,
      convenios.dese_013,
      diferencias.c_coleg_018,
      diferencias.c_sindi_018,
      sindicatos.siglas_019,
      preavisos.admonemp_037,
      diferencias.n_delh_018,
      diferencias.n_delm_018
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 actas
    WHERE consulta.nacta   = actas.n_acta_016
    AND consulta.anoacta   = actas.ano_acta_016
    AND consulta.territ    = c_territ_016
    AND actas.validada_016 = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDIFERENCIASPORCONVENIOHIST" ("NREGISTRO", "CODPROVINCIA", "CODMUNICIPIO", "CODCNAE", "NACTA", "NACTACOMPLETA", "TERRIT", "TOTALELECTORES", "CODCONVENIO", "DESCCONVENIO", "DESECONVENIO", "ADMINEMP", "CODCOLEGIO", "CODSINDICATO", "SIGLAS", "NUMDELEGADOS", "FELEC", "FECHAREGISTRO", "FECHABAJA", "FECHAACTU", "VERS", "ANOACTA", "ACTA")
AS
  SELECT consulta.territ
    || '/'
    || consulta.anoreg
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nreg)), 1, '00000'
    || TO_CHAR (consulta.nreg), 2, '0000'
    || TO_CHAR (consulta.nreg), 3, '000'
    || TO_CHAR (consulta.nreg), 4, '00'
    || TO_CHAR (consulta.nreg), 5, '0'
    || TO_CHAR (consulta.nreg), TO_CHAR (consulta.nreg) ),
    consulta.codprovincia,
    consulta.codmunicipio,
    consulta.codcnae,
    consulta.territ
    || '/'
    || consulta.anoacta
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ),
    TO_NUMBER ( consulta.anoacta
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ) ),
    consulta.territ,
    consulta.numtrabajadores,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.adminemp,
    consulta.codcolegio,
    consulta.codsindicato,
    consulta.siglas,
    consulta.delegadosdiferenciash + consulta.delegadosdiferenciasm,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja,
    consulta.factu,
    consulta.vers,
    consulta.anoacta,
    consulta.nacta
  FROM
    (SELECT actas.totelec_016 AS numtrabajadores,
      DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
      || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ) AS codprovincia,
      DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
      || TO_CHAR (centros.munic_001), 2, '0'
      || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ) AS codmunicipio,
      centros.cnae_001                                              AS codcnae,
      actas.ano_regdef_016                                          AS anoreg,
      actas.n_regdef_016                                            AS nreg,
      actas.n_acta_016                                              AS nacta,
      actas.ano_acta_016                                            AS anoacta,
      actas.c_territ_016                                            AS territ,
      actas.version_016                                             AS ver,
      actas.f_elecc_016                                             AS fechaeleccion,
      actas.fregdef_016                                             AS fecharegistro,
      actas.f_baja_016                                              AS fbaja,
      actas.factu_016                                               AS factu,
      actas.c_conv_016                                              AS codconvenio,
      convenios.desc_013                                            AS descconvenio,
      convenios.dese_013                                            AS deseconvenio,
      actas.version_016                                             AS vers,
      CASE
        WHEN (diferencias.c_coleg_018 = '0')
        THEN 'T'
        WHEN (diferencias.c_coleg_018 = '1')
        THEN 'E'
        ELSE ''
      END                     AS codcolegio,
      diferencias.c_sindi_018 AS codsindicato,
      sindicatos.siglas_019   AS siglas,
      CASE
        WHEN (preavisos.admonemp_037 = 'A')
        THEN 'S'
        WHEN (preavisos.admonemp_037 = 'E')
        THEN 'N'
        ELSE ''
      END                                   AS adminemp,
      COALESCE (diferencias.n_delh_018, 0 ) AS delegadosdiferenciash,
      COALESCE (diferencias.n_delm_018, 0 ) AS delegadosdiferenciasm
    FROM w83b16s00 actas,
      w83b37s00 preavisos,
      j7301s01 centros,
      w83b18s00 diferencias,
      w83b13s00 convenios,
      w83b19s00 sindicatos
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.n_acta_016        = diferencias.n_acta_018
    AND actas.ano_acta_016      = diferencias.ano_acta_018
    AND actas.c_territ_016      = diferencias.c_territ_018
    AND actas.version_016       = diferencias.version_018
    AND actas.n_preaviso_016    = preavisos.n_preaviso_037(+)
    AND actas.ano_preaviso_016  = preavisos.ano_preaviso_037(+)
    AND actas.c_territ_016      = preavisos.c_territ_037(+)
    AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_regdef_016     IS NOT NULL
    AND actas.fregdef_016      IS NOT NULL
    AND actas.n_acttot_016     IS NULL
    AND actas.validada_016      = 1
    GROUP BY actas.totelec_016,
      centros.provc_001,
      centros.munic_001,
      centros.cnae_001,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016,
      actas.c_conv_016,
      convenios.desc_013,
      convenios.dese_013,
      diferencias.c_coleg_018,
      diferencias.c_sindi_018,
      sindicatos.siglas_019,
      preavisos.admonemp_037,
      diferencias.n_delh_018,
      diferencias.n_delm_018
    ) consulta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDOCSACTAS" ("ID_DOC_020", "NOMB_DOCU_020", "C_TERRIT_020", "ANO_ACTA_020", "N_ACTA_020", "TP_DOC_020", "DESC_CAS_069", "DESC_EUS_069", "NUM_REG_020", "F_REG_020", "USUARIO_020", "VERSION_020", "DESC_052", "DESE_052", "DESC_012", "DESE_012")
AS
  SELECT t20.id_doc_020,
    t20.nomb_docu_020,
    t20.c_territ_020,
    t20.ano_acta_020,
    t20.n_acta_020,
    t20.tp_doc_020,
    t69.desc_cas_069,
    t69.desc_eus_069,
    t20.num_reg_020,
    t20.f_reg_020,
    t20.usuario_020,
    t20.version_020,
    fase.desc_052,
    fase.dese_052,
    tramite.desc_012,
    tramite.dese_012
  FROM w83b.w83b69t00 t69,
    w83b.w83b20t00 t20,
    w83b.w83b52t00 fase,
    w83b12t00 tramite
  WHERE t69.idtp_doc_069 = t20.tp_doc_020
  AND t69.c_fase_069     = t20.c_fase_020
  AND t69.c_tram_069     = t20.c_tram_020
  AND t20.c_tram_020     = tramite.c_tram_012
  AND t20.c_fase_020     = fase.c_fase_052
  AND fase.c_fase_052    = tramite.c_fase_012;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDOCSIMPUGNACIONES" ("ID_DOC_041", "NOMB_DOCU_041", "C_TERRIT_041", "ANO_IMPUG_041", "N_IMPUG_041", "C_FASE_041", "C_TRAM_041", "DESC_012", "DESE_012", "TP_DOC_041", "DESC_CAS_069", "DESC_EUS_069", "NUM_REG_041", "F_REG_041", "USUARIO_041", "DOCUMENTO_041", "DESC_052", "DESE_052")
AS
  SELECT t41.id_doc_041,
    t41.nomb_docu_041,
    t41.c_territ_041,
    t41.ano_impug_041,
    t41.n_impug_041,
    t41.c_fase_041,
    t41.c_tram_041,
    t12.desc_012,
    t12.dese_012,
    t41.tp_doc_041,
    t69.desc_cas_069,
    t69.desc_eus_069,
    t41.num_reg_041,
    t41.f_reg_041,
    t41.usuario_041,
    t41.documento_041,
    t52.DESC_052,
    t52.DESE_052
  FROM w83b.w83b69t00 t69,
    w83b.w83b41t00 t41,
    w83b.w83b12t00 t12,
    w83b.w83b52t00 t52
  WHERE t69.idtp_doc_069 = t41.tp_doc_041
  AND t69.c_fase_069     = t41.c_fase_041
  AND t69.c_tram_069     = t41.c_tram_041
  AND t12.c_fase_012     = t41.c_fase_041
  AND t12.c_tram_012     = t41.c_tram_041
  AND t12.C_FASE_012     = t52.C_FASE_052 ;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDOCSINCIDENCIAS" ("ID_DOC_064", "NOMB_DOCU_064", "C_TERRIT_064", "ANO_INCIDENCIA_064", "N_INCIDENCIA_064", "TP_DOC_064", "DESC_CAS_069", "DESC_EUS_069", "DESC_CAS_052", "DESC_EUS_052", "DESC_CAS_012", "DESC_EUS_012", "NUM_REG_064", "F_REG_064", "USUARIO_064")
AS
  SELECT t64.id_doc_064,
    t64.nomb_docu_064,
    t64.c_territ_064,
    t64.ano_incid_064,
    t64.n_incid_064,
    t64.tp_doc_064,
    t69.desc_cas_069,
    t69.desc_eus_069,
    t52.desc_052,
    t52.dese_052,
    t12.desc_012,
    t12.dese_012,
    t64.num_reg_064,
    t64.f_reg_064,
    t64.usuario_064
  FROM w83b69s00 t69,
    w83b64s00 t64,
    w83b52s00 t52,
    w83b12s00 t12
  WHERE t69.idtp_doc_069 = t64.tp_doc_064
  AND t69.c_fase_069     = t64.c_fase_064
  AND t69.c_tram_069     = t64.c_tram_064
  AND t69.c_fase_069     = t52.c_fase_052
  AND t69.c_fase_069     = t12.c_fase_012
  AND t69.c_tram_069     = t12.c_tram_012;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BDOCSPREAVISOS" ("ID_DOC_038", "NOMB_DOCU_038", "C_TERRIT_038", "ANO_PREAVISO_038", "N_PREAVISO_038", "TP_DOC_038", "DESC_CAS_069", "DESC_EUS_069", "DESC_CAS_052", "DESC_EUS_052", "DESC_CAS_012", "DESC_EUS_012", "NUM_REG_038", "F_REG_038", "USUARIO_038")
AS
  SELECT t38.id_doc_038,
    t38.nomb_docu_038,
    t38.c_territ_038,
    t38.ano_preaviso_038,
    t38.n_preaviso_038,
    t38.tp_doc_038,
    t69.desc_cas_069,
    t69.desc_eus_069,
    t52.desc_052,
    t52.dese_052,
    t12.desc_012,
    t12.dese_012,
    t38.num_reg_038,
    t38.f_reg_038,
    t38.usuario_038
  FROM w83b.w83b69t00 t69,
    w83b.w83b38t00 t38,
    w83b.w83b52t00 t52,
    w83b.w83b12t00 t12
  WHERE t69.idtp_doc_069 = t38.tp_doc_038
  AND t69.c_fase_069     = t38.c_fase_038
  AND t69.c_tram_069     = t38.c_tram_038
  AND t69.c_fase_069     = t52.c_fase_052
  AND t69.c_fase_069     = t12.c_fase_012
  AND t69.c_tram_069     = t12.c_tram_012;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BEMPRESASVARIOSCENTROS" ("NACTA", "CIF", "NUMELECTORES", "NUMCANDIDATOS", "CONVENIO", "CONVENIOEU", "CODIGOCENTRO", "RAZON", "CODPOSTAL", "CNAE", "DOMICILIO", "TERRIT", "FECHAENTRADA", "PROVI", "MUNI")
AS
  SELECT DISTINCT ( actas.c_territ_016
    || '/'
    || actas.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) acta,
    centros.ccif_001,
    actas.totelec_016,
    (actas.candh_016 + actas.candm_016) AS candidatos,
    conv.desc_013,
    conv.dese_013,
    centros.ncen_001,
    centros.rsoc_001,
    centros.cposc_001,
    centros.cnae_001,
    centros.domic_001,
    actas.c_territ_016,
    actas.f_entra_016,
    centros.provc_001,
    centros.munic_001
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b13s00 conv
  WHERE actas.id_centro_016 = centros.ccen_001
  AND actas.c_conv_016      = conv.c_conv_013
  AND centros.ccif_001     IN
    (SELECT centros2.ccif_001
    FROM j7301s01 centros2
    WHERE (SELECT COUNT (ncen_001) FROM j7301s01 WHERE ccif_001 = centros2.ccif_001) > 1
    )
  ORDER BY centros.ccif_001,
    centros.ncen_001,
    acta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BESCRUTINIOSPORCONVENIO" ("NREGISTRO", "CODPROVINCIA", "CODMUNICIPIO", "CODCNAE", "NACTA", "NACTACOMPLETA", "TERRIT", "TOTALELECTORES", "CODCONVENIO", "DESCCONVENIO", "DESECONVENIO", "ADMINEMP", "CODCOLEGIO", "CODSINDICATO", "SIGLAS", "NUMDELEGADOS", "VOTOS", "FELEC", "FECHAREGISTRO", "FECHABAJA")
AS
  SELECT consulta.territ
    || '/'
    || consulta.anoreg
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nreg)), 1, '00000'
    || TO_CHAR (consulta.nreg), 2, '0000'
    || TO_CHAR (consulta.nreg), 3, '000'
    || TO_CHAR (consulta.nreg), 4, '00'
    || TO_CHAR (consulta.nreg), 5, '0'
    || TO_CHAR (consulta.nreg), TO_CHAR (consulta.nreg) ),
    consulta.codprovincia,
    consulta.codmunicipio,
    consulta.codcnae,
    consulta.territ
    || '/'
    || consulta.anoacta
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ),
    TO_NUMBER ( consulta.anoacta
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ) ),
    consulta.territ,
    consulta.numtrabajadores,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.adminemp,
    consulta.codcolegio,
    consulta.codsindicato,
    consulta.siglas,
    consulta.delegadosescrutiniosh + consulta.delegadosescrutiniosm,
    consulta.votos,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja
  FROM
    (SELECT actas.totelec_016 AS numtrabajadores,
      centros.provc_001       AS codprovincia,
      centros.munic_001       AS codmunicipio,
      centros.cnae_001        AS codcnae,
      actas.ano_regdef_016    AS anoreg,
      actas.n_regdef_016      AS nreg,
      actas.n_acta_016        AS nacta,
      actas.ano_acta_016      AS anoacta,
      actas.c_territ_016      AS territ,
      actas.version_016       AS ver,
      actas.f_elecc_016       AS fechaeleccion,
      actas.fregdef_016       AS fecharegistro,
      actas.f_baja_016        AS fbaja,
      actas.c_conv_016        AS codconvenio,
      convenios.desc_013      AS descconvenio,
      convenios.dese_013      AS deseconvenio,
      CASE
        WHEN (escrutinios.c_coleg_024 = '0')
        THEN 'T'
        WHEN (escrutinios.c_coleg_024 = '1')
        THEN 'E'
        ELSE ''
      END                     AS codcolegio,
      escrutinios.c_sindi_024 AS codsindicato,
      sindicatos.siglas_019   AS siglas,
      CASE
        WHEN (preavisos.admonemp_037 = 'A')
        THEN 'S'
        WHEN (preavisos.admonemp_037 = 'E')
        THEN 'N'
        ELSE ''
      END                                   AS adminemp,
      COALESCE (escrutinios.n_delh_024, 0 ) AS delegadosescrutiniosh,
      COALESCE (escrutinios.n_delm_024, 0 ) AS delegadosescrutiniosm,
      /*escrutinios.n_votos_024 AS votos,*/
      SUM (papeletas.vota_044) AS votos
    FROM w83b16s00 actas,
      w83b37s00 preavisos,
      j7301s01 centros,
      w83b24s00 escrutinios,
      w83b13s00 convenios,
      w83b19s00 sindicatos,
      w83b44s00 papeletas
    WHERE centros.ccen_001       = actas.id_centro_016
    AND actas.n_acta_016         = escrutinios.n_acta_024
    AND actas.ano_acta_016       = escrutinios.ano_acta_024
    AND actas.c_territ_016       = escrutinios.c_territ_024
    AND actas.version_016        = escrutinios.version_024
    AND escrutinios.n_acta_024   = papeletas.n_acta_044(+)
    AND escrutinios.ano_acta_024 = papeletas.ano_acta_044(+)
    AND escrutinios.c_territ_024 = papeletas.c_territ_044(+)
    AND escrutinios.version_024  = papeletas.version_044(+)
    AND escrutinios.c_coleg_024  = papeletas.c_coleg_044(+)
    AND actas.n_preaviso_016     = preavisos.n_preaviso_037(+)
    AND actas.ano_preaviso_016   = preavisos.ano_preaviso_037(+)
    AND actas.c_territ_016       = preavisos.c_territ_037(+)
    AND escrutinios.c_sindi_024  = sindicatos.c_sindi_019(+)
    AND actas.c_conv_016         = convenios.c_conv_013(+)
    AND actas.n_regdef_016      IS NOT NULL
    AND actas.fregdef_016       IS NOT NULL
    AND actas.n_acttot_016      IS NULL
    AND actas.validada_016       = 1
    GROUP BY actas.totelec_016,
      centros.provc_001,
      centros.munic_001,
      centros.cnae_001,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.c_conv_016,
      convenios.desc_013,
      convenios.dese_013,
      escrutinios.c_coleg_024,
      escrutinios.c_sindi_024,
      sindicatos.siglas_019,
      preavisos.admonemp_037,
      escrutinios.n_votos_024,
      escrutinios.n_delh_024,
      escrutinios.n_delm_024,
      papeletas.vota_044
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 actas
    WHERE consulta.nacta   = actas.n_acta_016
    AND consulta.anoacta   = actas.ano_acta_016
    AND consulta.territ    = c_territ_016
    AND actas.validada_016 = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BESCRUTINIOSPORCONVENIOHIST" ("NREGISTRO", "CODPROVINCIA", "CODMUNICIPIO", "CODCNAE", "NACTA", "ACTA", "ANO", "NACTACOMPLETA", "TERRIT", "TOTALELECTORES", "CODCONVENIO", "DESCCONVENIO", "DESECONVENIO", "ADMINEMP", "CODCOLEGIO", "CODSINDICATO", "SIGLAS", "NUMDELEGADOS", "VOTOS", "FELEC", "FECHAREGISTRO", "FECHABAJA", "FECHAACTU", "VER")
AS
  SELECT consulta.territ
    || '/'
    || consulta.anoreg
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nreg)), 1, '00000'
    || TO_CHAR (consulta.nreg), 2, '0000'
    || TO_CHAR (consulta.nreg), 3, '000'
    || TO_CHAR (consulta.nreg), 4, '00'
    || TO_CHAR (consulta.nreg), 5, '0'
    || TO_CHAR (consulta.nreg), TO_CHAR (consulta.nreg) ),
    consulta.codprovincia,
    consulta.codmunicipio,
    consulta.codcnae,
    consulta.territ
    || '/'
    || consulta.anoacta
    || '/'
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ),
    consulta.acta,
    consulta.ano,
    TO_NUMBER ( consulta.anoacta
    || DECODE (LENGTH (TO_CHAR (consulta.nacta)), 1, '00000'
    || TO_CHAR (consulta.nacta), 2, '0000'
    || TO_CHAR (consulta.nacta), 3, '000'
    || TO_CHAR (consulta.nacta), 4, '00'
    || TO_CHAR (consulta.nacta), 5, '0'
    || TO_CHAR (consulta.nacta), TO_CHAR (consulta.nacta) ) ),
    consulta.territ,
    consulta.numtrabajadores,
    consulta.codconvenio,
    consulta.descconvenio,
    consulta.deseconvenio,
    consulta.adminemp,
    consulta.codcolegio,
    consulta.codsindicato,
    consulta.siglas,
    consulta.delegadosescrutiniosh + consulta.delegadosescrutiniosm,
    consulta.votos,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja,
    consulta.fechaactu,
    consulta.ver
  FROM
    (SELECT actas.totelec_016 AS numtrabajadores,
      centros.provc_001       AS codprovincia,
      centros.munic_001       AS codmunicipio,
      centros.cnae_001        AS codcnae,
      actas.ano_regdef_016    AS anoreg,
      actas.n_regdef_016      AS nreg,
      actas.n_acta_016        AS nacta,
      actas.ano_acta_016      AS ano,
      actas.n_acta_016        AS acta,
      actas.c_territ_016      AS territ,
      actas.version_016       AS ver,
      actas.f_elecc_016       AS fechaeleccion,
      actas.fregdef_016       AS fecharegistro,
      actas.f_baja_016        AS fbaja,
      actas.factu_016         AS fechaactu,
      actas.version_016,
      actas.c_conv_016   AS codconvenio,
      actas.ano_acta_016 AS anoacta,
      convenios.desc_013 AS descconvenio,
      convenios.dese_013 AS deseconvenio,
      CASE
        WHEN (escrutinios.c_coleg_024 = '0')
        THEN 'T'
        WHEN (escrutinios.c_coleg_024 = '1')
        THEN 'E'
        ELSE ''
      END                     AS codcolegio,
      escrutinios.c_sindi_024 AS codsindicato,
      sindicatos.siglas_019   AS siglas,
      CASE
        WHEN (preavisos.admonemp_037 = 'A')
        THEN 'S'
        WHEN (preavisos.admonemp_037 = 'E')
        THEN 'N'
        ELSE ''
      END                                   AS adminemp,
      COALESCE (escrutinios.n_delh_024, 0 ) AS delegadosescrutiniosh,
      COALESCE (escrutinios.n_delm_024, 0 ) AS delegadosescrutiniosm,
      SUM (papeletas.vota_044)              AS votos
    FROM w83b16s00 actas,
      w83b37s00 preavisos,
      j7301s01 centros,
      w83b24s00 escrutinios,
      w83b13s00 convenios,
      w83b19s00 sindicatos,
      w83b44s00 papeletas
    WHERE centros.ccen_001       = actas.id_centro_016
    AND actas.n_acta_016         = escrutinios.n_acta_024
    AND actas.ano_acta_016       = escrutinios.ano_acta_024
    AND actas.c_territ_016       = escrutinios.c_territ_024
    AND actas.version_016        = escrutinios.version_024
    AND escrutinios.n_acta_024   = papeletas.n_acta_044(+)
    AND escrutinios.ano_acta_024 = papeletas.ano_acta_044(+)
    AND escrutinios.c_territ_024 = papeletas.c_territ_044(+)
    AND escrutinios.version_024  = papeletas.version_044(+)
    AND escrutinios.c_coleg_024  = papeletas.c_coleg_044(+)
    AND actas.n_preaviso_016     = preavisos.n_preaviso_037(+)
    AND actas.ano_preaviso_016   = preavisos.ano_preaviso_037(+)
    AND actas.c_territ_016       = preavisos.c_territ_037(+)
    AND escrutinios.c_sindi_024  = sindicatos.c_sindi_019(+)
    AND actas.c_conv_016         = convenios.c_conv_013(+)
    AND actas.n_regdef_016      IS NOT NULL
    AND actas.fregdef_016       IS NOT NULL
    AND actas.n_acttot_016      IS NULL
    AND actas.validada_016       = 1
    GROUP BY actas.totelec_016,
      centros.provc_001,
      centros.munic_001,
      centros.cnae_001,
      actas.ano_regdef_016,
      actas.n_regdef_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      actas.factu_016,
      actas.c_conv_016,
      convenios.desc_013,
      convenios.dese_013,
      escrutinios.c_coleg_024,
      escrutinios.c_sindi_024,
      sindicatos.siglas_019,
      preavisos.admonemp_037,
      escrutinios.n_votos_024,
      escrutinios.n_delh_024,
      escrutinios.n_delm_024,
      papeletas.vota_044
    ) consulta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BHIST_TRAMITACION_ACTAS" ("COD_TERRITORIO", "ANO_ACTA", "NUMACTA", "VERSIONACTA", "COD_FASE", "COD_TRAMITE", "DESC_TRAMITE", "DESE_TRAMITE", "F_ACTU_TRAMITE", "USU_ALTA", "FECHA_ALTA_TRAMITE", "USU_MOD", "FECHA_MOD", "FECHA_REG_SALIDA", "NUM_REG_SALID", "DESC_FASE", "DESE_FASE")
AS
  SELECT t58.c_territ_058,
    t58.ano_acta_058,
    t58.n_acta_058,
    t58.version_058,
    t58.c_fase_058,
    t58.c_tram_058,
    t12.desc_012,
    t12.dese_012,
    t58.f_actu_058,
    t58.usua_058,
    t58.f_tram_058,
    t58.usu_mod_058,
    t58.f_modif_058,
    t58.f_reg_sal_058,
    t58.n_reg_sal_058,
    t52.desc_052,
    t52.dese_052
  FROM w83b12t00 t12,
    w83b58t00 t58,
    w83b52t00 t52
  WHERE t12.c_fase_012 = t58.c_fase_058
  AND t12.c_tram_012   = t58.c_tram_058
  AND t12.c_fase_012   = t52.c_fase_052;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BHIST_TRAMITACION_IMPUG" ("C_TERRIT", "ANO_IMPUG", "N_IMPUG", "COD_FASE", "COD_TRAMITE", "DESC_FASE", "DESE_FASE", "DESC_TRAMITE", "DESE_TRAMITE", "F_ACTU_TRAMITE", "USU_ALTA", "FECHA_ALTA_TRAMITE", "USU_MOD", "FECHA_MOD", "FECHA_REG_SALIDA", "NUM_REG_SALID")
AS
  SELECT t71.c_territ_071,
    t71.ano_impug_071,
    t71.n_impug_071,
    t71.c_fase_071,
    t71.c_tram_071,
    t52.desc_052,
    t52.dese_052,
    t12.desc_012,
    t12.dese_012,
    t71.f_actu_071,
    t71.usua_071,
    t71.f_tram_071,
    t71.usu_mod_071,
    t71.f_modif_071,
    t71.f_reg_sal_071,
    t71.n_reg_sal_071
  FROM w83b12t00 t12,
    w83b71t00 t71,
    w83b52t00 t52
  WHERE t12.c_fase_012 = t71.c_fase_071
  AND t12.c_tram_012   = t71.c_tram_071
  AND t52.c_fase_052   = t71.c_fase_071;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BHIST_TRAMITACION_INCID" ("COD_TERRITORIO", "ANO_INCIDENCIA", "NUMINCIDENCIA", "COD_FASE", "DESC_FASE", "DESE_FASE", "COD_TRAMITE", "DESC_TRAMITE", "DESE_TRAMITE", "F_ACTU_TRAMITE", "USU_ALTA", "USU_MOD", "FECHA_MOD", "FECHA_REG_SALIDA", "NUM_REG_SALID", "FECHA_ALTA_TRAMITE")
AS
  SELECT t72.c_territ_072,
    t72.ano_incid_072,
    t72.n_incid_072,
    t72.c_fase_072,
    t52.desc_052,
    t52.dese_052,
    t12.c_tram_012,
    t12.desc_012,
    t12.dese_012,
    t72.f_actu_072,
    t72.usua_072,
    t72.usu_mod_072,
    t72.f_modif_072,
    t72.f_reg_sal_072,
    t72.n_reg_sal_072,
    t72.f_tram_072
  FROM w83b72s00 t72,
    w83b12s00 t12,
    w83b52s00 t52
  WHERE t72.c_fase_072 = t52.c_fase_052
  AND t12.c_fase_012   = t72.c_fase_072
  AND t12.c_tram_012   = t72.c_tram_072;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BHIST_TRAMITACION_PREAVISOS" ("COD_TERRITORIO", "ANO_PREAVISO", "NUMPREAVISO", "COD_FASE", "DESC_FASE", "DESE_FASE", "COD_TRAMITE", "DESC_TRAMITE", "DESE_TRAMITE", "F_ACTU_TRAMITE", "USU_ALTA", "FECHA_ALTA_TRAMITE", "USU_MOD", "FECHA_MOD", "FECHA_REG_SALIDA", "NUM_REG_SALID")
AS
  SELECT t56.c_territ_056,
    t56.ano_preaviso_056,
    t56.n_preaviso_056,
    t56.c_fase_056,
    t52.desc_052,
    t52.dese_052,
    t56.c_tram_056,
    t12.desc_012,
    t12.dese_012,
    t56.f_actu_056,
    t56.usua_056,
    t56.f_tram_056,
    t56.usu_mod_056,
    t56.f_modif_056,
    t56.f_reg_sal_056,
    t56.n_reg_sal_056
  FROM w83b12t00 t12,
    w83b56t00 t56,
    w83b52t00 t52
  WHERE t12.c_fase_012 = t56.c_fase_056
  AND t52.c_fase_052   = t56.c_fase_056
  AND t12.c_tram_012   = t56.c_tram_056;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BIMPUGNACIONES" ("C_TERRIT_NORA", "ANO_PREAVISO_037", "N_PREAVISO_037", "NUM_IMPUGNACION", "NUM_IMPUGNACION_COMPLETO", "FECH_IMPUGNACION", "DESC_SINDICATOS", "DESE_SINDICATOS", "DNI_ARBITRO", "NOMBRE_ARBITRO", "NUM_LAUDO", "NUM_LAUDOCOMPLETO", "NUM_LAUDOCOMPLETOINT", "FECH_LAUDO", "FECH_ENVIO_JUZGADO", "FECH_SENTENCIA", "FECH_BAJA_DESESTIMIENTO", "RESULTADO", "TIPO", "DESC_TIPO", "DESE_TIPO", "NOMBREIMPUGNANTE", "RDTO_CAS", "RDTO_EUS")
AS
  SELECT t33.c_territ_033,
    t33.ano_preaviso_033,
    t33.n_preaviso_033,
    t33.n_impug_033,
    TO_CHAR ( t33.c_territ_033
    || '/'
    || t33.ano_impug_033
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t33.n_impug_033)), 1, '00000'
    || TO_CHAR (t33.n_impug_033), 2, '0000'
    || TO_CHAR (t33.n_impug_033), 3, '000'
    || TO_CHAR (t33.n_impug_033), 4, '00'
    || TO_CHAR (t33.n_impug_033), 5, '0'
    || TO_CHAR (t33.n_impug_033), TO_CHAR (t33.n_impug_033) ) ) ),
    t33.f_impug_033,
    stragg (t19.desc_019),
    stragg (t19.dese_019),
    t33.dni_033,
    t36.nombre_036,
    t68.n_laudo_068,
    DECODE (TO_CHAR ( t68.c_territ_068
    || '/'
    || t68.ano_laudo_068
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ), '//', '', TO_CHAR ( t68.c_territ_068
    || '/'
    || t68.ano_laudo_068
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ) ),
    TO_NUMBER ( t68.c_territ_068
    || t68.ano_laudo_068
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ),
    t68.flaudo_068,
    t33.fenvjuz_033,
    t33.f_senten_033,
    t33.fdeses_033,
    t68.rdo_laudo_068,
    t33.c_impug_033,
    t30.desc_030,
    t30.dese_030,
    t76.nombre_imp_076,
    t75.desc_rdo_cas_075,
    t75.desc_rdo_eus_075
  FROM w83b36t00 t36,
    w83b35t00 t35,
    w83b19t00 t19,
    w83b33t00 t33,
    w83b68t00 t68,
    w83b30t00 t30,
    w83b76t00 t76,
    w83b75t00 t75
  WHERE t36.dni_036(+)     = t33.dni_033
  AND t36.c_territ_036(+)  = t33.c_territ_033
  AND t35.c_sindi_035      = t19.c_sindi_019(+)
  AND t35.c_territ_035(+)  = t33.c_territ_033
  AND t35.ano_impug_035(+) = t33.ano_impug_033
  AND t35.n_impug_035(+)   = t33.n_impug_033
  AND t76.c_territ_076(+)  = t33.c_territ_033
  AND t76.ano_impug_076(+) = t33.ano_impug_033
  AND t76.n_impug_076(+)   = t33.n_impug_033
  AND t68.c_territ_068(+)  = t33.c_territ_033
  AND t68.ano_impug_068(+) = t33.ano_impug_033
  AND t68.n_impug_068(+)   = t33.n_impug_033
  AND t30.c_impug_030      = t33.c_impug_033
  AND t75.id_rdo_075(+)    = t68.rdo_laudo_068
  GROUP BY t33.c_territ_033,
    t33.ano_preaviso_033,
    t33.n_preaviso_033,
    t33.n_impug_033,
    TO_CHAR ( t33.c_territ_033
    || '/'
    || t33.ano_impug_033
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t33.n_impug_033)), 1, '00000'
    || TO_CHAR (t33.n_impug_033), 2, '0000'
    || TO_CHAR (t33.n_impug_033), 3, '000'
    || TO_CHAR (t33.n_impug_033), 4, '00'
    || TO_CHAR (t33.n_impug_033), 5, '0'
    || TO_CHAR (t33.n_impug_033), TO_CHAR (t33.n_impug_033) ) ) ),
    t33.f_impug_033,
    t33.dni_033,
    t36.nombre_036,
    t68.n_laudo_068,
    DECODE (TO_CHAR ( t68.c_territ_068
    || '/'
    || t68.ano_laudo_068
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ), '//', '', TO_CHAR ( t68.c_territ_068
    || '/'
    || t68.ano_laudo_068
    || '/'
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ) ),
    TO_NUMBER ( t68.c_territ_068
    || t68.ano_laudo_068
    || TO_CHAR (DECODE (LENGTH (TO_CHAR (t68.n_laudo_068)), 1, '00000'
    || TO_CHAR (t68.n_laudo_068), 2, '0000'
    || TO_CHAR (t68.n_laudo_068), 3, '000'
    || TO_CHAR (t68.n_laudo_068), 4, '00'
    || TO_CHAR (t68.n_laudo_068), 5, '0'
    || TO_CHAR (t68.n_laudo_068), TO_CHAR (t68.n_laudo_068) ) ) ),
    t68.flaudo_068,
    t33.fenvjuz_033,
    t33.f_senten_033,
    t33.fdeses_033,
    t68.rdo_laudo_068,
    t33.c_impug_033,
    t30.desc_030,
    t30.dese_030,
    t76.nombre_imp_076,
    t33.c_impug_033,
    t75.desc_rdo_cas_075,
    t75.desc_rdo_eus_075;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BLIBROREGISTROACTAS" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NPRE", "ANOPREAVISO", "CIF", "CODIGOCENTRO", "RAZON", "DOMICILIO", "CONVENIO", "CONVENIOEU", "NUMELECTORES", "NUMREPRESENTANTES", "NUMACTAINT", "PROVINCIA", "MUNICIPIO")
AS
  SELECT consulta.ver,
    consulta.fechaentrada,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.numpreaviso,
    consulta.anopreaviso,
    consulta.cif,
    consulta.codcentro,
    consulta.razon,
    consulta.domicilio,
    consulta.convenio,
    consulta.convenioeu,
    consulta.numelectores,
    COUNT (consulta.numrepresentantes),
    consulta.numaactaint,
    consulta.provincia,
    consulta.municipio
  FROM
    (SELECT actas.version_016 AS ver,
      actas.f_entra_016       AS fechaentrada,
      actas.n_acta_016        AS nacta,
      actas.ano_acta_016      AS anoacta,
      actas.c_territ_016      AS territ,
      actas.n_preaviso_016    AS numpreaviso,
      actas.ano_preaviso_016  AS anopreaviso,
      centros.ccif_001        AS cif,
      centros.ncen_001        AS codcentro,
      centros.rsoc_001        AS razon,
      centros.domic_001       AS domicilio,
      convenios.desc_013      AS convenio,
      convenios.dese_013      AS convenioeu,
      totelec_016             AS numelectores,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint,
      delegados.dni_025                                             AS numrepresentantes,
      centros.provc_001                                             AS provincia,
      centros.munic_001                                             AS municipio
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b13s00 convenios,
      w83b25s00 delegados
    WHERE centros.ccen_001      = actas.id_centro_016
    AND actas.validada_016      = 1
    AND actas.c_conv_016        = convenios.c_conv_013(+)
    AND actas.n_acta_016        = delegados.n_acta_025(+)
    AND actas.ano_acta_016      = delegados.ano_acta_025(+)
    AND actas.c_territ_016      = delegados.c_territ_025(+)
    AND actas.version_016       = delegados.version_025(+)
    AND delegados.cbaja_025(+) IS NULL
    AND actas.f_baja_016       IS NULL
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND validada_016     = 1
    AND act.f_baja_016  IS NULL
    )
  GROUP BY consulta.ver,
    consulta.fechaentrada,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.numpreaviso,
    consulta.anopreaviso,
    consulta.cif,
    consulta.codcentro,
    consulta.razon,
    consulta.domicilio,
    consulta.convenio,
    consulta.convenioeu,
    consulta.numelectores,
    consulta.numaactaint,
    consulta.provincia,
    consulta.municipio
  ORDER BY consulta.fechaentrada,
    consulta.numaactaint;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BLIBROREGISTROPREAVISOS" ("FECHAENTRADA", "NUMPREAVISO", "NUMPREAVISOINT", "NUMENTRADA", "CIF", "CODIGOCENTRO", "RAZON", "FECHAINICIO", "MUNICIPIO", "PREAVISOGLOBAL", "OBSERVACIONES", "TERRIT", "ANYOPREAVISO", "NPRE", "PROMOTORES", "PROMOTORESEU")
AS
  SELECT preavisos.f_entra_037,
    preavisos.c_territ_037
    || '/'
    || preavisos.ano_preaviso_037
    || '/'
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) AS numpreaviso,
    TO_NUMBER ( preavisos.c_territ_037
    || preavisos.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) ) AS numpreavisoint,
    preavisos.n_regis_037,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    preavisos.f_inicio_037,
    municipios.ds_o,
    preavisos.global_037,
    preavisos.observ_037,
    preavisos.c_territ_037,
    preavisos.ano_preaviso_037,
    preavisos.n_preaviso_037,
    stragg (sind.desc_019),
    stragg (sind.dese_019)
  FROM j7301s01 centros,
    w83b37s00 preavisos,
    t17i.t17_municipio municipios,
    w83b27s00 preav_sin,
    w83b19s00 sind
  WHERE centros.ccen_001         = preavisos.id_centro_037
  AND centros.munic_001          = municipios.ID
  AND centros.provc_001          = municipios.provincia_id
  AND preavisos.n_preaviso_037   = preav_sin.n_preaviso_027(+)
  AND preavisos.ano_preaviso_037 = preav_sin.ano_preaviso_027(+)
  AND preavisos.c_territ_037     = preav_sin.c_territ_027(+)
  AND preav_sin.c_sindi_027      = sind.c_sindi_019(+)
  GROUP BY preavisos.f_entra_037,
    preavisos.n_regis_037,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    preavisos.f_inicio_037,
    municipios.ds_o,
    preavisos.global_037,
    preavisos.observ_037,
    preavisos.c_territ_037,
    preavisos.ano_preaviso_037,
    preavisos.n_preaviso_037
  ORDER BY preavisos.f_entra_037,
    centros.ccif_001,
    numpreavisoint;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BLISTIMPUGRELACIONADAS" ("N_ACTA", "AGNO_ACTA", "C_TERRIT", "VER", "FECHAENTRADA", "OBSERVACIONES", "CODCENTRO", "CODIGOCENTRO", "RAZONSOCIAL", "DOMICILIOCENTRO", "N_IMPUG", "AGNO_IMPUG", "F_IMPUG", "FECHABAJA", "RESULTADOLAUDOS", "ORDERBY")
                           AS
  SELECT tactas.n_acta_016 AS n_acta,
    tactas.ano_acta_016    AS agno_acta,
    tactas.c_territ_016    AS c_territ,
    tactas.version_016     AS ver,
    f_entra_016            AS fechaentrada,
    tactas.observ_016      AS observaciones,
    tactas.id_centro_016   AS codcentro,
    tcentros.ccen_001      AS codigocentro,
    tcentros.rsoc_001      AS razonsocial,
    tcentros.domic_001     AS domiciliocentro,
    timpug.n_impug_033     AS n_impug,
    timpug.ano_impug_033   AS agno_impug,
    timpug.f_impug_033     AS f_impug,
    f_baja_016             AS fechabaja,
    laudos.rdo_laudo_068   AS resultadolaudos,
    1                      AS orderby
  FROM w83b16s00 tactas,
    j7301s01 tcentros,
    w83b33t00 timpug,
    w83b68t00 laudos
  WHERE tactas.id_centro_016 = tcentros.ccen_001
  AND tactas.n_acta_016      = timpug.n_acta_033
  AND tactas.ano_acta_016    = timpug.ano_acta_033
  AND tactas.c_territ_016    = timpug.c_territ_033
  AND tactas.version_016     = timpug.version_033
  AND timpug.n_impug_033     = laudos.n_impug_068(+)
  AND timpug.ano_impug_033   = laudos.ano_impug_068(+)
  AND timpug.c_territ_033    = laudos.c_territ_068(+)
  AND timpug.fdeses_033     IS NULL
  UNION ALL
  SELECT tpreav.n_preaviso_037 AS n_acta,
    tpreav.ano_preaviso_037    AS agno_acta,
    tpreav.c_territ_037        AS c_territ,
    0                          AS ver,
    f_entra_037                AS fechaentrada,
    tpreav.observ_037          AS observaciones,
    tpreav.id_centro_037       AS codcentro,
    tcentros.ccen_001          AS codigocentro,
    tcentros.rsoc_001          AS razonsocial,
    tcentros.domic_001         AS domiciliocentro,
    timpug.n_impug_033         AS n_impug_033,
    timpug.ano_impug_033       AS agno_impug,
    timpug.f_impug_033         AS f_impug,
    NULL                       AS fechabaja,
    laudos.rdo_laudo_068       AS resultadolaudos,
    2                          AS orderby
  FROM w83b37s00 tpreav,
    j7301s01 tcentros,
    w83b33t00 timpug,
    w83b68t00 laudos
  WHERE tpreav.id_centro_037  = tcentros.ccen_001
  AND tpreav.n_preaviso_037   = timpug.n_preaviso_033
  AND tpreav.ano_preaviso_037 = timpug.ano_preaviso_033
  AND tpreav.c_territ_037     = timpug.c_territ_033
  AND timpug.n_impug_033      = laudos.n_impug_068(+)
  AND timpug.ano_impug_033    = laudos.ano_impug_068(+)
  AND timpug.c_territ_033     = laudos.c_territ_068(+)
  AND timpug.fdeses_033      IS NULL
  ORDER BY orderby,
    agno_impug,
    n_impug;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BMANTENIMIENTODELEGADOS" ("N_ACTA_016", "ANO_ACTA_016", "C_TERRIT_016", "VERSION_016", "ID_CENTRO_016", "F_BAJA_016", "DNI_025", "NOMBRE_025", "APEL1_025", "APEL2_025", "F_BAJA_025", "C_SINDI_025", "NUM_ACTA_COMP", "CODTERRITORIO", "CODMUNICIPIO", "TERRITORIO", "MUNICIPIO", "RAZONSOCIAL", "TELEFONO", "CIFNIF", "DOMICILIO", "FAX")
AS
  SELECT n_acta_016,
    ano_acta_016,
    c_territ_016,
    version_016,
    id_centro_016,
    f_baja_016,
    dni_025,
    nombre_025,
    apel1_025,
    apel2_025,
    f_baja_025,
    c_sindi_025,
    numactacom,
    codterritorio,
    codmunicipio,
    territorio,
    municipio,
    razonsocial,
    telefono,
    cifnif,
    domicilio,
    fax
  FROM
    (SELECT tactas.n_acta_016 AS n_acta_016,
      tactas.ano_acta_016     AS ano_acta_016,
      tactas.c_territ_016     AS c_territ_016,
      tactas.version_016      AS version_016,
      tactas.id_centro_016    AS id_centro_016,
      tactas.f_baja_016       AS f_baja_016,
      tdelegado.dni_025       AS dni_025,
      tdelegado.nombre_025    AS nombre_025,
      tdelegado.apel1_025     AS apel1_025,
      tdelegado.apel2_025     AS apel2_025,
      tdelegado.f_baja_025    AS f_baja_025,
      tdelegado.c_sindi_025   AS c_sindi_025,
      tactas.c_territ_016
      || '/'
      || tactas.ano_acta_016
      || '/'
      || DECODE (LENGTH (TO_CHAR (tactas.n_acta_016)), 1, '00000'
      || TO_CHAR (tactas.n_acta_016), 2, '0000'
      || TO_CHAR (tactas.n_acta_016), 3, '000'
      || TO_CHAR (tactas.n_acta_016), 4, '00'
      || TO_CHAR (tactas.n_acta_016), 5, '0'
      || TO_CHAR (tactas.n_acta_016), TO_CHAR (tactas.n_acta_016) ) AS numactacom,
      (SELECT tprovincia.ds_o
      FROM t17i.t17_provincia tprovincia
      WHERE tprovincia.ID = centros.provc_001
      )                 AS territorio,
      centros.provc_001 AS codterritorio,
      (SELECT ds_o
      FROM t17i.t17_municipio tmunicipio
      WHERE tmunicipio.ID         = centros.MUNIC_001
      AND tmunicipio.PROVINCIA_ID = centros.provc_001
      )                 AS municipio,
      centros.munic_001 AS codmunicipio,
      centros.rsoc_001  AS razonsocial,
      centros.tlf_001   AS telefono,
      centros.ccif_001  AS cifnif,
      centros.domic_001 AS domicilio,
      centros.fax_001   AS fax
    FROM w83b16t00 tactas,
      w83b25t00 tdelegado,
      j7301s01 centros
    WHERE tactas.n_acta_016  = tdelegado.n_acta_025
    AND tactas.ano_acta_016  = tdelegado.ano_acta_025
    AND tactas.c_territ_016  = tdelegado.c_territ_025
    AND tactas.version_016   = tdelegado.version_025
    AND tactas.id_centro_016 = centros.ccen_001
    AND tactas.validada_016  = 1
    ) consulta
  WHERE consulta.version_016 =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.n_acta_016 = act.n_acta_016
    AND consulta.ano_acta_016 = act.ano_acta_016
    AND consulta.c_territ_016 = c_territ_016
    AND act.validada_016      = 1
    )
  ORDER BY consulta.c_territ_016,
    consulta.ano_acta_016,
    consulta.n_acta_016,
    consulta.version_016;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BOFICIOREQUE" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NUMPREAVISO", "ANOPREAVISO", "CIF", "CODIGOCENTRO", "NUMCENTRO", "RAZON", "DOMICILIO", "MUNICIPIO", "PROVINCIA", "CODIGOPOSTAL", "NUMACTAINT", "DESCSINDICATO", "DIRORIG", "CPORIG", "MUNORIG", "PROVORIG")
                           AS
  SELECT actas.version_016 AS ver,
    actas.f_entra_016      AS fechaentrada,
    actas.n_acta_016       AS nacta,
    actas.ano_acta_016     AS anoacta,
    actas.c_territ_016     AS territ,
    actas.n_preaviso_016   AS numpreaviso,
    actas.ano_preaviso_016 AS anopreaviso,
    centros.ccif_001       AS cif,
    centros.ccen_001       AS codcentro,
    centros.ncen_001       AS numerocentro,
    centros.rsoc_001       AS razon,
    centros.domic_001      AS domicilio,
    centros.munic_001      AS municipio,
    centros.provc_001      AS provincia,
    centros.cposc_001      AS codigopostal,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint,
    stragg_int ( sindicatos.c_sindi_019
    || '|'
    || sindicatos.desc_019
    || '|'
    || sindicatos.dese_019 ) AS descsindicato,
    preavisos.dir_alt_037    AS dirorig,
    preavisos.codpos_alt_037 AS cporig,
    preavisos.mun_alt_037    AS munorig,
    preavisos.prov_alt_037   AS provorig
  FROM w83b16s00 actas,
    w83b24s00 escrutinios,
    j7301s01 centros,
    w83b19s00 sindicatos,
    w83b37s00 preavisos
  WHERE actas.n_acta_016      = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016      = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016      = escrutinios.c_territ_024(+)
  AND actas.version_016       = escrutinios.version_024(+)
  AND actas.id_centro_016     = centros.ccen_001(+)
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
  AND actas.n_preaviso_016    = preavisos.n_preaviso_037(+)
  AND actas.ano_preaviso_016  = preavisos.ano_preaviso_037(+)
  AND actas.c_territ_016      = preavisos.c_territ_037(+)
  AND actas.f_reque_016      IS NULL
  AND actas.version_016       = 0
  AND actas.validada_016      = 1
  AND actas.f_baja_016       IS NULL
  GROUP BY actas.version_016,
    actas.f_entra_016,
    actas.n_acta_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.n_preaviso_016,
    actas.ano_preaviso_016,
    centros.ccif_001,
    centros.ccen_001,
    centros.ncen_001,
    centros.rsoc_001,
    centros.domic_001,
    centros.munic_001,
    centros.provc_001,
    centros.cposc_001,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ),
    preavisos.dir_alt_037,
    preavisos.codpos_alt_037,
    preavisos.mun_alt_037,
    preavisos.prov_alt_037
  ORDER BY numaactaint;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRELACIMPUGNACIONES" ("NIMPUG", "AGNOIMPUG", "TERRITORIO", "FECHAIMPUG", "NACTA", "AGNOACTA", "VER", "NPREAVISO", "AGNOPREAVISO", "CENTROACTA", "CENTROPREAVISO", "RAZON", "DOMICILIO", "OBSERVACTA", "OBSERVPREAVISO")
AS
  SELECT consulta.nimpug,
    consulta.agnoimpug,
    consulta.territorio,
    consulta.fechaimpug,
    consulta.nacta,
    consulta.agnoacta,
    consulta.ver,
    consulta.npreaviso,
    consulta.agnopreaviso,
    consulta.centroacta,
    consulta.centropreaviso,
    consulta.razon,
    consulta.domicilio,
    consulta.observacta,
    consulta.observpreaviso
  FROM
    (SELECT impug.n_impug_033    AS nimpug,
      impug.ano_impug_033        AS agnoimpug,
      impug.c_territ_033         AS territorio,
      impug.f_impug_033          AS fechaimpug,
      impug.n_acta_033           AS nactaimpug,
      impug.ano_acta_033         AS aactaimpug,
      impug.n_preaviso_033       AS npreaimpug,
      impug.ano_preaviso_033     AS apreaimpug,
      actas.n_acta_016           AS nacta,
      actas.ano_acta_016         AS agnoacta,
      actas.version_016          AS ver,
      actas.c_territ_016         AS territacta,
      actas.id_centro_016        AS centroacta,
      actas.observ_016           AS observacta,
      preavisos.n_preaviso_037   AS npreaviso,
      preavisos.ano_preaviso_037 AS agnopreaviso,
      preavisos.c_territ_037     AS territpreaviso,
      preavisos.id_centro_037    AS centropreaviso,
      preavisos.observ_037       AS observpreaviso,
      centros.ccen_001           AS codcentro,
      centros.rsoc_001           AS razon,
      centros.domic_001          AS domicilio
    FROM w83b33t00 impug,
      w83b16t00 actas,
      w83b37t00 preavisos,
      j7301s01 centros
    WHERE impug.n_acta_033     = actas.n_acta_016
    AND impug.ano_acta_033     = actas.ano_acta_016
    AND impug.c_territ_033     = actas.c_territ_016
    AND impug.n_preaviso_033   = preavisos.n_preaviso_037
    AND impug.ano_preaviso_033 = preavisos.ano_preaviso_037
    AND impug.c_territ_033     = preavisos.c_territ_037
    ) consulta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRELACIONALFABPREAVISOS" ("RAZON", "FECHAENTRADA", "NUMPREAVISO", "NUMPREAVISOINT", "FECHAINICIO", "CIF", "CODIGOCENTRO", "MUNICIPIO", "PREAVISOGLOBAL", "OBSERVACIONES", "PROMOTORES", "PROMOTORESEU", "TERRIT")
AS
  SELECT centros.rsoc_001,
    preavisos.f_entra_037,
    preavisos.c_territ_037
    || '/'
    || preavisos.ano_preaviso_037
    || '/'
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) AS numpreaviso,
    TO_NUMBER ( preavisos.c_territ_037
    || preavisos.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) ) AS numpreavisoint,
    preavisos.f_inicio_037,
    centros.ccif_001,
    centros.ncen_001,
    municipios.ds_o,
    preavisos.global_037,
    preavisos.observ_037,
    stragg (sind.desc_019),
    stragg (sind.dese_019),
    preavisos.c_territ_037
  FROM j7301s01 centros,
    w83b37s00 preavisos,
    t17i.t17_municipio municipios,
    w83b27s00 preav_sin,
    w83b19s00 sind
  WHERE centros.ccen_001         = preavisos.id_centro_037
  AND centros.munic_001          = municipios.ID
  AND centros.provc_001          = municipios.provincia_id
  AND preavisos.n_preaviso_037   = preav_sin.n_preaviso_027(+)
  AND preavisos.ano_preaviso_037 = preav_sin.ano_preaviso_027(+)
  AND preavisos.c_territ_037     = preav_sin.c_territ_027(+)
  AND preav_sin.c_sindi_027      = sind.c_sindi_019(+)
  GROUP BY centros.rsoc_001,
    preavisos.f_entra_037,
    preavisos.c_territ_037
    || '/'
    || preavisos.ano_preaviso_037
    || '/'
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ),
    TO_NUMBER ( preavisos.c_territ_037
    || preavisos.ano_preaviso_037
    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)), 1, '00000'
    || TO_CHAR (preavisos.n_preaviso_037), 2, '0000'
    || TO_CHAR (preavisos.n_preaviso_037), 3, '000'
    || TO_CHAR (preavisos.n_preaviso_037), 4, '00'
    || TO_CHAR (preavisos.n_preaviso_037), 5, '0'
    || TO_CHAR (preavisos.n_preaviso_037), TO_CHAR (preavisos.n_preaviso_037) ) ),
    preavisos.f_inicio_037,
    centros.ccif_001,
    centros.ncen_001,
    municipios.ds_o,
    preavisos.global_037,
    preavisos.observ_037,
    preavisos.c_territ_037
  ORDER BY centros.rsoc_001,
    numpreavisoint;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BREPRESENTCANDTAMEMPR" ("NUMTRABAJADORES", "CODPROVINCIA", "CODMUNICIPIO", "CODSINDICATO", "SIGLAS", "NACTA", "ANOACTA", "TERRIT", "VER", "FELEC", "FECHAREGISTRO", "FECHABAJA", "NUMDELEGADOS")
                           AS
  SELECT actas.totelec_016 AS numtrabajadores,
    DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
    || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ) AS codprovincia,
    DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
    || TO_CHAR (centros.munic_001), 2, '0'
    || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ) AS codmunicipio,
    sindicatos.c_sindi_019                                        AS codsindicato,
    sindicatos.siglas_019                                         AS siglas,
    actas.n_acta_016                                              AS nacta,
    actas.ano_acta_016                                            AS anoacta,
    actas.c_territ_016                                            AS territ,
    actas.version_016                                             AS ver,
    actas.f_elecc_016                                             AS fechaeleccion,
    actas.fregdef_016                                             AS fecharegistro,
    actas.f_baja_016                                              AS fbaja,
    SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 )        AS numdelegados
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b19s00 sindicatos,
    w83b24s00 escrutinios
  WHERE centros.ccen_001      = actas.id_centro_016
  AND actas.n_acta_016        = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016      = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016      = escrutinios.c_territ_024(+)
  AND actas.version_016       = escrutinios.version_024(+)
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.n_regdef_016     IS NOT NULL
  AND actas.version_016       =
    (SELECT MAX (act.version_016)
    FROM w83b16s00 act
    WHERE actas.n_acta_016 = act.n_acta_016
    AND actas.ano_acta_016 = act.ano_acta_016
    AND actas.c_territ_016 = act.c_territ_016
    AND act.validada_016   = 1
    )
  GROUP BY actas.totelec_016,
    DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
    || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ),
    DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
    || TO_CHAR (centros.munic_001), 2, '0'
    || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ),
    sindicatos.c_sindi_019,
    sindicatos.siglas_019,
    actas.n_acta_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.version_016,
    actas.f_elecc_016,
    actas.fregdef_016,
    actas.f_baja_016;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BREPRESENTCANDTAMEMPRHIST" ("NUMTRABAJADORES", "CODPROVINCIA", "CODMUNICIPIO", "CODSINDICATO", "SIGLAS", "NACTA", "ANOACTA", "TERRIT", "VER", "FELEC", "FECHAREGISTRO", "FECHABAJA", "NUMDELEGADOS", "FECHAACTU")
                           AS
  SELECT actas.totelec_016 AS numtrabajadores,
    DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
    || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ) AS codprovincia,
    DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
    || TO_CHAR (centros.munic_001), 2, '0'
    || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ) AS codmunicipio,
    sindicatos.c_sindi_019                                        AS codsindicato,
    sindicatos.siglas_019                                         AS siglas,
    actas.n_acta_016                                              AS nacta,
    actas.ano_acta_016                                            AS anoacta,
    actas.c_territ_016                                            AS territ,
    actas.version_016                                             AS ver,
    actas.f_elecc_016                                             AS fechaeleccion,
    actas.fregdef_016                                             AS fecharegistro,
    actas.f_baja_016                                              AS fbaja,
    SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024 )        AS numdelegados,
    actas.factu_016                                               AS fechaactu
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b19s00 sindicatos,
    w83b24s00 escrutinios
  WHERE centros.ccen_001      = actas.id_centro_016
  AND actas.n_acta_016        = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016      = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016      = escrutinios.c_territ_024(+)
  AND actas.version_016       = escrutinios.version_024(+)
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.n_regdef_016     IS NOT NULL
  GROUP BY actas.totelec_016,
    DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
    || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ),
    DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
    || TO_CHAR (centros.munic_001), 2, '0'
    || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ),
    sindicatos.c_sindi_019,
    sindicatos.siglas_019,
    actas.n_acta_016,
    actas.ano_acta_016,
    actas.c_territ_016,
    actas.version_016,
    actas.f_elecc_016,
    actas.fregdef_016,
    actas.f_baja_016,
    actas.factu_016,
    actas.version_016
    /* WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ = c_territ_016
    AND act.validada_016 = 1);*/
    ;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BREPRESENTCANDTAMEMPRNUEVA" ("CODPROVINCIA", "CODMUNICIPIO", "CODSINDICATO", "SIGLAS", "NUMTRABAJADORES", "TERRIT", "FELEC", "FECHAREGISTRO", "NUMDELEGADOS")
AS
  SELECT consulta.codprovincia,
    consulta.codmunicipio,
    consulta.codsindicato,
    consulta.siglas,
    consulta.numtrabajadores,
    consulta.territ,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.delegadosescrutiniosh + consulta.delegadosescrutiniosm + consulta.delegadosdiferenciash + consulta.delegadosdiferenciasm
  FROM
    (SELECT actas.totelec_016 AS numtrabajadores,
      DECODE (LENGTH (TO_CHAR (centros.provc_001)), 1, '0'
      || TO_CHAR (centros.provc_001), TO_CHAR (centros.provc_001) ) AS codprovincia,
      DECODE (LENGTH (TO_CHAR (centros.munic_001)), 1, '00'
      || TO_CHAR (centros.munic_001), 2, '0'
      || TO_CHAR (centros.munic_001), TO_CHAR (centros.munic_001) ) AS codmunicipio,
      sindicatos.c_sindi_019                                        AS codsindicato,
      sindicatos.siglas_019                                         AS siglas,
      actas.n_acta_016                                              AS nacta,
      actas.ano_acta_016                                            AS anoacta,
      actas.c_territ_016                                            AS territ,
      actas.version_016                                             AS ver,
      actas.f_elecc_016                                             AS fechaeleccion,
      actas.fregdef_016                                             AS fecharegistro,
      COALESCE (delegadosescrutiniosh, 0 )                          AS delegadosescrutiniosh,
      COALESCE (delegadosescrutiniosm, 0 )                          AS delegadosescrutiniosm,
      COALESCE (delegadosdiferenciash, 0 )                          AS delegadosdiferenciash,
      COALESCE (delegadosdiferenciasm, 0 )                          AS delegadosdiferenciasm
    FROM w83b16s00 actas,
      j7301s01 centros,
      w83b19s00 sindicatos,
      (SELECT c_sindi_024 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (escrutinios.n_delh_024 ) AS delegadosescrutiniosh,
        SUM (escrutinios.n_delm_024 ) AS delegadosescrutiniosm,
        SUM (diferencias.n_delh_018 ) AS delegadosdiferenciash,
        SUM (diferencias.n_delm_018 ) AS delegadosdiferenciasm
      FROM w83b24s00 escrutinios,
        w83b18s00 diferencias,
        w83b16s00 actas2
      WHERE actas2.n_acta_016      = escrutinios.n_acta_024(+)
      AND actas2.ano_acta_016      = escrutinios.ano_acta_024(+)
      AND actas2.c_territ_016      = escrutinios.c_territ_024(+)
      AND actas2.version_016       = escrutinios.version_024(+)
      AND escrutinios.n_acta_024   = diferencias.n_acta_018(+)
      AND escrutinios.ano_acta_024 = diferencias.ano_acta_018(+)
      AND escrutinios.c_territ_024 = diferencias.c_territ_018(+)
      AND escrutinios.version_024  = diferencias.version_018(+)
      AND escrutinios.c_sindi_024  = diferencias.c_sindi_018(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_024
      ) consultaescdif
    WHERE centros.ccen_001        = actas.id_centro_016
    AND actas.n_acta_016          = consultaescdif.n_acta_016(+)
    AND actas.ano_acta_016        = consultaescdif.ano_acta_016(+)
    AND actas.c_territ_016        = consultaescdif.c_territ_016(+)
    AND actas.version_016         = consultaescdif.version_016(+)
    AND actas.n_regdef_016       IS NOT NULL
    AND actas.fregdef_016        IS NOT NULL
    AND actas.f_baja_016         IS NULL
    AND actas.n_acttot_016       IS NULL
    AND actas.validada_016        = 1
    AND sindicatos.c_sindi_019(+) = consultaescdif.codsindicato
    GROUP BY actas.totelec_016,
      centros.provc_001,
      centros.munic_001,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      delegadosescrutiniosh,
      delegadosescrutiniosm,
      delegadosdiferenciash,
      delegadosdiferenciasm
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 actas
    WHERE consulta.nacta = actas.n_acta_016
    AND consulta.anoacta = actas.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND validada_016     = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BREQMESASACTAS" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NUMPREAVISO", "ANOPREAVISO", "CIF", "CODIGOCENTRO", "NUMCENTRO", "RAZON", "DOMICILIO", "MUNICIPIO", "CONVENIO", "COMARCA", "NUMTRABAJADORES", "NUMREPRESENTANTES")
AS
  SELECT consulta.ver,
    consulta.fechaentrada,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.numpreaviso,
    consulta.anopreaviso,
    consulta.cif,
    consulta.codcentro,
    consulta.numerocentro,
    consulta.razon,
    consulta.domicilio,
    consulta.municipio,
    consulta.convenio,
    consulta.comarca,
    consulta.numtrabajadores,
    consulta.numrepresentantes
  FROM
    (SELECT actas.version_016   AS ver,
      actas.f_entra_016         AS fechaentrada,
      actas.n_acta_016          AS nacta,
      actas.ano_acta_016        AS anoacta,
      actas.c_territ_016        AS territ,
      actas.n_preaviso_016      AS numpreaviso,
      actas.ano_preaviso_016    AS anopreaviso,
      centros.ccif_001          AS cif,
      centros.ccen_001          AS codcentro,
      centros.ncen_001          AS numerocentro,
      centros.rsoc_001          AS razon,
      centros.domic_001         AS domicilio,
      municipios.ds_o           AS municipio,
      actas.c_conv_016          AS convenio,
      comarcas.ds_o             AS comarca,
      actas.totelec_016         AS numtrabajadores,
      COUNT (delegados.dni_025) AS numrepresentantes
    FROM w83b16s00 actas,
      j7301s01 centros,
      t17i.t17_municipio municipios,
      t17i.t17_comarca comarcas,
      w83b25s00 delegados
    WHERE centros.ccen_001      = actas.id_centro_016
    AND centros.munic_001       = municipios.ID
    AND centros.provc_001       = municipios.provincia_id
    AND actas.validada_016      = 1
    AND municipios.provincia_id = comarcas.provincia_id(+)
    AND municipios.comarca_id   = comarcas.ID(+)
    AND actas.n_acta_016        = delegados.n_acta_025(+)
    AND actas.ano_acta_016      = delegados.ano_acta_025(+)
    AND actas.c_territ_016      = delegados.c_territ_025(+)
    AND actas.version_016       = delegados.version_025(+)
    AND actas.f_reque_016      IS NOT NULL
    GROUP BY actas.version_016,
      actas.f_entra_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.n_preaviso_016,
      actas.ano_preaviso_016,
      centros.ccif_001,
      centros.ccen_001,
      centros.ncen_001,
      centros.rsoc_001,
      centros.domic_001,
      municipios.ds_o,
      actas.c_conv_016,
      comarcas.ds_o,
      totelec_016
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND act.validada_016 = 1
    )
  ORDER BY consulta.nacta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESDELEGINCIDENCIAS" ("NACTA", "TERRIT", "ANOACTA", "VER", "NREGDEF", "ANOREGDEF", "FECHABAJA", "FECHAREGISTRO", "FELEC", "CODSINDICATO", "FECHAINCIDENCIA", "FECHAVALIDACION", "CIF", "NCENTRO", "RAZON", "NUMDELEGADOS", "VBLE")
                                                           AS
  SELECT actas.n_acta_016                                  AS nacta,
    actas.c_territ_016                                     AS territ,
    actas.ano_acta_016                                     AS anoacta,
    actas.version_016                                      AS ver,
    actas.n_regdef_016                                     AS nregdef,
    ano_regdef_016                                         AS anoregdef,
    actas.f_baja_016                                       AS fechabaja,
    actas.fregdef_016                                      AS fecharegistro,
    actas.f_elecc_016                                      AS felec,
    escrutinios.c_sindi_024                                AS codsindicato,
    incidencias.f_entrada_061                              AS fechaincidencia,
    incidencias.f_validac_061                              AS fechavalidacion,
    centros.ccif_001                                       AS cif,
    centros.ncen_001                                       AS ncentro,
    centros.rsoc_001                                       AS razon,
    SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numrepresentantes,
    'escrutinio'
  FROM w83b16s00 actas,
    w83b61s00 incidencias,
    w83b24s00 escrutinios,
    j7301s01 centros
  WHERE actas.n_acta_016  = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016  = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016  = escrutinios.c_territ_024(+)
  AND actas.version_016   = escrutinios.version_024(+)
  AND actas.n_acta_016    = incidencias.n_acta_061
  AND actas.ano_acta_016  = incidencias.ano_acta_061
  AND actas.c_territ_016  = incidencias.c_territ_061
  AND actas.version_016   = incidencias.version_acta_061
  AND centros.ccen_001    = actas.id_centro_016
  AND actas.validada_016  = 1
  AND actas.n_regdef_016 IS NOT NULL
  AND actas.n_acttot_016 IS NULL
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.n_acttot_016,
    actas.f_baja_016,
    actas.fregdef_016,
    actas.f_elecc_016,
    escrutinios.c_sindi_024,
    incidencias.f_entrada_061,
    incidencias.f_validac_061,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    actas.n_regdef_016,
    ano_regdef_016
  ORDER BY nacta,
    territ,
    anoacta,
    ver DESC,
    codsindicato;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESOLDENEGFALTAPREAVISO" ("VER", "FECHAENTRADA", "NACTA", "ANOACTA", "TERRIT", "NPRE", "ANOPREAVISO", "RAZON", "DOMICILIO", "MUNICIPIO", "NUMELECTORES", "NUMREPRESENTANTES", "FIMPUG", "FREGDEF", "NUMAACTAINT")
AS
  SELECT consulta.ver,
    consulta.fechaentrada,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.npre,
    consulta.anopreaviso,
    consulta.razon,
    consulta.domicilio,
    consulta.municipio,
    consulta.numelectores,
    COUNT (consulta.numrepresentantes),
    consulta.fimpug,
    consulta.fregdef,
    consulta.numaactaint
  FROM
    (SELECT actas.version_016         AS ver,
      actas.f_entra_016               AS fechaentrada,
      actas.n_acta_016                AS nacta,
      actas.ano_acta_016              AS anoacta,
      actas.c_territ_016              AS territ,
      actas.n_preaviso_016            AS npre,
      actas.ano_preaviso_016          AS anopreaviso,
      centros.rsoc_001                AS razon,
      centros.domic_001               AS domicilio,
      municipios.ds_o                 AS municipio,
      totelec_016                     AS numelectores,
      delegados.dni_025               AS numrepresentantes,
      MAX (impugnaciones.f_impug_033) AS fimpug,
      actas.fregdef_016               AS fregdef,
      TO_NUMBER ( actas.c_territ_016
      || actas.ano_acta_016
      || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
      || TO_CHAR (actas.n_acta_016), 2, '0000'
      || TO_CHAR (actas.n_acta_016), 3, '000'
      || TO_CHAR (actas.n_acta_016), 4, '00'
      || TO_CHAR (actas.n_acta_016), 5, '0'
      || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) ) ) AS numaactaint
    FROM w83b16s00 actas,
      j7301s01 centros,
      t17i.t17_municipio municipios,
      w83b25s00 delegados,
      w83b33s00 impugnaciones
    WHERE centros.ccen_001    = actas.id_centro_016
    AND centros.munic_001     = municipios.ID
    AND centros.provc_001     = municipios.provincia_id
    AND actas.n_acta_016      = delegados.n_acta_025(+)
    AND actas.ano_acta_016    = delegados.ano_acta_025(+)
    AND actas.c_territ_016    = delegados.c_territ_025(+)
    AND actas.version_016     = delegados.version_025(+)
    AND actas.n_acta_016      = impugnaciones.n_acta_033(+)
    AND actas.ano_acta_016    = impugnaciones.ano_acta_033(+)
    AND actas.c_territ_016    = impugnaciones.c_territ_033(+)
    AND actas.version_016     = impugnaciones.version_033(+)
    AND actas.n_preaviso_016 IS NULL
    AND actas.fregdef_016    IS NULL
    AND delegados.cbaja_025  IS NULL
    AND actas.validada_016    = 1
    GROUP BY actas.version_016,
      actas.f_entra_016,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.n_preaviso_016,
      ano_preaviso_016,
      centros.rsoc_001,
      centros.domic_001,
      municipios.ds_o,
      totelec_016,
      actas.fregdef_016,
      delegados.dni_025
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 act
    WHERE consulta.nacta = act.n_acta_016
    AND consulta.anoacta = act.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND act.validada_016 = 1
    )
  GROUP BY consulta.ver,
    consulta.fechaentrada,
    consulta.nacta,
    consulta.anoacta,
    consulta.territ,
    consulta.npre,
    consulta.anopreaviso,
    consulta.razon,
    consulta.domicilio,
    consulta.municipio,
    consulta.numelectores,
    consulta.fimpug,
    consulta.fregdef,
    consulta.numaactaint
  ORDER BY consulta.numaactaint ASC,
    fimpug DESC;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULPORSECTORSINDICATO" ("TABLA", "SECTOR", "DESCSECTOR", "CODSINDICATO", "SIGLAS", "SINDDESC", "SINDDESE", "TERRIT", "FELEC", "FECHAREGISTRO", "FECHABAJA", "NUMDELEGADOSH", "NUMDELEGADOSM", "TOTAL")
AS
  SELECT consulta.tabla,
    consulta.codsector,
    consulta.descsector,
    consulta.codsindicato,
    consulta.siglas,
    consulta.descsindicato,
    consulta.desesindicato,
    consulta.territ,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja,
    consulta.delegadosh,
    consulta.delegadosm,
    consulta.delegadosh + consulta.delegadosm
  FROM
    (SELECT 'ESCRUTINIO'             AS tabla,
      centros.secc_001               AS codsector,
      sectores.desc_004              AS descsector,
      sindicatos.c_sindi_019         AS codsindicato,
      sindicatos.siglas_019          AS siglas,
      sindicatos.desc_019            AS descsindicato,
      sindicatos.dese_019            AS desesindicato,
      actas.n_acta_016               AS nacta,
      actas.ano_acta_016             AS anoacta,
      actas.c_territ_016             AS territ,
      actas.version_016              AS ver,
      actas.f_elecc_016              AS fechaeleccion,
      actas.fregdef_016              AS fecharegistro,
      actas.f_baja_016               AS fbaja,
      SUM (COALESCE (delegadosh, 0)) AS delegadosh,
      SUM (COALESCE (delegadosm, 0)) AS delegadosm
    FROM w83b16s00 actas,
      j7301s01 centros,
      j7304s00 sectores,
      w83b19s00 sindicatos,
      (SELECT c_sindi_024 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (escrutinios.n_delh_024) AS delegadosh,
        SUM (escrutinios.n_delm_024) AS delegadosm
      FROM w83b24s00 escrutinios,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = escrutinios.n_acta_024(+)
      AND actas2.ano_acta_016 = escrutinios.ano_acta_024(+)
      AND actas2.c_territ_016 = escrutinios.c_territ_024(+)
      AND actas2.version_016  = escrutinios.version_024(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_024
      UNION ALL
      SELECT c_sindi_018 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (diferencias.n_delh_018) AS delegadosh,
        SUM (diferencias.n_delm_018) AS delegadosm
      FROM w83b18s00 diferencias,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = diferencias.n_acta_018(+)
      AND actas2.ano_acta_016 = diferencias.ano_acta_018(+)
      AND actas2.c_territ_016 = diferencias.c_territ_018(+)
      AND actas2.version_016  = diferencias.version_018(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_018
      ) consultaescdif
    WHERE centros.ccen_001        = actas.id_centro_016
    AND centros.secc_001          = sectores.secc_004
    AND actas.n_acta_016          = consultaescdif.n_acta_016(+)
    AND actas.ano_acta_016        = consultaescdif.ano_acta_016(+)
    AND actas.c_territ_016        = consultaescdif.c_territ_016(+)
    AND actas.version_016         = consultaescdif.version_016(+)
    AND actas.n_regdef_016       IS NOT NULL
    AND actas.fregdef_016        IS NOT NULL
    AND actas.n_acttot_016       IS NULL
    AND actas.validada_016        = 1
    AND sindicatos.c_sindi_019(+) = consultaescdif.codsindicato
    GROUP BY centros.secc_001,
      sectores.desc_004,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      sindicatos.desc_019,
      sindicatos.dese_019,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      delegadosh,
      delegadosm
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 actas
    WHERE consulta.nacta   = actas.n_acta_016
    AND consulta.anoacta   = actas.ano_acta_016
    AND consulta.territ    = c_territ_016
    AND actas.validada_016 = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULPORSECTORSINDICATO2" ("SECTOR", "DESCSECTOR", "CODSINDICATO", "SIGLAS", "SINDDESC", "SINDDESE", "TERRIT", "FELEC", "FECHAREGISTRO", "NUMDELEGADOSH", "NUMDELEGADOSM", "TOTAL")
AS
  SELECT consulta.codsector,
    consulta.descsector,
    consulta.codsindicato,
    consulta.siglas,
    consulta.descsindicato,
    consulta.desesindicato,
    consulta.territ,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.delegadosh,
    consulta.delegadosm,
    consulta.delegadosh + consulta.delegadosm
  FROM
    (SELECT centros.secc_001   AS codsector,
      sectores.desc_004        AS descsector,
      sindicatos.c_sindi_019   AS codsindicato,
      sindicatos.siglas_019    AS siglas,
      sindicatos.desc_019      AS descsindicato,
      sindicatos.dese_019      AS desesindicato,
      actas.n_acta_016         AS nacta,
      actas.ano_acta_016       AS anoacta,
      actas.c_territ_016       AS territ,
      actas.version_016        AS ver,
      actas.f_elecc_016        AS fechaeleccion,
      actas.fregdef_016        AS fecharegistro,
      COALESCE (delegadosh, 0) AS delegadosh,
      COALESCE (delegadosm, 0) AS delegadosm
    FROM w83b16s00 actas,
      j7301s01 centros,
      j7304s00 sectores,
      w83b19s00 sindicatos,
      (SELECT c_sindi_024 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (escrutinios.n_delh_024) AS delegadosh,
        SUM (escrutinios.n_delm_024) AS delegadosm
      FROM w83b24s00 escrutinios,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = escrutinios.n_acta_024(+)
      AND actas2.ano_acta_016 = escrutinios.ano_acta_024(+)
      AND actas2.c_territ_016 = escrutinios.c_territ_024(+)
      AND actas2.version_016  = escrutinios.version_024(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_024
      ) consultaescdif
    WHERE centros.ccen_001        = actas.id_centro_016
    AND centros.secc_001          = sectores.secc_004
    AND actas.n_acta_016          = consultaescdif.n_acta_016(+)
    AND actas.ano_acta_016        = consultaescdif.ano_acta_016(+)
    AND actas.c_territ_016        = consultaescdif.c_territ_016(+)
    AND actas.version_016         = consultaescdif.version_016(+)
    AND actas.n_regdef_016       IS NOT NULL
    AND actas.fregdef_016        IS NOT NULL
    AND actas.f_baja_016         IS NULL
    AND actas.n_acttot_016       IS NULL
    AND actas.validada_016        = 1
    AND sindicatos.c_sindi_019(+) = consultaescdif.codsindicato
    GROUP BY centros.secc_001,
      sectores.desc_004,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      sindicatos.desc_019,
      sindicatos.dese_019,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      delegadosh,
      delegadosm
    UNION
    SELECT centros.secc_001    AS codsector,
      sectores.desc_004        AS descsector,
      sindicatos.c_sindi_019   AS codsindicato,
      sindicatos.siglas_019    AS siglas,
      sindicatos.desc_019      AS descsindicato,
      sindicatos.dese_019      AS desesindicato,
      actas.n_acta_016         AS nacta,
      actas.ano_acta_016       AS anoacta,
      actas.c_territ_016       AS territ,
      actas.version_016        AS ver,
      actas.f_elecc_016        AS fechaeleccion,
      actas.fregdef_016        AS fecharegistro,
      COALESCE (delegadosh, 0) AS delegadosh,
      COALESCE (delegadosm, 0) AS delegadosm
    FROM w83b16s00 actas,
      j7301s01 centros,
      j7304s00 sectores,
      w83b19s00 sindicatos,
      (SELECT c_sindi_018 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (diferencias.n_delh_018) AS delegadosh,
        SUM (diferencias.n_delm_018) AS delegadosm
      FROM w83b18s00 diferencias,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = diferencias.n_acta_018(+)
      AND actas2.ano_acta_016 = diferencias.ano_acta_018(+)
      AND actas2.c_territ_016 = diferencias.c_territ_018(+)
      AND actas2.version_016  = diferencias.version_018(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_018
      ) consultadif
    WHERE centros.ccen_001        = actas.id_centro_016
    AND centros.secc_001          = sectores.secc_004
    AND actas.n_acta_016          = consultadif.n_acta_016(+)
    AND actas.ano_acta_016        = consultadif.ano_acta_016(+)
    AND actas.c_territ_016        = consultadif.c_territ_016(+)
    AND actas.version_016         = consultadif.version_016(+)
    AND actas.n_regdef_016       IS NOT NULL
    AND actas.fregdef_016        IS NOT NULL
    AND actas.f_baja_016         IS NULL
    AND actas.n_acttot_016       IS NULL
    AND actas.validada_016        = 1
    AND sindicatos.c_sindi_019(+) = consultadif.codsindicato
    GROUP BY centros.secc_001,
      sectores.desc_004,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      sindicatos.desc_019,
      sindicatos.dese_019,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      delegadosh,
      delegadosm
    ) consulta
  WHERE consulta.ver =
    (SELECT MAX (version_016)
    FROM w83b16s00 actas
    WHERE consulta.nacta = actas.n_acta_016
    AND consulta.anoacta = actas.ano_acta_016
    AND consulta.territ  = c_territ_016
    AND validada_016     = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULPORSECTORSINDICATOHIS" ("TABLA", "SECTOR", "DESCSECTOR", "CODSINDICATO", "SIGLAS", "SINDDESC", "SINDDESE", "TERRIT", "FELEC", "FECHAREGISTRO", "FECHABAJA", "NUMDELEGADOSH", "NUMDELEGADOSM", "TOTAL", "NUMACTA", "ANOACTA", "VERS")
AS
  SELECT consulta.tabla,
    consulta.codsector,
    consulta.descsector,
    consulta.codsindicato,
    consulta.siglas,
    consulta.descsindicato,
    consulta.desesindicato,
    consulta.territ,
    consulta.fechaeleccion,
    consulta.fecharegistro,
    consulta.fbaja,
    consulta.delegadosh,
    consulta.delegadosm,
    consulta.delegadosh + consulta.delegadosm,
    consulta.nacta,
    consulta.anoacta,
    consulta.ver
  FROM
    (SELECT 'ESCRUTINIO'             AS tabla,
      centros.secc_001               AS codsector,
      sectores.desc_004              AS descsector,
      sindicatos.c_sindi_019         AS codsindicato,
      sindicatos.siglas_019          AS siglas,
      sindicatos.desc_019            AS descsindicato,
      sindicatos.dese_019            AS desesindicato,
      actas.n_acta_016               AS nacta,
      actas.ano_acta_016             AS anoacta,
      actas.c_territ_016             AS territ,
      actas.version_016              AS ver,
      actas.f_elecc_016              AS fechaeleccion,
      actas.fregdef_016              AS fecharegistro,
      actas.f_baja_016               AS fbaja,
      SUM (COALESCE (delegadosh, 0)) AS delegadosh,
      SUM (COALESCE (delegadosm, 0)) AS delegadosm
    FROM w83b16s00 actas,
      j7301s01 centros,
      j7304s00 sectores,
      w83b19s00 sindicatos,
      (SELECT c_sindi_024 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (escrutinios.n_delh_024) AS delegadosh,
        SUM (escrutinios.n_delm_024) AS delegadosm
      FROM w83b24s00 escrutinios,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = escrutinios.n_acta_024(+)
      AND actas2.ano_acta_016 = escrutinios.ano_acta_024(+)
      AND actas2.c_territ_016 = escrutinios.c_territ_024(+)
      AND actas2.version_016  = escrutinios.version_024(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_024
      UNION ALL
      SELECT c_sindi_018 AS codsindicato,
        actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        SUM (diferencias.n_delh_018) AS delegadosh,
        SUM (diferencias.n_delm_018) AS delegadosm
      FROM w83b18s00 diferencias,
        w83b16s00 actas2
      WHERE actas2.n_acta_016 = diferencias.n_acta_018(+)
      AND actas2.ano_acta_016 = diferencias.ano_acta_018(+)
      AND actas2.c_territ_016 = diferencias.c_territ_018(+)
      AND actas2.version_016  = diferencias.version_018(+)
      GROUP BY actas2.n_acta_016,
        actas2.ano_acta_016,
        actas2.c_territ_016,
        actas2.version_016,
        c_sindi_018
      ) consultaescdif
    WHERE centros.ccen_001        = actas.id_centro_016
    AND centros.secc_001          = sectores.secc_004
    AND actas.n_acta_016          = consultaescdif.n_acta_016(+)
    AND actas.ano_acta_016        = consultaescdif.ano_acta_016(+)
    AND actas.c_territ_016        = consultaescdif.c_territ_016(+)
    AND actas.version_016         = consultaescdif.version_016(+)
    AND actas.n_regdef_016       IS NOT NULL
    AND actas.fregdef_016        IS NOT NULL
    AND actas.n_acttot_016       IS NULL
    AND actas.validada_016        = 1
    AND sindicatos.c_sindi_019(+) = consultaescdif.codsindicato
    GROUP BY centros.secc_001,
      sectores.desc_004,
      sindicatos.c_sindi_019,
      sindicatos.siglas_019,
      sindicatos.desc_019,
      sindicatos.dese_019,
      actas.n_acta_016,
      actas.ano_acta_016,
      actas.c_territ_016,
      actas.version_016,
      actas.f_elecc_016,
      actas.fregdef_016,
      actas.f_baja_016,
      delegadosh,
      delegadosm
    ) consulta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULTADODELEGCERRAR" ("NACTA", "TERRIT", "ANOACTA", "VER", "NREGDEF", "ANOREGDEF", "ACTATOTAL", "FECHABAJA", "FECHAREGISTRO", "FELEC", "CODSINDICATO", "CIF", "NCENTRO", "RAZON", "NUMDELEGADOS", "NUEVA")
                            AS
  SELECT actas.n_acta_016   AS nacta,
    actas.c_territ_016      AS territ,
    actas.ano_acta_016      AS anoacta,
    actas.version_016       AS ver,
    actas.n_regdef_016      AS nregdef,
    actas.ano_regdef_016    AS anoregdef,
    actas.n_acttot_016      AS actatotal,
    actas.f_baja_016        AS fechabaja,
    actas.fregdef_016       AS fecharegistro,
    actas.f_elecc_016       AS felec,
    escrutinios.c_sindi_024 AS codsindicato,
    centros.ccif_001        AS cif,
    centros.ncen_001        AS ncentro,
    centros.rsoc_001        AS razon,
    SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024),
    actas.nueva_016 AS nueva
  FROM w83b16s00 actas,
    w83b24s00 escrutinios,
    j7301s01 centros
  WHERE actas.n_acta_016  = escrutinios.n_acta_024(+)
  AND actas.ano_acta_016  = escrutinios.ano_acta_024(+)
  AND actas.c_territ_016  = escrutinios.c_territ_024(+)
  AND actas.version_016   = escrutinios.version_024(+)
  AND centros.ccen_001    = actas.id_centro_016
  AND actas.nueva_016     = 0
  AND actas.validada_016  = 1
  AND actas.n_regdef_016 IS NOT NULL
  AND actas.n_acttot_016 IS NULL
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.n_acttot_016,
    actas.f_baja_016,
    actas.fregdef_016,
    actas.f_elecc_016,
    escrutinios.c_sindi_024,
    centros.ccif_001,
    centros.ncen_001,
    centros.rsoc_001,
    actas.n_regdef_016,
    actas.ano_regdef_016,
    actas.nueva_016
  ORDER BY nacta,
    territ,
    anoacta,
    ver,
    codsindicato;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULTADOSPORSEXO" ("TERRIT", "NUMELECTORESH", "NUMELECTORESM", "TOTALELECTORES", "NUMCANDIDATOSH", "NUMCANDIDATOSM", "NUMDELEGADOSH", "NUMDELEGADOSM")
AS
  SELECT codterriacta,
    SUM (nelecthom),
    SUM (nelectmuj),
    SUM (nelecttot),
    SUM (ncandhom),
    SUM (ncandmuj),
    SUM (ndelehom),
    SUM (ndelemuj)
  FROM
    (SELECT tact.n_acta_016 AS numacta,
      tact.ano_acta_016     AS agnoacta,
      tact.c_territ_016     AS codterriacta,
      tact.version_016      AS versacta,
      tact.f_elecc_016      AS felecacta,
      tact.fregdef_016      AS fregacta,
      tesc.n_delh_024       AS ndelehom,
      tesc.n_delm_024       AS ndelemuj,
      tact.elech_016        AS nelecthom,
      tact.elecm_016        AS nelectmuj,
      tact.totelec_016      AS nelecttot,
      tact.candh_016        AS ncandhom,
      tact.candm_016        AS ncandmuj
    FROM w83b16t00 tact,
      w83b24t00 tesc
    WHERE tact.f_elecc_016 IS NOT NULL
    AND tact.fregdef_016   IS NOT NULL
    AND tact.f_baja_016    IS NULL
    AND tact.n_acttot_016  IS NULL
    AND tesc.n_acta_024     = tact.n_acta_016
    AND tesc.ano_acta_024   = tact.ano_acta_016
    AND tesc.c_territ_024   = tact.c_territ_016
    AND tesc.version_024    = tact.version_016
    )
  GROUP BY codterriacta
  ORDER BY codterriacta;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BRESULTADOSPORSEXOINC" ("NACTA", "TERRIT", "ANOACTA", "VER", "FELEC", "ELECTORESH", "ELECTORESM", "TOTALELECTORES", "NCANDIDATOSH", "NCANDIDATOSM", "SUMDELEGADOSH", "SUMDELEGADOSM", "SUMDELEGADOS", "FECHABAJA", "FECHAREGISTRO", "FECHAACTUALIZACION", "FECHAELEC", "NACTACOMPLETA", "DSPROVINCIA")
                                                           AS
  SELECT actas.n_acta_016                                  AS nacta,
    actas.c_territ_016                                     AS territ,
    actas.ano_acta_016                                     AS anoacta,
    actas.version_016                                      AS ver,
    actas.f_elecc_016                                      AS felec,
    actas.elech_016                                        AS electoresh,
    actas.elecm_016                                        AS electoresm,
    actas.totelec_016                                      AS totalelectores,
    actas.candh_016                                        AS ncandidatosh,
    actas.candm_016                                        AS ncandidatosm,
    SUM (escrutinios.n_delh_024)                           AS delegadosh,
    SUM (escrutinios.n_delm_024)                           AS delegadosm,
    SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024 ) AS numdelegados,
    actas.f_baja_016                                       AS fechabaja,
    actas.fregdef_016                                      AS fecharegistro,
    actas.factu_016                                        AS fechaactualizacion,
    actas.f_elecc_016                                      AS fechaelec,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 ) AS nactacompleta,
    prov.ds_o              AS dsprovincia
  FROM w83b16s00 actas,
    j7301s01 centros,
    w83b13s00 convenios,
    w83b24s00 escrutinios,
    w83b19s00 sindicatos,
    t17i.t17_provincia prov
  WHERE actas.id_centro_016   = centros.ccen_001
  AND actas.c_conv_016        = convenios.c_conv_013(+)
  AND actas.n_acta_016        = escrutinios.n_acta_024
  AND actas.ano_acta_016      = escrutinios.ano_acta_024
  AND actas.c_territ_016      = escrutinios.c_territ_024
  AND actas.version_016       = escrutinios.version_024
  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
  AND actas.n_regdef_016     IS NOT NULL
  AND actas.n_acttot_016     IS NULL
  AND actas.validada_016      = 1
  AND actas.c_territ_016      = prov.ID
  GROUP BY actas.n_acta_016,
    actas.c_territ_016,
    actas.ano_acta_016,
    actas.version_016,
    actas.f_elecc_016,
    actas.elech_016,
    actas.elecm_016,
    actas.totelec_016,
    actas.candh_016,
    actas.candm_016,
    escrutinios.n_delh_024,
    escrutinios.n_delm_024,
    actas.f_baja_016,
    actas.fregdef_016,
    actas.factu_016,
    actas.f_elecc_016,
    TO_NUMBER ( actas.c_territ_016
    || actas.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)), 1, '00000'
    || TO_CHAR (actas.n_acta_016), 2, '0000'
    || TO_CHAR (actas.n_acta_016), 3, '000'
    || TO_CHAR (actas.n_acta_016), 4, '00'
    || TO_CHAR (actas.n_acta_016), 5, '0'
    || TO_CHAR (actas.n_acta_016), TO_CHAR (actas.n_acta_016) )
    || actas.version_016 ),
    prov.ds_o;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BSINDICATOSACTA" ("TERRIT", "ANOACTA", "NUMACTA", "VERSIONACTA", "COLDESC", "COLDESE", "SINDDESC", "SINDDESE", "DELH", "DELM", "NUMVOTOS")
AS
  SELECT escr.c_territ_024,
    escr.ano_acta_024,
    escr.n_acta_024,
    escr.version_024,
    col.desc_023,
    col.dese_023,
    sind.desc_019,
    sind.dese_019,
    escr.n_delh_024,
    escr.n_delm_024,
    escr.n_votos_024
  FROM w83b24t00 escr,
    w83b23t00 col,
    w83b19t00 sind
  WHERE escr.c_coleg_024 = col.c_coleg_023
  AND escr.c_sindi_024   = sind.c_sindi_019
  UNION
  SELECT dif.c_territ_018,
    dif.ano_acta_018,
    dif.n_acta_018,
    dif.version_018,
    col.desc_023,
    col.dese_023,
    sind.desc_019,
    sind.dese_019,
    dif.n_delh_018,
    dif.n_delm_018,
    0 AS sindi
  FROM w83b18t00 dif,
    w83b23t00 col,
    w83b19t00 sind
  WHERE dif.c_coleg_018 = col.c_coleg_023
  AND dif.c_sindi_018   = sind.c_sindi_019;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BSINDICATOSCOMBO" ("C_SINDI_019", "CODSIGLAS", "DESC_019", "DESE_019")
AS
  SELECT sindicatos.c_sindi_019,
    sindicatos.c_sindi_019
    || '|'
    || sindicatos.siglas_019 AS codsiglas,
    sindicatos.c_sindi_019
    || '-'
    || sindicatos.desc_019 AS desc_019,
    sindicatos.c_sindi_019
    || '-'
    || sindicatos.dese_019 AS dese_019
  FROM w83b19s00 sindicatos;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BSINDICATOSDESCCOD" ("C_SINDI_019", "DESC_019", "SIGLAS_019", "CVERIF_019", "CMADRID_019", "RELSTES_019", "DESE_019", "F_BAJA_019")
AS
  SELECT c_sindi_019,
    c_sindi_019
    || '-'
    || desc_019 AS desc_019,
    siglas_019,
    cverif_019,
    cmadrid_019,
    relstes_019,
    c_sindi_019
    || '-'
    || dese_019 AS dese_019,
    f_baja_019
  FROM w83b19s00;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BTABLAEMPRESADESCCOD" ("CEMPR_029", "DESC_029", "DESE_029", "F_BAJA_029")
AS
  SELECT CEMPR_029,
    CEMPR_029
    || '-'
    || DESC_029 AS DESC_029,
    CEMPR_029
    || '-'
    || DESE_029 AS DESE_029,
    F_BAJA_029
  FROM w83b29s00
  ORDER BY CEMPR_029;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BTIPODOCS" ("TIPODOCFASTRAM", "FASE", "TRAMITE", "DESCTIPODOC", "DESETIPODOC", "DESCFASE", "DESEFASE", "DESCTRAMITE", "DESETRAMITE")
AS
  SELECT t69.idtp_doc_069
    || '_'
    || t69.c_fase_069
    || '_'
    || t69.c_tram_069,
    t69.c_fase_069,
    t69.c_tram_069,
    t69.desc_cas_069,
    t69.desc_eus_069,
    t52.desc_052,
    t52.dese_052,
    t12.desc_012,
    t12.dese_012
  FROM w83b69t00 t69,
    w83b52t00 t52,
    w83b12t00 t12
  WHERE t69.c_fase_069 = t52.c_fase_052
  AND t69.c_fase_069   = t12.c_fase_012
  AND t69.c_tram_069   = t12.c_tram_012;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BTRAMITEDOCUMENTOS" ("C_TRAM_012", "C_FASE_012", "DESC_012", "DESE_012")
AS
  SELECT DISTINCT (c_tram_012),
    c_fase_012,
    desc_012,
    dese_012
  FROM w83b12s00 tramites,
    w83b69s00 documentos
  WHERE tramites.c_fase_012 = documentos.c_fase_069
  AND tramites.c_tram_012   = documentos.c_tram_069;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAACTAS" ("NACTA", "NACTACOMPLETO", "NREGISTRO", "NREGISTROCOMPLETO", "NPREAVISO", "RZONSOCIAL", "CIF", "NCENTRO", "CODCENTROACTA", "FELECCION", "FCOMISION", "NTRABAJADORES", "NELECTORES", "BAJA", "CODTERRITORIOACTA", "ANYOACTA", "NUMACTA", "VERSIONACTA", "CODTERRITORIOREG", "ANYOREG", "CODREG", "CODPROVINCIA", "CODMUNICIPIO", "ANYOPREAVISO", "NUMPREAVISO", "CODTERRITORIOPREAVISO", "FENTRADADATE", "FBAJA", "MOTBAJA", "CODCONVENIO", "CODINSPECCION", "ANYOACTATOTAL", "NACTATOTAL", "FASE", "TRAMITACION", "FACTUALIZACION", "FMODIFICACION", "MAXTRAM", "MAXFASE", "VALIDADA", "FECREGDEF")
AS
  SELECT w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ),
    TO_NUMBER ( w83b_16s00.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ) ),
    w83b_16s00.n_regdef_016,
    TO_NUMBER ( w83b_16s00.ano_regdef_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_regdef_016)), 1, '0000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 2, '000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 3, '00'
    || TO_CHAR (w83b_16s00.n_regdef_016), 4, '0'
    || TO_CHAR (w83b_16s00.n_regdef_016), TO_CHAR (w83b_16s00.n_regdef_016) ) ),
    DECODE (w83b_16s00.ano_preaviso_016, '', '', w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_preaviso_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_preaviso_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_preaviso_016), TO_CHAR (w83b_16s00.n_preaviso_016) ) ),
    t73_01s00.rsoc_001,
    t73_01s00.ccif_001,
    t73_01s00.ncen_001,
    w83b_16s00.id_centro_016,
    w83b_16s00.f_elecc_016,
    w83b_16s00.f_comis_016,
    t73_01s00.ntra_001,
    w83b_16s00.totelec_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_acta_016,
    w83b_16s00.n_acta_016,
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    ) AS versionacta,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_regdef_016,
    w83b_16s00.n_regdef_016,
    t73_01s00.provc_001,
    t73_01s00.munic_001,
    w83b_16s00.ano_preaviso_016,
    w83b_16s00.n_preaviso_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.f_entra_016,
    w83b_16s00.f_baja_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_conv_016,
    w83b_16s00.inspec_016,
    w83b_16s00.ano_acttot_016,
    w83b_16s00.n_acttot_016,
    t58.c_fase_058,
    t58.c_tram_058,
    t58.f_actu_058,
    t58.f_modif_058,
    (SELECT MAX (t58_2.c_tram_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    ),
    (SELECT MAX (t58_2.c_fase_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    ),
    w83b_16s00.validada_016,
    w83b_16s00.fregdef_016
  FROM w83b16s00 w83b_16s00,
    w83b58s00 t58,
    j7301s01 t73_01s00
  WHERE w83b_16s00.validada_016 = '1'
  AND w83b_16s00.id_centro_016  = t73_01s00.ccen_001
  AND w83b_16s00.ano_acta_016   = t58.ano_acta_058(+)
  AND w83b_16s00.n_acta_016     = t58.n_acta_058(+)
  AND w83b_16s00.c_territ_016   = t58.c_territ_058(+)
  AND w83b_16s00.version_016    =
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    AND t16temp.validada_016   = '1'
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAACTASPARCIALES" ("NACTA", "VERS", "ANYOACTA", "TERACTA", "NUMACTA", "NREGISTRODEF", "FREGDEF", "FENTRADA", "FELECCION", "FCOMISION", "FBAJA", "NPREAVISO", "CODCONVENIO", "CODBAJA", "TOTALELECTORES", "TOTALCANDIDATOS", "DESCCONVENIO", "DESECONVENIO", "TERRITORIO", "NUMACTATOTAL", "ANYOACTATOTAL")
AS
  SELECT c_territ_016
    || '/'
    || ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (n_acta_016)), 1, '00000'
    || TO_CHAR (n_acta_016), 2, '0000'
    || TO_CHAR (n_acta_016), 3, '000'
    || TO_CHAR (n_acta_016), 4, '00'
    || TO_CHAR (n_acta_016), 5, '0'
    || TO_CHAR (n_acta_016), TO_CHAR (n_acta_016) ) n_acta_016,
    version_016,
    ano_acta_016,
    c_territ_016,
    n_acta_016,
    DECODE (n_regdef_016, '', '', c_territ_016
    || '/'
    || ano_regdef_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (n_regdef_016)), 1, '0000'
    || TO_CHAR (n_regdef_016), 2, '000'
    || TO_CHAR (n_regdef_016), 3, '00'
    || TO_CHAR (n_regdef_016), 4, '0'
    || TO_CHAR (n_regdef_016), TO_CHAR (n_regdef_016) ) ) n_regdef_016,
    fregdef_016,
    f_entra_016,
    f_elecc_016,
    f_comis_016,
    f_baja_016,
    DECODE (ano_preaviso_016, '', '', c_territ_016
    || '/'
    || ano_preaviso_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (n_preaviso_016)), 1, '00000'
    || TO_CHAR (n_preaviso_016), 2, '0000'
    || TO_CHAR (n_preaviso_016), 3, '000'
    || TO_CHAR (n_preaviso_016), 4, '00'
    || TO_CHAR (n_preaviso_016), 5, '0'
    || TO_CHAR (n_preaviso_016), TO_CHAR (n_preaviso_016) ) ),
    c_conv_016,
    cbaja_016,
    totelec_016,
    (candh_016 + candm_016) AS totalcandidatos,
    desc_013,
    dese_013,
    c_territ_016,
    n_acttot_016,
    ano_acttot_016
  FROM w83b16s00,
    w83b13s00
  WHERE c_conv_016 = c_conv_013;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAACTASSINCENTRO" ("NACTA", "NACTACOMPLETO", "NREGISTRO", "NREGISTROCOMPLETO", "NPREAVISO", "CODCENTROACTA", "FELECCION", "FCOMISION", "NELECTORES", "BAJA", "CODTERRITORIOACTA", "ANYOACTA", "NUMACTA", "VERSIONACTA", "CODTERRITORIOREG", "ANYOREG", "CODREG", "ANYOPREAVISO", "NUMPREAVISO", "CODTERRITORIOPREAVISO", "FENTRADADATE", "FBAJA", "MOTBAJA", "CODCONVENIO", "CODINSPECCION", "ANYOACTATOTAL", "NACTATOTAL", "FASE", "TRAMITACION", "FACTUALIZACION", "FMODIFICACION", "MAXTRAM", "MAXFASE", "VALIDADA", "FECREGDEF")
AS
  SELECT w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ),
    TO_NUMBER ( w83b_16s00.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ) ),
    w83b_16s00.n_regdef_016,
    TO_NUMBER ( w83b_16s00.ano_regdef_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_regdef_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_regdef_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_regdef_016), TO_CHAR (w83b_16s00.n_regdef_016) ) ),
    DECODE (w83b_16s00.ano_preaviso_016, '', '', w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_preaviso_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_preaviso_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_preaviso_016), TO_CHAR (w83b_16s00.n_preaviso_016) ) ),
    w83b_16s00.id_centro_016,
    w83b_16s00.f_elecc_016,
    w83b_16s00.f_comis_016,
    w83b_16s00.totelec_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_acta_016,
    w83b_16s00.n_acta_016,
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    AND t16temp.validada_016   = '1'
    ) AS versionacta,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_regdef_016,
    w83b_16s00.n_regdef_016,
    w83b_16s00.ano_preaviso_016,
    w83b_16s00.n_preaviso_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.f_entra_016,
    w83b_16s00.f_baja_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_conv_016,
    w83b_16s00.inspec_016,
    w83b_16s00.ano_acttot_016,
    w83b_16s00.n_acttot_016,
    t58.c_fase_058,
    t58.c_tram_058,
    t58.f_actu_058,
    t58.f_modif_058,
    (SELECT MAX (t58_2.c_tram_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    AND t58_2.version_058    = w83b_16s00.version_016
    ),
    (SELECT MAX (t58_2.c_fase_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    AND t58_2.version_058    = w83b_16s00.version_016
    ),
    w83b_16s00.validada_016,
    w83b_16s00.fregdef_016
  FROM w83b16s00 w83b_16s00,
    w83b58s00 t58
  WHERE w83b_16s00.validada_016 = '1'
  AND w83b_16s00.ano_acta_016   = t58.ano_acta_058(+)
  AND w83b_16s00.n_acta_016     = t58.n_acta_058(+)
  AND w83b_16s00.c_territ_016   = t58.c_territ_058(+)
  AND w83b_16s00.version_016    =
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    AND t16temp.validada_016   = '1'
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAACTASTEMP" ("NACTA", "NACTACOMPLETO", "NREGISTRO", "NREGISTROCOMPLETO", "NPREAVISO", "CODCENTROACTA", "FELECCION", "FCOMISION", "NELECTORES", "BAJA", "CODTERRITORIOACTA", "ANYOACTA", "NUMACTA", "VERSIONACTA", "CODTERRITORIOREG", "ANYOREG", "CODREG", "ANYOPREAVISO", "NUMPREAVISO", "CODTERRITORIOPREAVISO", "FENTRADADATE", "FBAJA", "MOTBAJA", "CODCONVENIO", "CODINSPECCION", "ANYOACTATOTAL", "NACTATOTAL", "FASE", "TRAMITACION", "FACTUALIZACION", "FMODIFICACION", "MAXTRAM", "MAXFASE", "VALIDADA")
AS
  SELECT w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_acta_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ),
    TO_NUMBER ( w83b_16s00.ano_acta_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_acta_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_acta_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_acta_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_acta_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_acta_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_acta_016), TO_CHAR (w83b_16s00.n_acta_016) ) ),
    w83b_16s00.n_regdef_016,
    TO_NUMBER ( w83b_16s00.ano_regdef_016
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_regdef_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_regdef_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_regdef_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_regdef_016), TO_CHAR (w83b_16s00.n_regdef_016) ) ),
    DECODE (w83b_16s00.ano_preaviso_016, '', '', w83b_16s00.c_territ_016
    || '/'
    || w83b_16s00.ano_preaviso_016
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_16s00.n_preaviso_016)), 1, '00000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 2, '0000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 3, '000'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 4, '00'
    || TO_CHAR (w83b_16s00.n_preaviso_016), 5, '0'
    || TO_CHAR (w83b_16s00.n_preaviso_016), TO_CHAR (w83b_16s00.n_preaviso_016) ) ),
    w83b_16s00.id_centro_016,
    w83b_16s00.f_elecc_016,
    w83b_16s00.f_comis_016,
    w83b_16s00.totelec_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_acta_016,
    w83b_16s00.n_acta_016,
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    AND t16temp.validada_016   = 1
    ) AS versionacta,
    w83b_16s00.c_territ_016,
    w83b_16s00.ano_regdef_016,
    w83b_16s00.n_regdef_016,
    w83b_16s00.ano_preaviso_016,
    w83b_16s00.n_preaviso_016,
    w83b_16s00.c_territ_016,
    w83b_16s00.f_entra_016,
    w83b_16s00.f_baja_016,
    w83b_16s00.cbaja_016,
    w83b_16s00.c_conv_016,
    w83b_16s00.inspec_016,
    w83b_16s00.ano_acttot_016,
    w83b_16s00.n_acttot_016,
    t58.c_fase_058,
    t58.c_tram_058,
    t58.f_actu_058,
    t58.f_modif_058,
    (SELECT MAX (t58_2.c_tram_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    ),
    (SELECT MAX (t58_2.c_fase_058)
    FROM w83b58s00 t58_2
    WHERE t58_2.ano_acta_058 = w83b_16s00.ano_acta_016
    AND t58_2.n_acta_058     = w83b_16s00.n_acta_016
    AND t58_2.c_territ_058   = w83b_16s00.c_territ_016
    ),
    w83b_16s00.validada_016
  FROM w83b16s00 w83b_16s00,
    w83b58s00 t58
  WHERE w83b_16s00.validada_016 = '1'
  AND w83b_16s00.ano_acta_016   = t58.ano_acta_058(+)
  AND w83b_16s00.n_acta_016     = t58.n_acta_058(+)
  AND w83b_16s00.c_territ_016   = t58.c_territ_058(+)
  AND w83b_16s00.version_016    =
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = w83b_16s00.ano_acta_016
    AND t16temp.n_acta_016     = w83b_16s00.n_acta_016
    AND t16temp.c_territ_016   = w83b_16s00.c_territ_016
    AND t16temp.validada_016   = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAACTASVIVASCENTROREPE" ("TERRITORIO", "NUMACTA", "FELECCION", "FENTRADA", "CCIF", "NCENTROTRABAJO", "RAZONSOCIAL", "DOMIC", "MUNICIPIO", "ANO_ACTA", "NACTA", "VERSIONACTA", "DESCCONVENIO", "DESECONVENIO", "IDCENTRO")
AS
  SELECT t16.c_territ_016,
    LPAD (TO_CHAR (t16.c_territ_016), 2, '0 ')
    || '/'
    || TO_CHAR (t16.ano_acta_016)
    || '/'
    || LPAD (TO_CHAR (t16.n_acta_016), 6, '0'),
    t16.f_elecc_016,
    t16.f_entra_016,
    centro.cifnif,
    centro.ncentrotrabajo,
    centro.razonsocial,
    centro.domicilio,
    centro.municipio,
    t16.ano_acta_016,
    t16.n_acta_016,
    t16.version_016,
    t13.desc_013,
    t13.dese_013,
    t16.id_centro_016
  FROM w83bcentrotrabajo centro,
    w83b16s00 t16,
    w83b13t00 t13
  WHERE centro.codcentro = t16.id_centro_016
  AND t16.n_regdef_016  IS NOT NULL
  AND t16.f_baja_016    IS NULL
  AND t16.n_acttot_016  IS NULL
  AND t16.validada_016   = 1
  AND t13.c_conv_013     = t16.c_conv_016
  AND t16.version_016    =
    (SELECT MAX (t16temp.version_016)
    FROM w83b16s00 t16temp
    WHERE t16temp.ano_acta_016 = t16.ano_acta_016
    AND t16temp.n_acta_016     = t16.n_acta_016
    AND t16temp.c_territ_016   = t16.c_territ_016
    AND t16temp.validada_016   = 1
    );

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTACITACIONES" ("NCITACION", "ANYOIMPUGNACION", "NUMIMPUGNACION", "CODTERRITORIOIMPUGNACION", "FECHAIMPUGNACION", "NUMLAUDO", "NACTA", "IDCENTRO", "NCENTRO", "CIF", "DIRCENTRO", "CPCENTRO", "CODMUNICIPIO", "CODPROVINCIA", "CENTROMUNICIPIOTXTC", "CENTROMUNICIPIOTXTE", "CENTROPROVINCIATXTC", "CENTROPROVINCIATXTE", "RAZONSOCIAL", "DNIIMPUG", "NOMBREIMPUG", "DIRIMPUG", "CPIMPUG", "MUNIIMPUG", "PROVIMPUG", "MUNIIMPUGTXTC", "MUNIIMPUGTXTE", "PROVIMPUGTXTC", "PROVIMPUGTXTE", "MESA", "DIRORIG", "HORACITACIONI", "HORACITACIONF", "LUGARCITACION", "CODSINDICATOS", "ABRSINDICATOS", "DATOSSINDICATOS", "DATOSINTERESADOS", "ORDENSIN")
AS
  SELECT w83b_59s00.c_territ_059
    || '/'
    || w83b_59s00.ano_impugn_059
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)), 1, '00000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 2, '0000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 3, '000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 4, '00'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 5, '0'
    || TO_CHAR (w83b_59s00.num_impugnac_059), TO_CHAR (w83b_59s00.num_impugnac_059) ),
    w83b_59s00.ano_impugn_059,
    DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)), 1, '00000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 2, '0000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 3, '000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 4, '00'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 5, '0'
    || TO_CHAR (w83b_59s00.num_impugnac_059), TO_CHAR (w83b_59s00.num_impugnac_059) ),
    w83b_59s00.c_territ_059,
    w83b_33s00.f_impug_033,
    DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    CASE
      WHEN w83b_33s00.n_acta_033 IS NOT NULL
      THEN 'a'
        || w83b_33s00.c_territ_033
        || '/'
        || w83b_33s00.ano_acta_033
        || '/'
        || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
        || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
        || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
        || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
        || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
        || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) )
      ELSE 'p'
        || w83b_33s00.c_territ_033
        || '/'
        || w83b_33s00.ano_preaviso_033
        || '/'
        || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
        || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) )
    END AS nacta,
    t73_01s00.ccen_001,
    t73_01s00.ncen_001,
    t73_01s00.ccif_001,
    t73_01s00.domic_001,
    t73_01s00.cposc_001,
    t73_01s00.munic_001,
    t73_01s00.provc_001,
    fca02.ds_o,
    fca02.ds_o,
    fca01.ds_o,
    fca01.ds_o,
    t73_01s00.rsoc_001,
    w83b_59s00.dni_impugn_059,
    w83b_59s00.nombre_imp_059,
    w83b_59s00.dir_imp_059,
    w83b_59s00.codpos_imp_059,
    w83b_59s00.munic_imp_059,
    w83b_59s00.prov_impug_059,
    fca02_impug.ds_o,
    fca02_impug.ds_o,
    fca01_impug.ds_o,
    fca01_impug.ds_o,
    w83b_59s00.mesa_059,
    w83b_59s00.dir_orig_059,
    w83b_59s00.horadesde_059,
    w83b_59s00.horahasta_059,
    w83b_59s00.mesa_059,
    stragg_int (DISTINCT (w83b_19s00.c_sindi_019)),
    stragg_int (DISTINCT (w83b_19s00.siglas_019)),
    stragg_int (DISTINCT ( w83b_19s00.c_sindi_019
    || '@'
    || w83b_19s00.desc_019
    || '@'
    || w83b_19s00.dese_019
    || '@'
    || w83b_60s00.dir_sindi_060
    || '@'
    || w83b_60s00.prov_sindi_060
    || '@'
    || w83b_60s00.mun_sindi_060
    || '@'
    || w83b_60s00.tipo_sindi_060
    || '@'
    || w83b_19s00.siglas_019
    || '@'
    || w83b_60s00.codpos_060 ) ),
    stragg_int (DISTINCT ( w83b_82s00.id_int_082
    || '@'
    || w83b_82s00.nombre_int_082
    || '@'
    || w83b_82s00.dir_int_082
    || '@'
    || w83b_82s00.codpos_int_082
    || '@'
    || w83b_82s00.mun_int_082
    || '@'
    || w83b_82s00.prov_int_082 ) ),
    w83b_59s00.ord_sind_059
  FROM w83b59s00 w83b_59s00,
    w83b68s00 w83b_68s00,
    w83b60s00 w83b_60s00,
    w83b82s00 w83b_82s00,
    w83b19s00 w83b_19s00,
    w83b33s00 w83b_33s00,
    t17i.t17_municipio fca02_impug,
    t17i.t17_provincia fca01_impug,
    j7301s01 t73_01s00,
    t17i.t17_municipio fca02,
    t17i.t17_provincia fca01
  WHERE c_territ_059           = w83b_60s00.c_territ_060(+)
  AND num_impugnac_059         = w83b_60s00.num_impugnac_060(+)
  AND ano_impugn_059           = w83b_60s00.ano_impugn_060(+)
  AND c_territ_059             = w83b_82s00.c_territ_082(+)
  AND num_impugnac_059         = w83b_82s00.num_impugnac_082(+)
  AND ano_impugn_059           = w83b_82s00.ano_impugn_082(+)
  AND c_territ_059             = c_territ_068(+)
  AND num_impugnac_059         = n_impug_068(+)
  AND ano_impugn_059           = ano_impug_068(+)
  AND w83b_60s00.c_sindi_060   = w83b_19s00.c_sindi_019(+)
  AND c_territ_059             = w83b_33s00.c_territ_033(+)
  AND num_impugnac_059         = w83b_33s00.n_impug_033(+)
  AND ano_impugn_059           = w83b_33s00.ano_impug_033(+)
  AND prov_impug_059           = fca02_impug.provincia_id(+)
  AND munic_imp_059            = fca02_impug.ID(+)
  AND prov_impug_059           = fca01_impug.ID(+)
  AND w83b_59s00.id_centro_059 = t73_01s00.ccen_001(+)
  AND t73_01s00.provc_001      = fca01.ID(+)
  AND t73_01s00.provc_001      = fca02.provincia_id(+)
  AND t73_01s00.munic_001      = fca02.ID(+)
  GROUP BY w83b_59s00.c_territ_059
    || '/'
    || w83b_59s00.ano_impugn_059
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)), 1, '00000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 2, '0000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 3, '000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 4, '00'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 5, '0'
    || TO_CHAR (w83b_59s00.num_impugnac_059), TO_CHAR (w83b_59s00.num_impugnac_059) ),
    w83b_59s00.ano_impugn_059,
    w83b_33s00.f_impug_033,
    DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)), 1, '00000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 2, '0000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 3, '000'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 4, '00'
    || TO_CHAR (w83b_59s00.num_impugnac_059), 5, '0'
    || TO_CHAR (w83b_59s00.num_impugnac_059), TO_CHAR (w83b_59s00.num_impugnac_059) ),
    w83b_59s00.c_territ_059,
    DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    CASE
      WHEN w83b_33s00.n_acta_033 IS NOT NULL
      THEN 'a'
        || w83b_33s00.c_territ_033
        || '/'
        || w83b_33s00.ano_acta_033
        || '/'
        || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
        || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
        || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
        || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
        || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
        || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) )
      ELSE 'p'
        || w83b_33s00.c_territ_033
        || '/'
        || w83b_33s00.ano_preaviso_033
        || '/'
        || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
        || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
        || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) )
    END,
    t73_01s00.ccen_001,
    t73_01s00.ncen_001,
    t73_01s00.ccif_001,
    t73_01s00.domic_001,
    t73_01s00.cposc_001,
    t73_01s00.munic_001,
    t73_01s00.provc_001,
    fca02.ds_o,
    fca02.ds_o,
    fca01.ds_o,
    fca01.ds_o,
    t73_01s00.rsoc_001,
    w83b_59s00.dni_impugn_059,
    w83b_59s00.nombre_imp_059,
    w83b_59s00.dir_imp_059,
    w83b_59s00.codpos_imp_059,
    w83b_59s00.munic_imp_059,
    w83b_59s00.prov_impug_059,
    fca02_impug.ds_o,
    fca02_impug.ds_o,
    fca01_impug.ds_o,
    fca01_impug.ds_o,
    w83b_59s00.mesa_059,
    w83b_59s00.dir_orig_059,
    w83b_59s00.horadesde_059,
    w83b_59s00.horahasta_059,
    w83b_59s00.mesa_059,
    w83b_59s00.ord_sind_059;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW w83b.w83bvistadatosdocumentacion (numero,
                                                               tipo,
                                                               centro,
                                                               fechaeleccion,
                                                               fechaentrada,
                                                               fechaimpugnacion,
                                                               fechaeleccionacta,
                                                               vers,
                                                               documentos
                                                              )
AS
   SELECT   numero, tipo, centro, fechaeleccion, fechaentrada,
            fechaimpugnacion, fechaeleccionacta, vers, documentos
       FROM (
             --ACTAS
             SELECT   (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ) AS numero,
                      'ACTA' AS tipo, acta.id_centro_016 centro,
                      TO_CHAR (acta.f_elecc_016, 'dd/MM/yyyy') fechaeleccion,
                      TO_CHAR (acta.f_entra_016,
                               'dd/MM/yyyy') AS fechaentrada,
                      '' AS fechaimpugnacion,
                      acta.f_elecc_016 AS fechaeleccionacta,
                      acta.version_016 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_020
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_020
                                              || ','
                                              || doc.num_reg_020
                                              || ','
                                              || doc.id_doc_020
                                              || ',ACTA'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b16t00 acta LEFT OUTER JOIN w83b20t00 doc
                      ON acta.ano_acta_016 = doc.ano_acta_020
                    AND acta.n_acta_016 = doc.n_acta_020
                    AND acta.c_territ_016 = doc.c_territ_020
                    AND acta.version_016 = doc.version_020
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_020 = tipos.idtp_doc_069
                    AND doc.c_fase_020 = tipos.c_fase_069
                    AND doc.c_tram_020 = tipos.c_tram_069
                WHERE acta.version_016 =
                         (SELECT MAX (t16temp.version_016)
                            FROM w83b16s00 t16temp
                           WHERE t16temp.ano_acta_016 = acta.ano_acta_016
                             AND t16temp.n_acta_016 = acta.n_acta_016
                             AND t16temp.c_territ_016 = acta.c_territ_016
                             AND t16temp.validada_016 = '1')
             GROUP BY acta.ano_acta_016,
                      acta.n_acta_016,
                      acta.c_territ_016,
                      acta.version_016,
                      acta.id_centro_016,
                      acta.f_elecc_016,
                      acta.f_entra_016
             UNION
             --PREAVISOS
             SELECT   (   preaviso.c_territ_037
                       || '/'
                       || preaviso.ano_preaviso_037
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (preaviso.n_preaviso_037)),
                                  1, '00000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  2, '0000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  3, '000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  4, '00' || TO_CHAR (preaviso.n_preaviso_037),
                                  5, '0' || TO_CHAR (preaviso.n_preaviso_037),
                                  TO_CHAR (preaviso.n_preaviso_037)
                                 )
                      ) AS numero,
                      'PREAVISO' AS tipo,
                                         --se busca el centro de trabajo del propio preaviso
                                         preaviso.id_centro_037,
                      TO_CHAR (preaviso.f_elecc_037,
                               'dd/MM/yyyy'
                              ) fechaeleccion,
                      TO_CHAR (preaviso.f_entra_037,
                               'dd/MM/yyyy'
                              ) AS fechaentrada,
                      '' AS fechaimpugnacion,
                      CASE
                         WHEN preaviso.f_elecc_037 IS NOT NULL
                            THEN preaviso.f_elecc_037
                         ELSE preaviso.f_entra_037
                      END fechaeleccionacta,
                      (SELECT MAX (version_016)
                         FROM w83b16s00 actas
                        WHERE actas.n_acta_016 = preaviso.n_acta_037
                          AND actas.ano_acta_016 = preaviso.ano_acta_037
                          AND actas.c_territ_016 = preaviso.c_territ_037
                          AND validada_016 = 1) vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_038
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_038
                                              || ','
                                              || doc.num_reg_038
                                              || ','
                                              || doc.id_doc_038
                                              || ',PREAVISO'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b37t00 preaviso LEFT OUTER JOIN w83b38t00 doc
                      ON preaviso.c_territ_037 = doc.c_territ_038
                    AND preaviso.ano_preaviso_037 = doc.ano_preaviso_038
                    AND preaviso.n_preaviso_037 = doc.n_preaviso_038
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_038 = tipos.idtp_doc_069
                    AND doc.c_fase_038 = tipos.c_fase_069
                    AND doc.c_tram_038 = tipos.c_tram_069
             GROUP BY preaviso.c_territ_037,
                      preaviso.ano_preaviso_037,
                      preaviso.n_preaviso_037,
                      preaviso.id_centro_037,
                      preaviso.f_elecc_037,
                      preaviso.f_entra_037,
                      preaviso.n_acta_037,
                      preaviso.ano_acta_037,
                      preaviso.c_territ_037
             UNION
             --INCIDENCIAS
             SELECT   (   incidencia.c_territ_061
                       || '/'
                       || incidencia.ano_incid_061
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (incidencia.n_incid_061)),
                                  1, '00000'
                                   || TO_CHAR (incidencia.n_incid_061),
                                  2, '0000'
                                   || TO_CHAR (incidencia.n_incid_061),
                                  3, '000' || TO_CHAR (incidencia.n_incid_061),
                                  4, '00' || TO_CHAR (incidencia.n_incid_061),
                                  5, '0' || TO_CHAR (incidencia.n_incid_061),
                                  TO_CHAR (incidencia.n_incid_061)
                                 )
                      ) AS numero,
                      'INCIDENCIA' AS tipo,
                      (SELECT act.id_centro_016
                         FROM w83b16t00 act INNER JOIN w83b61t00 inc
                              ON act.ano_acta_016 = inc.ano_acta_061
                            AND act.n_acta_016 = inc.n_acta_061
                            AND act.c_territ_016 = inc.c_territ_061
                        --hay que sacar todas las incidencias, conrrespondan con el acta validada o no
                        --AND act.version_016 = inc.version_acta_061
                       WHERE  incidencia.ano_incid_061 = inc.ano_incid_061
                          AND incidencia.n_incid_061 = inc.n_incid_061
                          AND incidencia.c_territ_061 = inc.c_territ_061
                          AND act.version_016 =
                                 (SELECT MAX (t16temp.version_016)
                                    FROM w83b16s00 t16temp
                                   WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                     AND t16temp.n_acta_016 = act.n_acta_016
                                     AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                                              --AND t16temp.validada_016 = '1'
                                 )) centro,
                      --sacamos su fecha
                      '' fechaeleccion,
                      TO_CHAR (incidencia.f_entrada_061,
                               'dd/MM/yyyy'
                              ) fechaentrada,
                      '' fechaimpugnacion,
                      (SELECT act.f_elecc_016
                         FROM w83b16t00 act INNER JOIN w83b61t00 inc
                              ON act.ano_acta_016 =
                                        inc.ano_acta_061
                            AND act.n_acta_016 = inc.n_acta_061
                            AND act.c_territ_016 = inc.c_territ_061
                            AND act.version_016 = inc.version_acta_061
                        WHERE incidencia.ano_incid_061 = inc.ano_incid_061
                          AND incidencia.n_incid_061 = inc.n_incid_061
                          AND incidencia.c_territ_061 = inc.c_territ_061
                                                                        /*AND act.version_016 =
                                                                               (SELECT MAX (t16temp.version_016)
                                                                                  FROM w83b16s00 t16temp
                                                                                 WHERE t16temp.ano_acta_016 =
                                                                                                        act.ano_acta_016
                                                                                   AND t16temp.n_acta_016 =
                                                                                                          act.n_acta_016
                                                                                   AND t16temp.c_territ_016 =
                                                                                                        act.c_territ_016
                                                                                                                        --AND t16temp.validada_016 = '1'
                                                                               )*/
                      ) AS fechaeleccionacta,
                      0 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_064
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_064
                                              || ','
                                              || doc.num_reg_064
                                              || ','
                                              || doc.id_doc_064
                                              || ',INCIDENCIA'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b61t00 incidencia LEFT OUTER JOIN w83b64t00 doc
                      ON incidencia.c_territ_061 = doc.c_territ_064
                    AND incidencia.ano_incid_061 = doc.ano_incid_064
                    AND incidencia.n_incid_061 = doc.n_incid_064
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_064 = tipos.idtp_doc_069
                    AND doc.c_tram_064 = tipos.c_fase_069
                    AND doc.c_tram_064 = tipos.c_tram_069
                --en principio no se mira si estan validadas o no
                --no se muestran las de tipo subsanacion
             --ahora puede ser de cualquier tipo WHERE    incidencia.tp_incidencia_061 <> 7
             GROUP BY incidencia.c_territ_061,
                      incidencia.ano_incid_061,
                      incidencia.n_incid_061,
                      incidencia.f_entrada_061
             UNION
             --IMPUGNACIONES
             SELECT   (   impugnacion.c_territ_033
                       || '/'
                       || impugnacion.ano_impug_033
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (impugnacion.n_impug_033)),
                                  1, '00000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  2, '0000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  3, '000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  4, '00' || TO_CHAR (impugnacion.n_impug_033),
                                  5, '0' || TO_CHAR (impugnacion.n_impug_033),
                                  TO_CHAR (impugnacion.n_impug_033)
                                 )
                      ) AS numero,
                      'IMPUGNACION' AS tipo,
                      CASE
                         --es de un acta
                      WHEN impugnacion.n_acta_033 > 0
                            THEN (SELECT act.id_centro_016
                                    FROM w83b16t00 act INNER JOIN w83b33t00 imp
                                         ON act.ano_acta_016 =
                                                      imp.ano_acta_033
                                       AND act.n_acta_016 = imp.n_acta_033
                                       AND act.c_territ_016 = imp.c_territ_033
                                       AND act.version_016 = imp.version_033
                                   WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                                     AND impugnacion.n_impug_033 =
                                                               imp.n_impug_033
                                     AND impugnacion.c_territ_033 =
                                                              imp.c_territ_033
                                     AND act.version_016 =
                                            (SELECT MAX (t16temp.version_016)
                                               FROM w83b16s00 t16temp
                                              WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                                AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                                AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                AND t16temp.validada_016 = '1'))
                         --es de un preaviso
                      ELSE (SELECT pre.id_centro_037
                              FROM w83b37t00 pre INNER JOIN w83b33t00 imp
                                   ON pre.ano_preaviso_037 =
                                                          imp.ano_preaviso_033
                                 AND pre.n_preaviso_037 = imp.n_preaviso_033
                                 AND pre.c_territ_037 = imp.c_territ_033
                             WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                               AND impugnacion.n_impug_033 = imp.n_impug_033
                               AND impugnacion.c_territ_033 = imp.c_territ_033)
                      END centro,        
                      --sacamos sus fechas propias
                      '' fechaeleccion, '' fechaentrada,
                      TO_CHAR (impugnacion.f_impug_033,
                               'dd/MM/yyyy'
                              ) fechaimpugnacion,
                      CASE
                         --es de un acta
                      WHEN impugnacion.n_acta_033 > 0
                            THEN (SELECT act.f_elecc_016
                                    FROM w83b16t00 act INNER JOIN w83b33t00 imp
                                         ON act.ano_acta_016 =
                                                       imp.ano_acta_033
                                       AND act.n_acta_016 = imp.n_acta_033
                                       AND act.c_territ_016 = imp.c_territ_033
                                       AND act.version_016 = imp.version_033
                                   WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                                     AND impugnacion.n_impug_033 =
                                                               imp.n_impug_033
                                     AND impugnacion.c_territ_033 =
                                                              imp.c_territ_033
                                     AND act.version_016 =
                                            (SELECT MAX (t16temp.version_016)
                                               FROM w83b16s00 t16temp
                                              WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                                AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                                AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                AND t16temp.validada_016 = '1'))
                         --es de un preaviso
                      ELSE CASE
                         WHEN (SELECT prea.f_elecc_037
                                 FROM w83b16t00 act INNER JOIN w83b37t00 prea
                                      ON act.ano_acta_016 = prea.ano_acta_037
                                    AND act.n_acta_016 = prea.n_acta_037
                                    AND act.c_territ_016 = prea.c_territ_037
                                -- AND act.version_016 = prea.
                               WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                  AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                  AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                  AND act.version_016 =
                                         (SELECT MAX (t16temp.version_016)
                                            FROM w83b16s00 t16temp
                                           WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                             AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                             AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                             AND t16temp.validada_016 = '1')) IS NOT NULL
                            THEN (SELECT prea.f_elecc_037
                                    FROM /*w83b16t00 act INNER JOIN*/ w83b37t00 prea
                                         /*ON act.ano_acta_016 =
                                                            prea.ano_acta_037
                                       AND act.n_acta_016 = prea.n_acta_037
                                       AND act.c_territ_016 =
                                                            prea.c_territ_037*/
                                   -- AND act.version_016 = prea.
                                  WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                     AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                     AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                                                              /*AND act.version_016 =
                                                                                     (SELECT MAX (t16temp.version_016)
                                                                                        FROM w83b16s00 t16temp
                                                                                       WHERE t16temp.ano_acta_016 =
                                                                                                      act.ano_acta_016
                                                                                         AND t16temp.n_acta_016 =
                                                                                                        act.n_acta_016
                                                                                         AND t16temp.c_territ_016 =
                                                                                                      act.c_territ_016
                                                                                         AND t16temp.validada_016 =
                                                                                                                   '1')*/
                                )
                         ELSE (SELECT prea.f_entra_037
                                 FROM /*w83b16t00 act INNER JOIN*/ w83b37t00 prea
                                      /*ON act.ano_acta_016 =
                                                         prea.ano_acta_037
                                    AND act.n_acta_016 = prea.n_acta_037
                                    AND act.c_territ_016 =
                                                         prea.c_territ_037*/
                                -- AND act.version_016 = prea.
                               WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                  AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                  AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                                                              /*AND act.version_016 =
                                                                                     (SELECT MAX (t16temp.version_016)
                                                                                        FROM w83b16s00 t16temp
                                                                                       WHERE t16temp.ano_acta_016 =
                                                                                                      act.ano_acta_016
                                                                                         AND t16temp.n_acta_016 =
                                                                                                        act.n_acta_016
                                                                                         AND t16temp.c_territ_016 =
                                                                                                      act.c_territ_016
                                                                                         AND t16temp.validada_016 =
                                                                                                                   '1')*/
                      )
                      END
                      END padre,
                      impugnacion.version_033 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_041
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_041
                                              || ','
                                              || doc.num_reg_041
                                              || ','
                                              || doc.id_doc_041
                                              || ',IMPUGNACION'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b33t00 impugnacion LEFT OUTER JOIN w83b41t00 doc
                      ON impugnacion.c_territ_033 = doc.c_territ_041
                    AND impugnacion.ano_impug_033 = doc.ano_impug_041
                    AND impugnacion.n_impug_033 = doc.n_impug_041
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_041 = tipos.idtp_doc_069
                    AND doc.c_fase_041 = tipos.c_fase_069
                    AND doc.c_tram_041 = tipos.c_tram_069
             GROUP BY impugnacion.c_territ_033,
                      impugnacion.ano_impug_033,
                      impugnacion.n_impug_033,
                      impugnacion.version_033,
                      impugnacion.n_acta_033,
                      impugnacion.f_impug_033,
                      impugnacion.ano_preaviso_033,
                      impugnacion.n_preaviso_033)
   ORDER BY numero;
/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTADELEGADOSINCIDENCIAS" ("ACTATERRITORIO", "ACTAANYO", "ACTANUM", "VERSIONACTA", "VALIDADA", "CODCOLEGIO", "COLEGIO_CAST", "COLEGIO_EUSK", "DNIDELEGADO", "PRIMERAPELLIDODELEGADO", "SEGUNDOAPELLIDODELEGADO", "NOMBREDELEGADO", "SEXODELEGADO", "CODSINDICATO", "SINDICATO_CAST", "SINDICATO_EUSK", "SIGLAS", "FECHAALTA", "FECHABAJA", "CODBAJA", "BAJA_CAST", "BAJA_EUSK", "DNISUSTITUTO", "USUARIO", "FACTU")
AS
  SELECT t25.c_territ_025,
    t25.ano_acta_025,
    t25.n_acta_025,
    t25.version_025,
    t16.validada_016,
    t25.c_coleg_025,
    t23.desc_023,
    t23.dese_023,
    t25.dni_025,
    t25.apel1_025,
    t25.apel2_025,
    t25.nombre_025,
    t25.sexo_025,
    t25.c_sindi_025,
    t19.desc_019,
    t19.dese_019,
    t19.siglas_019,
    t25.f_alta_025,
    t25.f_baja_025,
    t25.cbaja_025,
    t26.desc_026,
    t26.dese_026,
    t25.dni_sust_025,
    t25.usua_025,
    t25.factu_025
  FROM w83b25s00 t25,
    w83b16s00 t16,
    w83b23s00 t23,
    w83b19s00 t19,
    w83b26s00 t26
  WHERE t25.c_territ_025 = t16.c_territ_016
  AND t25.ano_acta_025   = t16.ano_acta_016
  AND t25.n_acta_025     = t16.n_acta_016
  AND t25.version_025    = t16.version_016
  AND t23.c_coleg_023    = t25.c_coleg_025
  AND t19.c_sindi_019    = t25.c_sindi_025
  AND t26.cbaja_026(+)   = t25.cbaja_025;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAIMPUGCONCENTRO" ("NIMPUGNACION", "NPREAVISO", "NACTA", "ANYOIMPUGNACION", "NUMIMPUGNACION", "CODTERRITORIOIMPUGNACION", "ANYOPREAVISO", "NUMPREAVISO", "ANYOACTA", "NUMACTA", "VERSION", "ANYOLAUDO", "NUMLAUDO", "FIMPUGNACIONDATE", "ARBITRO", "NOMARBITRO", "FENVIOARBITRODATE", "FENVIOJUZGADODATE", "FSENTENCIADATE", "TIPOIMPUG", "DESCTIPOIMPUG", "DESETIPOIMPUG", "ASUNTO", "DECISION", "NLAUDO", "FLAUDODATE", "FDESESTIMIENTODATE", "RESULTADO", "DESCRESULTADO", "DESERESULTADO", "IDCENTRO", "NREGISTRO", "FREGISTRODATE", "DNIIMPUG", "NOMBREIMPUG", "DIRIMPUG", "CPIMPUG", "MUNIIMPUG", "PROVIMPUG", "CITACION", "CODVOCES", "DESCVOCES", "DESEVOCES", "CODSINDICATOS", "DESCSINDICATOS", "DESESINDICATOS", "NIMPUGNACIONESINT", "NPREAVISOSINT", "NACTASINT", "NLAUDOSINT", "ABRSINDICATOS", "NCENTRO", "CIF", "DIRCENTRO", "CODMUNICIPIO", "CODPROVINCIA", "RAZONSOCIAL")
AS
  SELECT w83bvistaimpugsimple."NIMPUGNACION",
    w83bvistaimpugsimple."NPREAVISO",
    w83bvistaimpugsimple."NACTA",
    w83bvistaimpugsimple."ANYOIMPUGNACION",
    w83bvistaimpugsimple."NUMIMPUGNACION",
    w83bvistaimpugsimple."CODTERRITORIOIMPUGNACION",
    w83bvistaimpugsimple."ANYOPREAVISO",
    w83bvistaimpugsimple."NUMPREAVISO",
    w83bvistaimpugsimple."ANYOACTA",
    w83bvistaimpugsimple."NUMACTA",
    w83bvistaimpugsimple."VERSION",
    w83bvistaimpugsimple."ANYOLAUDO",
    w83bvistaimpugsimple."NUMLAUDO",
    w83bvistaimpugsimple."FIMPUGNACIONDATE",
    w83bvistaimpugsimple."ARBITRO",
    w83bvistaimpugsimple."NOMARBITRO",
    w83bvistaimpugsimple."FENVIOARBITRODATE",
    w83bvistaimpugsimple."FENVIOJUZGADODATE",
    w83bvistaimpugsimple."FSENTENCIADATE",
    w83bvistaimpugsimple."TIPOIMPUG",
    w83bvistaimpugsimple."DESCTIPOIMPUG",
    w83bvistaimpugsimple."DESETIPOIMPUG",
    w83bvistaimpugsimple."ASUNTO",
    w83bvistaimpugsimple."DECISION",
    w83bvistaimpugsimple."NLAUDO",
    w83bvistaimpugsimple."FLAUDODATE",
    w83bvistaimpugsimple."FDESESTIMIENTODATE",
    w83bvistaimpugsimple."RESULTADO",
    w83bvistaimpugsimple."DESCRESULTADO",
    w83bvistaimpugsimple."DESERESULTADO",
    w83bvistaimpugsimple."IDCENTRO",
    w83bvistaimpugsimple."NREGISTRO",
    w83bvistaimpugsimple."FREGISTRODATE",
    w83bvistaimpugsimple."DNIIMPUG",
    w83bvistaimpugsimple."NOMBREIMPUG",
    w83bvistaimpugsimple."DIRIMPUG",
    w83bvistaimpugsimple."CPIMPUG",
    w83bvistaimpugsimple."MUNIIMPUG",
    w83bvistaimpugsimple."PROVIMPUG",
    w83bvistaimpugsimple."CITACION",
    w83bvistaimpugsimple."CODVOCES",
    w83bvistaimpugsimple."DESCVOCES",
    w83bvistaimpugsimple."DESEVOCES",
    w83bvistaimpugsimple."CODSINDICATOS",
    w83bvistaimpugsimple."DESCSINDICATOS",
    w83bvistaimpugsimple."DESESINDICATOS",
    w83bvistaimpugsimple."NIMPUGNACIONESINT",
    w83bvistaimpugsimple."NPREAVISOSINT",
    w83bvistaimpugsimple."NACTASINT",
    w83bvistaimpugsimple."NLAUDOSINT",
    w83bvistaimpugsimple."ABRSINDICATOS",
    t73_01s00.ncen_001,
    t73_01s00.ccif_001,
    t73_01s00.domic_001,
    t73_01s00.munic_001,
    t73_01s00.provc_001,
    t73_01s00.rsoc_001
  FROM w83bvistaimpugsimple,
    j7301s01 t73_01s00
  WHERE w83bvistaimpugsimple.idcentro = t73_01s00.ccen_001;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAIMPUGNACIONES" ("NIMPUGNACION", "NPREAVISO", "NACTA", "ANYOIMPUGNACION", "NUMIMPUGNACION", "CODTERRITORIOIMPUGNACION", "ANYOPREAVISO", "NUMPREAVISO", "ANYOACTA", "NUMACTA", "VERSION", "ANYOLAUDO", "NUMLAUDO", "FIMPUGNACIONDATE", "ARBITRO", "NOMARBITRO", "FENVIOARBITRODATE", "FENVIOJUZGADODATE", "FSENTENCIADATE", "TIPOIMPUG", "DESCTIPOIMPUG", "DESETIPOIMPUG", "ASUNTO", "DECISION", "NLAUDO", "FLAUDODATE", "FDESESTIMIENTODATE", "RESULTADO", "DESCRESULTADO", "DESERESULTADO", "IDCENTRO", "NCENTRO", "CIF", "DIRCENTRO", "CODMUNICIPIO", "CODPROVINCIA", "CENTROMUNICIPIOTXTC", "CENTROMUNICIPIOTXTE", "CENTROPROVINCIATXTC", "CENTROPROVINCIATXTE", "RAZONSOCIAL", "NREGISTRO", "FREGISTRODATE", "DNIIMPUG", "NOMBREIMPUG", "DIRIMPUG", "CPIMPUG", "MUNIIMPUG", "PROVIMPUG", "MUNIIMPUGTXTC", "MUNIIMPUGTXTE", "PROVIMPUGTXTC", "PROVIMPUGTXTE", "CITACION", "CODVOCES", "DESCVOCES", "DESEVOCES", "CODSINDICATOS", "DESCSINDICATOS", "DESESINDICATOS",
  "NIMPUGNACIONESINT", "NPREAVISOSINT", "NACTASINT", "NLAUDOSINT", "ABRSINDICATOS")
AS
  SELECT w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ),
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ),
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ),
    w83b_33s00.ano_impug_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ),
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ),
    w83b_33s00.ano_acta_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ),
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_75s00.desc_rdo_cas_075,
    w83b_75s00.desc_rdo_eus_075,
    t73_01s00.ccen_001,
    t73_01s00.ncen_001,
    t73_01s00.ccif_001,
    t73_01s00.domic_001,
    t73_01s00.munic_001,
    t73_01s00.provc_001,
    fca02.ds_o,
    fca02.ds_o,
    fca01.ds_o,
    fca01.ds_o,
    t73_01s00.rsoc_001,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    w83b_76s00.dni_imp_076,
    w83b_76s00.nombre_imp_076,
    w83b_76s00.dir_imp_076,
    w83b_76s00.codpos_imp_076,
    w83b_76s00.mun_imp_076,
    w83b_76s00.prov_imp_076,
    fca02_impug.ds_o,
    fca02_impug.ds_o,
    fca01_impug.ds_o,
    fca01_impug.ds_o,
    w83b_59s00.id_centro_059,
    stragg_int (DISTINCT ( w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT ( w83b_32s00.desc_032
    || '|'
    || w83b_31s00.desc_031
    || '@'
    || w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT ( w83b_32s00.dese_032
    || '|'
    || w83b_31s00.dese_031
    || '@'
    || w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT (w83b_19s00.c_sindi_019)),
    stragg_int (DISTINCT ( w83b_19s00.desc_019
    || '@'
    || w83b_19s00.c_sindi_019 ) ),
    stragg_int (DISTINCT ( w83b_19s00.dese_019
    || '@'
    || w83b_19s00.c_sindi_019 ) ),
    TO_NUMBER ( w83b_33s00.ano_impug_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ) ) AS nimpugnacionesint,
    TO_NUMBER ( w83b_33s00.ano_preaviso_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ) ) AS npreavisosint,
    TO_NUMBER ( w83b_33s00.ano_acta_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ) ) AS nactasint,
    TO_NUMBER ( w83b_68s00.ano_laudo_068
    || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ) ) AS nlaudosint,
    stragg_int (DISTINCT (w83b_19s00.siglas_019))
  FROM w83b33s00 w83b_33s00,
    w83b68s00 w83b_68s00,
    w83b30s00 w83b_30s00,
    w83b59s00 w83b_59s00,
    w83b75s00 w83b_75s00,
    w83b34s00 w83b_34s00,
    w83b31s00 w83b_31s00,
    w83b32s00 w83b_32s00,
    w83b37s00 w83b_37s00,
    w83b16s00 w83b_16s00,
    w83b76s00 w83b_76s00,
    t17i.t17_municipio fca02_impug,
    t17i.t17_provincia fca01_impug,
    w83b36s00 w83b_36s00,
    j7301s01 t73_01s00,
    t17i.t17_municipio fca02,
    t17i.t17_provincia fca01,
    w83b35s00 w83b_35s00,
    w83b19s00 w83b_19s00
  WHERE c_impug_033                 = c_impug_030
  AND c_territ_033                  = c_territ_068(+)
  AND n_impug_033                   = n_impug_068(+)
  AND ano_impug_033                 = ano_impug_068(+)
  AND c_territ_033                  = c_territ_059(+)
  AND n_impug_033                   = num_impugnac_059(+)
  AND ano_impug_033                 = ano_impugn_059(+)
  AND rdo_laudo_068                 = id_rdo_075(+)
  AND c_territ_068                  = c_territ_034(+)
  AND n_impug_068                   = n_impug_034(+)
  AND ano_impug_068                 = ano_impug_034(+)
  AND n_laudo_068                   = n_laudo_034(+)
  AND ano_laudo_068                 = ano_laudo_034(+)
  AND ctipvoz_034                   = ctipvoz_031(+)
  AND cvoz_034                      = cvoz_031(+)
  AND ctipvoz_031                   = ctipvoz_032(+)
  AND c_territ_033                  = c_territ_037(+)
  AND n_preaviso_033                = n_preaviso_037(+)
  AND ano_preaviso_033              = ano_preaviso_037(+)
  AND c_territ_033                  = c_territ_016(+)
  AND n_acta_033                    = n_acta_016(+)
  AND ano_acta_033                  = ano_acta_016(+)
  AND version_033                   = version_016(+)
  AND c_territ_033                  = c_territ_076(+)
  AND n_impug_033                   = n_impug_076(+)
  AND ano_impug_033                 = ano_impug_076(+)
  AND w83b_76s00.prov_imp_076       = fca02_impug.provincia_id(+)
  AND w83b_76s00.mun_imp_076        = fca02_impug.ID(+)
  AND w83b_76s00.prov_imp_076       = fca01_impug.ID(+)
  AND dni_033                       = dni_036(+)
  AND c_territ_033                  = w83b_36s00.c_territ_036(+)
  AND ( ( w83b_37s00.id_centro_037 IS NULL
  AND t73_01s00.ccen_001            = w83b_16s00.id_centro_016 )
  OR ( w83b_16s00.id_centro_016    IS NULL
  AND t73_01s00.ccen_001            = w83b_37s00.id_centro_037 ) )
  AND t73_01s00.provc_001           = fca02.provincia_id(+)
  AND t73_01s00.munic_001           = fca02.ID(+)
  AND t73_01s00.provc_001           = fca01.ID(+)
  AND c_territ_033                  = c_territ_035(+)
  AND n_impug_033                   = n_impug_035(+)
  AND ano_impug_033                 = ano_impug_035(+)
  AND c_sindi_035                   = c_sindi_019(+)
  GROUP BY w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || w83b_33s00.n_preaviso_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || w83b_33s00.n_acta_033,
    w83b_33s00.ano_impug_033,
    w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    w83b_33s00.n_preaviso_033,
    w83b_33s00.ano_acta_033,
    w83b_33s00.n_acta_033,
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    w83b_68s00.n_laudo_068,
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || w83b_68s00.n_laudo_068,
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_75s00.desc_rdo_cas_075,
    w83b_75s00.desc_rdo_eus_075,
    t73_01s00.ccen_001,
    t73_01s00.ncen_001,
    t73_01s00.ccif_001,
    t73_01s00.domic_001,
    t73_01s00.munic_001,
    t73_01s00.provc_001,
    fca02.ds_o,
    fca02.ds_o,
    fca01.ds_o,
    fca01.ds_o,
    t73_01s00.rsoc_001,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    w83b_76s00.dni_imp_076,
    w83b_76s00.nombre_imp_076,
    w83b_76s00.dir_imp_076,
    w83b_76s00.codpos_imp_076,
    w83b_76s00.mun_imp_076,
    w83b_76s00.prov_imp_076,
    fca02_impug.ds_o,
    fca02_impug.ds_o,
    fca01_impug.ds_o,
    fca01_impug.ds_o,
    w83b_59s00.id_centro_059;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAIMPUGNACIONESACTAS" ("NIMPUGNACION", "NPREAVISO", "NACTA", "ANO_IMPUG", "NUM_IMPUG", "TERRIT", "ANO_PREAVISO", "NUM_PREAVISO", "ANO_ACTA", "NUM_ACTA", "VERSION", "ANO_LAUDO", "NUM_LAUDO", "FIMPUGNACIONDATE", "ARBITRO", "NOMARBITRO", "FENVIOARBITRODATE", "FENVIOJUZGADODATE", "FSENTENCIADATE", "TIPOIMPUG", "DESCTIPOIMPUG", "DESETIPOIMPUG", "ASUNTO", "DECISION", "LAUDO", "FECHALAUDO", "FECHADESES", "RESULTADOLAUDO", "NREGISTRO", "FREGISTRODATE", "SINDICATOS", "NOMBREIMPUGNANTE")
AS
  SELECT w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || w83b_33s00.n_impug_033 AS impugnacion,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || w83b_33s00.n_preaviso_033 AS preaviso,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || w83b_33s00.n_acta_033 AS acta,
    w83b_33s00.ano_impug_033,
    w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    w83b_33s00.n_preaviso_033,
    w83b_33s00.ano_acta_033,
    w83b_33s00.n_acta_033,
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    w83b_68s00.n_laudo_068,
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || w83b_68s00.n_laudo_068 AS laudo,
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    --stragg (DISTINCT (w83b_19s00.c_sindi_019)),
    stragg (w83b_19s00.siglas_019) AS sindicato,
    nombre_imp_076
  FROM w83b33s00 w83b_33s00
  LEFT OUTER JOIN w83b30s00 w83b_30s00
  ON (c_impug_033 = c_impug_030)
  LEFT OUTER JOIN w83b68s00 w83b_68s00
  ON ( c_territ_033 = c_territ_068
  AND n_impug_033   = n_impug_068
  AND ano_impug_033 = ano_impug_068 )
  LEFT OUTER JOIN w83b37s00 w83b_37s00
  ON ( c_territ_033    = c_territ_037
  AND n_preaviso_033   = n_preaviso_037
  AND ano_preaviso_033 = ano_preaviso_037
  AND n_acta_033      IS NULL )
  LEFT OUTER JOIN w83b16s00 w83b_16s00
  ON ( c_territ_033 = c_territ_016
  AND n_acta_033    = n_acta_016
  AND ano_acta_033  = ano_acta_016
  AND version_033   = version_016 )
  LEFT OUTER JOIN w83b36s00 w83b_36s00
  ON (dni_033      = dni_036
  AND c_territ_033 = c_territ_036)
  LEFT OUTER JOIN w83b35s00 w83b_35s00
  ON ( c_territ_033 = c_territ_035
  AND n_impug_033   = n_impug_035
  AND ano_impug_033 = ano_impug_035 )
  LEFT OUTER JOIN w83b19s00 w83b_19s00
  ON (c_sindi_035 = c_sindi_019 )
  LEFT OUTER JOIN w83b76t00
  ON ( c_territ_076 = c_territ_033
  AND ano_impug_076 = ano_impug_033
  AND n_impug_076   = n_impug_033 )
  GROUP BY w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || w83b_33s00.n_preaviso_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || w83b_33s00.n_acta_033,
    w83b_33s00.ano_impug_033,
    w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    w83b_33s00.n_preaviso_033,
    w83b_33s00.ano_acta_033,
    w83b_33s00.n_acta_033,
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    w83b_68s00.n_laudo_068,
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || w83b_68s00.n_laudo_068,
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    nombre_imp_076;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAIMPUGSIMPLE" ("NIMPUGNACION", "NPREAVISO", "NACTA", "ANYOIMPUGNACION", "NUMIMPUGNACION", "CODTERRITORIOIMPUGNACION", "ANYOPREAVISO", "NUMPREAVISO", "ANYOACTA", "NUMACTA", "VERSION", "ANYOLAUDO", "NUMLAUDO", "FIMPUGNACIONDATE", "ARBITRO", "NOMARBITRO", "FENVIOARBITRODATE", "FENVIOJUZGADODATE", "FSENTENCIADATE", "TIPOIMPUG", "DESCTIPOIMPUG", "DESETIPOIMPUG", "ASUNTO", "DECISION", "NLAUDO", "FLAUDODATE", "FDESESTIMIENTODATE", "RESULTADO", "DESCRESULTADO", "DESERESULTADO", "IDCENTRO", "NREGISTRO", "FREGISTRODATE", "DNIIMPUG", "NOMBREIMPUG", "DIRIMPUG", "CPIMPUG", "MUNIIMPUG", "PROVIMPUG", "CITACION", "CODVOCES", "DESCVOCES", "DESEVOCES", "CODSINDICATOS", "DESCSINDICATOS", "DESESINDICATOS", "NIMPUGNACIONESINT", "NPREAVISOSINT", "NACTASINT", "NLAUDOSINT", "ABRSINDICATOS")
AS
  SELECT w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ),
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ),
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ),
    w83b_33s00.ano_impug_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ),
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ),
    w83b_33s00.ano_acta_033,
    DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ),
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ),
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_75s00.desc_rdo_cas_075,
    w83b_75s00.desc_rdo_eus_075,
    CASE
      WHEN w83b_37s00.id_centro_037 IS NULL
      THEN w83b_16s00.id_centro_016
      WHEN w83b_16s00.id_centro_016 IS NULL
      THEN w83b_37s00.id_centro_037
      ELSE 0
    END AS idcentro,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    w83b_76s00.dni_imp_076,
    w83b_76s00.nombre_imp_076,
    w83b_76s00.dir_imp_076,
    w83b_76s00.codpos_imp_076,
    w83b_76s00.mun_imp_076,
    w83b_76s00.prov_imp_076,
    w83b_59s00.id_centro_059,
    stragg_int (DISTINCT ( w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT ( w83b_32s00.desc_032
    || '|'
    || w83b_31s00.desc_031
    || '@'
    || w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT ( w83b_32s00.dese_032
    || '|'
    || w83b_31s00.dese_031
    || '@'
    || w83b_31s00.ctipvoz_031
    || '|'
    || w83b_31s00.cvoz_031
    || '|'
    || w83b_34s00.sino_034 ) ),
    stragg_int (DISTINCT (w83b_19s00.c_sindi_019)),
    stragg_int (DISTINCT ( w83b_19s00.desc_019
    || '@'
    || w83b_19s00.c_sindi_019 ) ),
    stragg_int (DISTINCT ( w83b_19s00.dese_019
    || '@'
    || w83b_19s00.c_sindi_019 ) ),
    TO_NUMBER ( w83b_33s00.ano_impug_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_impug_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_impug_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_impug_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_impug_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_impug_033), TO_CHAR (w83b_33s00.n_impug_033) ) ) AS nimpugnacionesint,
    TO_NUMBER ( w83b_33s00.ano_preaviso_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_preaviso_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_preaviso_033), TO_CHAR (w83b_33s00.n_preaviso_033) ) ) AS npreavisosint,
    TO_NUMBER ( w83b_33s00.ano_acta_033
    || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)), 1, '00000'
    || TO_CHAR (w83b_33s00.n_acta_033), 2, '0000'
    || TO_CHAR (w83b_33s00.n_acta_033), 3, '000'
    || TO_CHAR (w83b_33s00.n_acta_033), 4, '00'
    || TO_CHAR (w83b_33s00.n_acta_033), 5, '0'
    || TO_CHAR (w83b_33s00.n_acta_033), TO_CHAR (w83b_33s00.n_acta_033) ) ) AS nactasint,
    TO_NUMBER ( w83b_68s00.ano_laudo_068
    || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)), 1, '00'
    || TO_CHAR (w83b_68s00.n_laudo_068), 2, '0'
    || TO_CHAR (w83b_68s00.n_laudo_068), TO_CHAR (w83b_68s00.n_laudo_068) ) ) AS nlaudosint,
    stragg_int (DISTINCT (w83b_19s00.siglas_019))
  FROM w83b33s00 w83b_33s00,
    w83b68s00 w83b_68s00,
    w83b30s00 w83b_30s00,
    w83b59s00 w83b_59s00,
    w83b75s00 w83b_75s00,
    w83b34s00 w83b_34s00,
    w83b31s00 w83b_31s00,
    w83b32s00 w83b_32s00,
    w83b37s00 w83b_37s00,
    w83b16s00 w83b_16s00,
    w83b76s00 w83b_76s00,
    w83b36s00 w83b_36s00,
    w83b35s00 w83b_35s00,
    w83b19s00 w83b_19s00
  WHERE c_impug_033    = c_impug_030
  AND c_territ_033     = c_territ_068(+)
  AND n_impug_033      = n_impug_068(+)
  AND ano_impug_033    = ano_impug_068(+)
  AND c_territ_033     = c_territ_059(+)
  AND n_impug_033      = num_impugnac_059(+)
  AND ano_impug_033    = ano_impugn_059(+)
  AND rdo_laudo_068    = id_rdo_075(+)
  AND c_territ_068     = c_territ_034(+)
  AND n_impug_068      = n_impug_034(+)
  AND ano_impug_068    = ano_impug_034(+)
  AND n_laudo_068      = n_laudo_034(+)
  AND ano_laudo_068    = ano_laudo_034(+)
  AND ctipvoz_034      = ctipvoz_031(+)
  AND cvoz_034         = cvoz_031(+)
  AND ctipvoz_031      = ctipvoz_032(+)
  AND c_territ_033     = c_territ_037(+)
  AND n_preaviso_033   = n_preaviso_037(+)
  AND ano_preaviso_033 = ano_preaviso_037(+)
  AND c_territ_033     = c_territ_016(+)
  AND n_acta_033       = n_acta_016(+)
  AND ano_acta_033     = ano_acta_016(+)
  AND version_033      = version_016(+)
  AND c_territ_033     = c_territ_076(+)
  AND n_impug_033      = n_impug_076(+)
  AND ano_impug_033    = ano_impug_076(+)
  AND dni_033          = dni_036(+)
  AND c_territ_033     = w83b_36s00.c_territ_036(+)
  AND c_territ_033     = c_territ_035(+)
  AND n_impug_033      = n_impug_035(+)
  AND ano_impug_033    = ano_impug_035(+)
  AND c_sindi_035      = c_sindi_019(+)
  GROUP BY w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_impug_033
    || '/'
    || w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_preaviso_033
    || '/'
    || w83b_33s00.n_preaviso_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_33s00.ano_acta_033
    || '/'
    || w83b_33s00.n_acta_033,
    w83b_33s00.ano_impug_033,
    w83b_33s00.n_impug_033,
    w83b_33s00.c_territ_033,
    w83b_33s00.ano_preaviso_033,
    w83b_33s00.n_preaviso_033,
    w83b_33s00.ano_acta_033,
    w83b_33s00.n_acta_033,
    w83b_33s00.version_033,
    w83b_68s00.ano_laudo_068,
    w83b_68s00.n_laudo_068,
    w83b_33s00.f_impug_033,
    w83b_33s00.dni_033,
    w83b_36s00.nombre_036,
    w83b_33s00.fenvarb_033,
    w83b_33s00.fenvjuz_033,
    w83b_33s00.f_senten_033,
    w83b_33s00.c_impug_033,
    w83b_30s00.desc_030,
    w83b_30s00.dese_030,
    w83b_33s00.asunto_033,
    w83b_33s00.decisiob_033,
    w83b_33s00.c_territ_033
    || '/'
    || w83b_68s00.ano_laudo_068
    || '/'
    || w83b_68s00.n_laudo_068,
    w83b_68s00.flaudo_068,
    w83b_33s00.fdeses_033,
    w83b_68s00.rdo_laudo_068,
    w83b_75s00.desc_rdo_cas_075,
    w83b_75s00.desc_rdo_eus_075,
    w83b_16s00.id_centro_016,
    w83b_37s00.id_centro_037,
    w83b_33s00.n_regis_033,
    w83b_33s00.f_regis_033,
    w83b_76s00.dni_imp_076,
    w83b_76s00.nombre_imp_076,
    w83b_76s00.dir_imp_076,
    w83b_76s00.codpos_imp_076,
    w83b_76s00.mun_imp_076,
    w83b_76s00.prov_imp_076,
    w83b_59s00.id_centro_059;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTAINCIDENCIAS" ("NINCIDENCIAS", "ANYOINCIDENCIAS", "TERRITORIOINCIDENCIAS", "NUMINCIDENCIA", "NUMINCIDENCIACOMPLETOINT", "NUMINCIDENCIACOMPLETO", "NUMINCIDENCIASENCILLOCOMPLETO", "NACTA", "NACTACOMPLETO", "ANYOACTA", "VERSIONACTA", "NUMACTACOMPLETOINT", "NUMACTACOMPLETO", "NUMACTA", "NACTASPARCIAL", "ANYOACTASPARCIAL", "NUMACTAPARSENCILLOCOMPLETO", "FENTRADA", "FREGISTRO", "FVALIDACION", "TIPSOLICITANTE", "TIPSOLICITANTE_ES", "TIPSOLICITANTE_EU", "DNISOLICITANTE", "NOMSOLICITANTE", "TIPINCIDENCIA", "TIPINCIDENCIA_ES", "TIPINCIDENCIA_EU", "TRAMITACION", "FECACTUALIZACION", "FECMODIFICACION", "MAXTRAMITE", "NUMREG", "OBSERVACIONES", "FVALIDADA", "FLAGVALIDADA", "FECHABAJA", "NUMREGDEF", "FECHAREGDEF", "NUMACTACOMPLETOPARCIAL", "CODCENTRO")
AS
  SELECT t61.n_incid_061,
    t61.ano_incid_061,
    t61.c_territ_061,
    t61.c_territ_061
    || ''
    || t61.ano_incid_061
    || ''
    || t61.n_incid_061,
    TO_NUMBER ( t61.c_territ_061
    || t61.ano_incid_061
    || DECODE (LENGTH (TO_CHAR (t61.n_incid_061)), 1, '00000'
    || TO_CHAR (t61.n_incid_061), 2, '0000'
    || TO_CHAR (t61.n_incid_061), 3, '000'
    || TO_CHAR (t61.n_incid_061), 4, '00'
    || TO_CHAR (t61.n_incid_061), 5, '0'
    || TO_CHAR (t61.n_incid_061), TO_CHAR (t61.n_incid_061) ) ),
    TO_NUMBER ( t61.ano_incid_061
    || DECODE (LENGTH (TO_CHAR (t61.n_incid_061)), 1, '00000'
    || TO_CHAR (t61.n_incid_061), 2, '0000'
    || TO_CHAR (t61.n_incid_061), 3, '000'
    || TO_CHAR (t61.n_incid_061), 4, '00'
    || TO_CHAR (t61.n_incid_061), 5, '0'
    || TO_CHAR (t61.n_incid_061), TO_CHAR (t61.n_incid_061) ) ),
    DECODE (LENGTH (TO_CHAR (t61.n_incid_061)), 1, '00000'
    || TO_CHAR (t61.n_incid_061), 2, '0000'
    || TO_CHAR (t61.n_incid_061), 3, '000'
    || TO_CHAR (t61.n_incid_061), 4, '00'
    || TO_CHAR (t61.n_incid_061), 5, '0'
    || TO_CHAR (t61.n_incid_061), TO_CHAR (t61.n_incid_061) ),
    t61.n_acta_061,
    DECODE (LENGTH (TO_CHAR (t61.n_acta_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_061), 2, '0000'
    || TO_CHAR (t61.n_acta_061), 3, '000'
    || TO_CHAR (t61.n_acta_061), 4, '00'
    || TO_CHAR (t61.n_acta_061), 5, '0'
    || TO_CHAR (t61.n_acta_061), TO_CHAR (t61.n_acta_061) ),
    t61.ano_acta_061,
    t61.version_acta_061,
    TO_NUMBER ( t61.c_territ_061
    || t61.ano_acta_061
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_061), 2, '0000'
    || TO_CHAR (t61.n_acta_061), 3, '000'
    || TO_CHAR (t61.n_acta_061), 4, '00'
    || TO_CHAR (t61.n_acta_061), 5, '0'
    || TO_CHAR (t61.n_acta_061), TO_CHAR (t61.n_acta_061) ) ),
    TO_NUMBER ( t61.ano_acta_061
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_061), 2, '0000'
    || TO_CHAR (t61.n_acta_061), 3, '000'
    || TO_CHAR (t61.n_acta_061), 4, '00'
    || TO_CHAR (t61.n_acta_061), 5, '0'
    || TO_CHAR (t61.n_acta_061), TO_CHAR (t61.n_acta_061) ) ),
    DECODE (t61.n_acta_parcial_061, '', t61.c_territ_061
    || '/'
    || t61.ano_acta_061
    || '/'
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_061), 2, '0000'
    || TO_CHAR (t61.n_acta_061), 3, '000'
    || TO_CHAR (t61.n_acta_061), 4, '00'
    || TO_CHAR (t61.n_acta_061), 5, '0'
    || TO_CHAR (t61.n_acta_061), TO_CHAR (t61.n_acta_061) ), t61.c_territ_061
    || '/'
    || t61.ano_acta_parcial_061
    || '/'
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_parcial_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_parcial_061), 2, '0000'
    || TO_CHAR (t61.n_acta_parcial_061), 3, '000'
    || TO_CHAR (t61.n_acta_parcial_061), 4, '00'
    || TO_CHAR (t61.n_acta_parcial_061), 5, '0'
    || TO_CHAR (t61.n_acta_parcial_061), TO_CHAR (t61.n_acta_parcial_061) ) ),
    t61.n_acta_parcial_061,
    t61.ano_acta_parcial_061,
    DECODE (LENGTH (TO_CHAR (t61.n_acta_parcial_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_parcial_061), 2, '0000'
    || TO_CHAR (t61.n_acta_parcial_061), 3, '000'
    || TO_CHAR (t61.n_acta_parcial_061), 4, '00'
    || TO_CHAR (t61.n_acta_parcial_061), 5, '0'
    || TO_CHAR (t61.n_acta_parcial_061), TO_CHAR (t61.n_acta_parcial_061) ),
    t61.f_entrada_061,
    t61.f_registro_061,
    t61.f_validac_061,
    t61.tp_solicit_061,
    t63.desc_solic_063,
    t63.dese_solic_063,
    t61.dni_solic_061,
    t61.rz_social_061,
    t61.tp_incidencia_061,
    t62.desc_incid_062,
    t62.dese_incid_062,
    t72.c_tram_072,
    t72.f_actu_072,
    t72.f_modif_072,
    (SELECT MAX (t72_2.c_tram_072)
    FROM w83b72s00 t72_2
    WHERE t72_2.ano_incid_072 = t61.ano_incid_061
    AND t72_2.n_incid_072     = t61.n_incid_061
    AND t72_2.c_territ_072    = t61.c_territ_061
    ),
    t61.n_reg_ent_061,
    t61.observaciones_061,
    t61.f_validac_061,
    t61.validada_061,
    t16.f_baja_016,
    t16.n_regdef_016,
    t16.fregdef_016,
    DECODE (t61.n_acta_parcial_061, NULL, TO_NUMBER ( t61.ano_acta_061
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_061), 2, '0000'
    || TO_CHAR (t61.n_acta_061), 3, '000'
    || TO_CHAR (t61.n_acta_061), 4, '00'
    || TO_CHAR (t61.n_acta_061), 5, '0'
    || TO_CHAR (t61.n_acta_061), TO_CHAR (t61.n_acta_061) ) ), TO_NUMBER ( t61.ano_acta_parcial_061
    || DECODE (LENGTH (TO_CHAR (t61.n_acta_parcial_061)), 1, '00000'
    || TO_CHAR (t61.n_acta_parcial_061), 2, '0000'
    || TO_CHAR (t61.n_acta_parcial_061), 3, '000'
    || TO_CHAR (t61.n_acta_parcial_061), 4, '00'
    || TO_CHAR (t61.n_acta_parcial_061), 5, '0'
    || TO_CHAR (t61.n_acta_parcial_061), TO_CHAR (t61.n_acta_parcial_061) ) ) ),
    t16.id_centro_016
  FROM w83b61s00 t61,
    w83b62s00 t62,
    w83b63s00 t63,
    w83b72s00 t72,
    w83b16s00 t16
  WHERE t62.tp_incidencia_062 = t61.tp_incidencia_061
  AND t63.tp_solicit_063(+)   = t61.tp_solicit_061
  AND t72.ano_incid_072(+)    = t61.ano_incid_061
  AND t72.n_incid_072(+)      = t61.n_incid_061
  AND t72.c_territ_072(+)     = t61.c_territ_061
  AND t61.n_acta_061          = t16.n_acta_016
  AND t61.ano_acta_061        = t16.ano_acta_016
  AND t61.c_territ_061        = t16.c_territ_016
  AND t61.version_acta_061    = t16.version_016;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTARESPPERFIL" ("CPERFIL", "DESCCARGO", "DESECARGO", "TERRIT")
AS
  SELECT DISTINCT (t39.cperf_039),
    t39.pdes_039
    || '/'
    || t39.pdes_fem_039,
    t39.pdese_039,
    t40.c_territ_040
  FROM w83b39t00 t39,
    w83b40t00 t40
  WHERE t39.cperf_039 = t40.perfil_040
  AND t40.f_baja_040 IS NULL;

/****************************************************************************************************************************************************************/
CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTASECTOR" ("CODSECTOR", "DESCSECTOR")
AS
  SELECT sector.secc_004, sector.desc_004 FROM j7304s00 sector ;

/****************************************************************************************************************************************************************/
